/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curioofundying;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curioofundying.client.TotemRenderer;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="curioofundying")
public class CurioOfUndyingMod {
    public static final String MOD_ID = "curioofundying";

    public CurioOfUndyingMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::enqueue);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        CuriosRendererRegistry.register((Item)Items.f_42747_, TotemRenderer::new);
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
    }

    @SubscribeEvent
    public void attachCapabilities(final AttachCapabilitiesEvent<ItemStack> evt) {
        if (((ItemStack)evt.getObject()).m_41720_() != Items.f_42747_) {
            return;
        }
        final ICurio curio = new ICurio(){

            public ItemStack getStack() {
                return (ItemStack)evt.getObject();
            }

            public boolean canEquipFromUse(SlotContext ctx) {
                return true;
            }
        };
        ICapabilityProvider provider = new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
        evt.addCapability(CuriosCapability.ID_ITEM, provider);
    }

    public static boolean hasTotem(LivingEntity livingEntity) {
        ItemStack stack = CuriosApi.getCuriosHelper().findEquippedCurio(Items.f_42747_, livingEntity).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            stack.m_41774_(1);
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.m_6278_(Stats.f_12982_.m_12902_((Object)Items.f_42747_), 1);
                CriteriaTriggers.f_10551_.m_74431_(player, stack);
            }
            livingEntity.m_21153_(1.0f);
            livingEntity.m_21219_();
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
            livingEntity.f_19853_.m_7605_((Entity)livingEntity, (byte)35);
            return true;
        }
        return false;
    }
}

