/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.apiimpl.network.node.CrafterManagerNetworkNode;
import com.refinedmods.refinedstorage.blockentity.CrafterManagerBlockEntity;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.container.CrafterManagerContainerMenu;
import com.refinedmods.refinedstorage.container.slot.CrafterManagerSlot;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.IScreenInfoProvider;
import com.refinedmods.refinedstorage.screen.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.screen.widget.SearchWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.CrafterManagerSearchBoxModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.GridSizeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.Map;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class CrafterManagerScreen
extends BaseScreen<CrafterManagerContainerMenu>
implements IScreenInfoProvider {
    private final CrafterManagerNetworkNode crafterManager;
    private ScrollbarWidget scrollbar;
    private SearchWidget searchField;

    public CrafterManagerScreen(CrafterManagerContainerMenu containerMenu, Inventory inventory, Component title) {
        super(containerMenu, 193, 0, inventory, title);
        this.crafterManager = (CrafterManagerNetworkNode)((CrafterManagerBlockEntity)containerMenu.getBlockEntity()).getNode();
    }

    @Override
    protected void onPreInit() {
        this.f_97727_ = this.getTopHeight() + this.getBottomHeight() + this.getVisibleRows() * 18;
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addSideButton(new RedstoneModeSideButton(this, NetworkNodeBlockEntity.REDSTONE_MODE));
        this.addSideButton(new CrafterManagerSearchBoxModeSideButton(this));
        this.addSideButton(new GridSizeSideButton(this, this.crafterManager::getSize, size -> BlockEntitySynchronizationManager.setParameter(CrafterManagerBlockEntity.SIZE, size)));
        this.scrollbar = new ScrollbarWidget(this, 174, this.getTopHeight(), 12, this.getVisibleRows() * 18 - 2);
        this.scrollbar.addListener((oldOffset, newOffset) -> ((CrafterManagerContainerMenu)this.f_97732_).initSlots(null));
        ((CrafterManagerContainerMenu)this.f_97732_).initSlots(null);
        int sx = x + 97 + 1;
        int sy = y + 6 + 1;
        if (this.searchField == null) {
            this.searchField = new SearchWidget(this.f_96547_, sx, sy, 82);
            this.searchField.m_94151_(value -> {
                this.searchField.updateJei();
                ((CrafterManagerContainerMenu)this.f_97732_).initSlots(null);
            });
            this.searchField.setMode(this.crafterManager.getSearchBoxMode());
        } else {
            this.searchField.f_93620_ = sx;
            this.searchField.f_93621_ = sy;
        }
        this.m_142416_((GuiEventListener)this.searchField);
    }

    @Override
    public void tick(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() - 1 >= this.getVisibleRows());
        this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
    }

    @Override
    public void renderBackground(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/crafter_manager.png");
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.getTopHeight());
        int rows = this.getVisibleRows();
        int yy = y;
        for (int i = 0; i < rows; ++i) {
            yy += 18;
            int yTextureStart = this.getTopHeight();
            if (i > 0) {
                yTextureStart = i == rows - 1 ? (yTextureStart += 36) : (yTextureStart += 18);
            }
            this.m_93228_(poseStack, x, yy, 0, yTextureStart, this.f_97726_, 18);
        }
        this.m_93228_(poseStack, x, yy += 18, 0, this.getTopHeight() + 54, this.f_97726_, this.getBottomHeight());
        if (this.crafterManager.isActiveOnClient()) {
            for (Slot slot : ((CrafterManagerContainerMenu)this.f_97732_).f_38839_) {
                if (!(slot instanceof CrafterManagerSlot) || !slot.m_6659_()) continue;
                this.m_93228_(poseStack, x + slot.f_40220_ - 1, y + slot.f_40221_ - 1, 0, 193, 18, 18);
            }
        }
        this.searchField.m_6305_(poseStack, 0, 0, 0.0f);
        this.scrollbar.render(poseStack);
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
        this.renderString(poseStack, 7, 7, this.f_96539_.getString());
        this.renderString(poseStack, 7, this.getYPlayerInventory() - 12, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]));
        if (this.f_97732_ != null && this.crafterManager.isActiveOnClient()) {
            for (Map.Entry<String, Integer> heading : ((CrafterManagerContainerMenu)this.f_97732_).getHeadings().entrySet()) {
                int y = heading.getValue();
                if (y < this.getTopHeight() - 1 || y >= this.getTopHeight() + this.getVisibleRows() * 18 - 1) continue;
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.bindTexture("refinedstorage", "gui/crafter_manager.png");
                this.m_93228_(poseStack, 7, y, 0, 174, 162, 18);
                this.renderString(poseStack, 11, y + 6, RenderUtils.shorten(I18n.m_118938_((String)heading.getKey(), (Object[])new Object[0]), 25));
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickedButton) {
        if (this.scrollbar.m_6375_(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, clickedButton);
    }

    public boolean m_5534_(char unknown1, int unknown2) {
        if (this.searchField.m_5534_(unknown1, unknown2)) {
            return true;
        }
        return super.m_5534_(unknown1, unknown2);
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (this.searchField.m_7933_(key, scanCode, modifiers) || this.searchField.m_94204_()) {
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public void m_94757_(double mx, double my) {
        this.scrollbar.m_94757_(mx, my);
        super.m_94757_(mx, my);
    }

    public boolean m_6348_(double mx, double my, int button) {
        return this.scrollbar.m_6348_(mx, my, button) || super.m_6348_(mx, my, button);
    }

    public boolean m_6050_(double x, double y, double delta) {
        return this.scrollbar.m_6050_(x, y, delta) || super.m_6050_(x, y, delta);
    }

    public SearchWidget getSearchField() {
        return this.searchField;
    }

    public CrafterManagerNetworkNode getCrafterManager() {
        return this.crafterManager;
    }

    @Override
    public int getTopHeight() {
        return 19;
    }

    @Override
    public int getBottomHeight() {
        return 99;
    }

    @Override
    public int getVisibleRows() {
        switch (this.crafterManager.getSize()) {
            case 0: {
                int screenSpaceAvailable = this.f_96544_ - this.getTopHeight() - this.getBottomHeight();
                return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, RS.CLIENT_CONFIG.getCrafterManager().getMaxRowsStretch()));
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
        }
        return 3;
    }

    @Override
    public int getRows() {
        return !this.crafterManager.isActiveOnClient() ? 0 : ((CrafterManagerContainerMenu)this.f_97732_).getRows();
    }

    @Override
    public int getCurrentOffset() {
        return this.scrollbar == null ? 0 : this.scrollbar.getOffset();
    }

    @Override
    public String getSearchFieldText() {
        return this.searchField == null ? "" : this.searchField.m_94155_();
    }

    @Override
    public int getYPlayerInventory() {
        return this.getTopHeight() + this.getVisibleRows() * 18 + 16;
    }
}

