/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.api.util.StackListResult;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class GridFluidDeltaMessage {
    @Nullable
    private INetwork network;
    private List<StackListResult<FluidStack>> deltas;
    private List<Pair<IGridStack, Integer>> clientDeltas;

    public GridFluidDeltaMessage(INetwork network, List<StackListResult<FluidStack>> deltas) {
        this.network = network;
        this.deltas = deltas;
    }

    public GridFluidDeltaMessage(List<Pair<IGridStack, Integer>> clientDeltas) {
        this.clientDeltas = clientDeltas;
    }

    public static GridFluidDeltaMessage decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        LinkedList<Pair<IGridStack, Integer>> clientDeltas = new LinkedList<Pair<IGridStack, Integer>>();
        for (int i = 0; i < size; ++i) {
            int delta = buf.readInt();
            clientDeltas.add((Pair<IGridStack, Integer>)Pair.of((Object)StackUtils.readFluidGridStack(buf), (Object)delta));
        }
        return new GridFluidDeltaMessage(clientDeltas);
    }

    public static void encode(GridFluidDeltaMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.deltas.size());
        for (StackListResult<FluidStack> delta : message.deltas) {
            buf.writeInt(delta.getChange());
            StackListEntry<FluidStack> craftingEntry = message.network.getFluidStorageCache().getCraftablesList().getEntry(delta.getStack(), 1);
            StackUtils.writeFluidGridStack(buf, delta.getStack(), delta.getId(), craftingEntry != null ? craftingEntry.getId() : null, false, message.network.getFluidStorageTracker().get(delta.getStack()));
        }
    }

    public static void handle(GridFluidDeltaMessage message, Supplier<NetworkEvent.Context> ctx) {
        BaseScreen.executeLater(GridScreen.class, grid -> message.clientDeltas.forEach(p -> grid.getView().postChange((IGridStack)p.getLeft(), (Integer)p.getRight())));
        ctx.get().setPacketHandled(true);
    }
}

