/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.widgets.ChannelButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.CardRedstoneContainer;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketOpenNode;
import com.direwolf20.laserio.common.network.packets.PacketUpdateRedstoneCard;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class CardRedstoneScreen
extends AbstractContainerScreen<CardRedstoneContainer> {
    private final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/redstonecard.png");
    protected final CardRedstoneContainer container;
    protected byte currentMode;
    protected byte currentRedstoneChannel;
    protected boolean currentStrong;
    protected final ItemStack card;
    protected Map<String, Button> buttons = new HashMap<String, Button>();

    public CardRedstoneScreen(CardRedstoneContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.card = container.cardItem;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Button channelButton;
        Button strongButton;
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        Button modeButton = this.buttons.get("mode");
        if (MiscTools.inBounds(modeButton.f_93620_, modeButton.f_93621_, modeButton.m_5711_(), modeButton.m_93694_(), mouseX, mouseY)) {
            TranslatableComponent[] translatableComponents = new TranslatableComponent[3];
            translatableComponents[0] = new TranslatableComponent("screen.laserio.input");
            translatableComponents[1] = new TranslatableComponent("screen.laserio.output");
            this.m_96602_(matrixStack, (Component)translatableComponents[this.currentMode], mouseX, mouseY);
        }
        if (this.currentMode == 1 && MiscTools.inBounds(strongButton.f_93620_, strongButton.f_93621_, (strongButton = this.buttons.get("strong")).m_5711_(), strongButton.m_93694_(), mouseX, mouseY)) {
            TranslatableComponent[] translatableComponents = new TranslatableComponent[]{new TranslatableComponent("screen.laserio.weak"), new TranslatableComponent("screen.laserio.strong")};
            this.m_96602_(matrixStack, (Component)translatableComponents[this.currentStrong ? 1 : 0], mouseX, mouseY);
        }
        if (MiscTools.inBounds(channelButton.f_93620_, channelButton.f_93621_, (channelButton = this.buttons.get("channel")).m_5711_(), channelButton.m_93694_(), mouseX, mouseY)) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("screen.laserio.redstonechannel").m_130946_(String.valueOf(this.currentRedstoneChannel)), mouseX, mouseY);
        }
    }

    public void addModeButton() {
        ResourceLocation[] modeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstoneinput.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstoneoutput.png")};
        this.buttons.put("mode", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, modeTextures, this.currentMode, button -> {
            this.currentMode = CardRedstone.nextTransferMode(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentMode);
            this.modeChange();
        }));
    }

    public void addStrongButton() {
        ResourceLocation[] strongTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstonelow.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonehigh.png")};
        this.buttons.put("strong", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, strongTextures, this.currentStrong ? 1 : 0, button -> {
            this.currentStrong = !this.currentStrong;
            ((ToggleButton)button).setTexturePosition(this.currentStrong ? 1 : 0);
        }));
    }

    public void addChannelButton() {
        this.buttons.put("channel", new ChannelButton(this.getGuiLeft() + 5, this.getGuiTop() + 65, 16, 16, this.currentRedstoneChannel, button -> {
            this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentRedstoneChannel);
        }));
    }

    public void m_7856_() {
        super.m_7856_();
        this.currentMode = CardRedstone.getTransferMode(this.card);
        this.currentRedstoneChannel = CardRedstone.getRedstoneChannel(this.card);
        this.currentStrong = CardRedstone.getStrong(this.card);
        this.addModeButton();
        this.addChannelButton();
        this.addStrongButton();
        if (this.container.direction != -1) {
            this.buttons.put("return", new Button(this.getGuiLeft() - 25, this.getGuiTop() + 1, 25, 20, (Component)new TextComponent("<--"), button -> this.openNode()));
        }
        for (Map.Entry<String, Button> button2 : this.buttons.entrySet()) {
            this.m_142416_((GuiEventListener)button2.getValue());
        }
        this.modeChange();
    }

    public void modeChange() {
        Button strongButton = this.buttons.get("strong");
        if (this.currentMode == 0) {
            this.m_169411_((GuiEventListener)strongButton);
        } else if (this.currentMode == 1 && !this.f_169369_.contains(strongButton)) {
            this.m_142416_((GuiEventListener)strongButton);
        }
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrixStack, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.saveSettings();
        super.m_7379_();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private static TranslatableComponent getTrans(String key, Object ... args) {
        return new TranslatableComponent("laserio." + key, args);
    }

    public void saveSettings() {
        PacketHandler.sendToServer(new PacketUpdateRedstoneCard(this.currentMode, this.currentRedstoneChannel, this.currentStrong));
    }

    public void openNode() {
        this.saveSettings();
        PacketHandler.sendToServer(new PacketOpenNode(this.container.sourceContainer, this.container.direction));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    public boolean m_6375_(double x, double y, int btn) {
        ChannelButton channelButton = (ChannelButton)this.buttons.get("channel");
        if (MiscTools.inBounds(channelButton.f_93620_, channelButton.f_93621_, channelButton.m_5711_(), channelButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            } else if (btn == 1) {
                this.currentRedstoneChannel = CardRedstone.previousRedstoneChannel(this.card);
            }
            channelButton.setChannel(this.currentRedstoneChannel);
            channelButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        return super.m_6375_(x, y, btn);
    }
}

