/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.logistics.energy;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.item.IEnergyContainingItem;
import owmii.powah.lib.util.Stack;
import owmii.powah.lib.util.Util;

public class Energy {
    public static final Energy EMPTY = Energy.create(0L);
    public static final long MAX = 9000000000000000000L;
    public static final long MIN = 0L;
    private long capacity;
    private long stored;
    private long maxExtract;
    private long maxReceive;
    @Nullable
    public Object platformWrapper;

    public Energy(Energy energy) {
        this(energy.capacity, energy.maxExtract, energy.maxReceive);
        this.setStored(energy.stored);
    }

    public Energy(long capacity, long maxExtract, long maxReceive) {
        this.capacity = capacity;
        this.maxExtract = maxExtract;
        this.maxReceive = maxReceive;
    }

    public static Energy create(long capacity) {
        return Energy.create(capacity, capacity, capacity);
    }

    public static Energy create(long capacity, long transfer) {
        return Energy.create(capacity, transfer, transfer);
    }

    public static Energy from(Energy energy) {
        return new Energy(energy);
    }

    public static Energy create(long capacity, long maxExtract, long maxReceive) {
        return new Energy(capacity, maxExtract, maxReceive);
    }

    public boolean clone(Energy other) {
        boolean flag = false;
        if (this.capacity != other.capacity) {
            this.setCapacity(other.getCapacity());
            flag = true;
        }
        if (this.stored != other.stored) {
            this.setStored(other.getStored());
            flag = true;
        }
        if (this.getTransfer() != other.getTransfer()) {
            this.setTransfer(other.getTransfer());
            flag = true;
        }
        return flag;
    }

    public Energy read(CompoundTag nbt, boolean capacity, boolean transfer) {
        return this.read(nbt, "main_energy", capacity, transfer);
    }

    public Energy read(CompoundTag nbt, String key, boolean capacity, boolean transfer) {
        if (capacity) {
            this.capacity = nbt.m_128454_("energy_capacity_" + key);
        }
        this.stored = nbt.m_128454_("energy_stored_" + key);
        if (transfer) {
            this.maxExtract = nbt.m_128454_("max_extract_" + key);
            this.maxReceive = nbt.m_128454_("max_receive_" + key);
        }
        return this;
    }

    public CompoundTag write(boolean capacity, boolean transfer) {
        return this.write("main_energy", capacity, transfer);
    }

    public CompoundTag write(String key, boolean capacity, boolean transfer) {
        return this.write(new CompoundTag(), key, capacity, transfer);
    }

    public CompoundTag write(CompoundTag nbt, boolean capacity, boolean transfer) {
        return this.write(nbt, "main_energy", capacity, transfer);
    }

    public CompoundTag write(CompoundTag nbt, String key, boolean capacity, boolean transfer) {
        if (capacity) {
            nbt.m_128356_("energy_capacity_" + key, this.capacity);
        }
        nbt.m_128356_("energy_stored_" + key, this.stored);
        if (transfer) {
            nbt.m_128356_("max_extract_" + key, this.maxExtract);
            nbt.m_128356_("max_receive_" + key, this.maxReceive);
        }
        return nbt;
    }

    public long receiveEnergy(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long received = Math.min(this.capacity - this.stored, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.produce(received);
        }
        return Util.safeInt(received);
    }

    public long extractEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long extracted = Math.min(this.stored, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.consume(extracted);
        }
        return Util.safeInt(extracted);
    }

    public void addCapacity(long amount) {
        this.setCapacity(this.getCapacity() + amount);
    }

    public void removeCapacity(long amount) {
        this.setCapacity(this.getCapacity() - amount);
    }

    public long produce(long amount) {
        long min = Math.min(this.capacity - this.stored, Math.max(0L, amount));
        this.stored += min;
        return min;
    }

    public long consume(long amount) {
        long min = Math.min(this.stored, Math.max(0L, amount));
        this.stored -= min;
        return min;
    }

    public long getEmpty() {
        return this.getCapacity() - this.getStored();
    }

    public long getCapacity() {
        return this.capacity;
    }

    public Energy setCapacity(long capacity) {
        this.capacity = Math.max(0L, Math.min(9000000000000000000L, capacity));
        if (this.stored > this.capacity) {
            this.stored = this.capacity;
        }
        return this;
    }

    public Energy setAll(long value) {
        this.setCapacity(value);
        this.setTransfer(value);
        return this;
    }

    public long getStored() {
        return Math.min(this.stored, this.capacity);
    }

    public Energy setStored(long stored) {
        this.stored = Math.max(0L, Math.min(this.capacity, stored));
        return this;
    }

    public long getMaxExtract() {
        return this.maxExtract;
    }

    public Energy setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public long getMaxReceive() {
        return this.maxReceive;
    }

    public Energy setMaxReceive(long maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public Energy setMaxTransfer() {
        this.maxReceive = 9000000000000000000L;
        this.maxExtract = 9000000000000000000L;
        return this;
    }

    public Energy setTransfer(long transfer) {
        this.maxReceive = transfer;
        this.maxExtract = transfer;
        return this;
    }

    public long getTransfer() {
        return Math.max(this.maxExtract, this.maxReceive);
    }

    public long getEnergyStored() {
        return this.stored;
    }

    public long getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0L && !this.isEmpty();
    }

    public boolean canReceive() {
        return this.maxReceive > 0L && !this.isFull();
    }

    public int toComparatorPower() {
        return (int)(this.subSized() * 15.0f);
    }

    public float subSized() {
        return this.capacity > 0L ? (float)this.stored / (float)this.capacity : 0.0f;
    }

    public boolean hasEnergy() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.stored <= 0L;
    }

    public boolean isFull() {
        return this.stored > 0L && this.stored >= this.capacity;
    }

    public long getPercent() {
        return (long)(this.subSized() * 100.0f);
    }

    public static long extract(ItemStack stack, long energy, boolean simulate) {
        return Energy.getEnergy(stack).orElse(EMPTY).extractEnergy(Util.safeInt(energy), simulate);
    }

    public static long receive(ItemStack stack, long energy, boolean simulate) {
        return Energy.getEnergy(stack).orElse(EMPTY).receiveEnergy(Util.safeInt(energy), simulate);
    }

    public static long getStored(ItemStack stack) {
        return Energy.getEnergy(stack).orElse(EMPTY).getEnergyStored();
    }

    public static void ifPresent(ItemStack stack, Consumer<Item> energyItem) {
        Energy.get(stack).ifPresent(energyItem);
    }

    public static Optional<Item> get(ItemStack stack) {
        net.minecraft.world.item.Item item = stack.m_41720_();
        if (item instanceof IEnergyContainingItem) {
            IEnergyContainingItem eci = (IEnergyContainingItem)item;
            return Optional.ofNullable(eci.getEnergyInfo()).map(info -> new Item(stack, (IEnergyContainingItem.Info)info));
        }
        return Optional.empty();
    }

    public static Optional<Energy> getEnergy(ItemStack stack) {
        return Energy.get(stack).map(x -> x);
    }

    public static boolean chargeable(ItemStack stack) {
        EnergyBlockItem item;
        if (stack.m_41720_() instanceof EnergyBlockItem && !(item = (EnergyBlockItem)stack.m_41720_()).isChargeable(stack)) {
            return false;
        }
        return Energy.isPresent(stack);
    }

    public static boolean isPresent(ItemStack stack) {
        return Energy.get(stack).isPresent();
    }

    public static class Item
    extends Energy {
        private final ItemStack stack;

        public Item(ItemStack stack, Item energy) {
            super(energy);
            this.stack = stack;
        }

        public Item(ItemStack stack, IEnergyContainingItem.Info info) {
            this(stack, info.capacity(), info.maxExtract(), info.maxInsert());
        }

        public Item(ItemStack stack, long capacity, long maxExtract, long maxReceive) {
            super(capacity, maxExtract, maxReceive);
            this.stack = stack;
            this.read(Stack.getTagOrEmpty(stack).m_128469_("powah_tile_data"), false, false);
        }

        @Override
        public long receiveEnergy(long maxReceive, boolean simulate) {
            long energy = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                this.write(this.stack.m_41698_("powah_tile_data"), false, false);
            }
            return energy;
        }

        @Override
        public long extractEnergy(long maxExtract, boolean simulate) {
            long energy = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                this.write(this.stack.m_41698_("powah_tile_data"), false, false);
            }
            return energy;
        }

        public void setStoredAndWrite(long stored) {
            this.setStored(stored);
            this.write(this.stack.m_41698_("powah_tile_data"), false, false);
        }
    }
}

