/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.client.wiki.page.panel.InfoBox;
import owmii.powah.lib.item.IEnergyContainingItem;
import owmii.powah.lib.item.IEnergyItemProvider;
import owmii.powah.lib.item.VarItem;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.util.Util;

public abstract class EnergyItem<V extends Enum<V>, C extends IEnergyConfig<V>, I extends EnergyItem<V, C, I>>
extends VarItem<V, I>
implements InfoBox.IInfoBoxHolder,
IEnergyItemProvider,
IEnergyContainingItem {
    public EnergyItem(Item.Properties properties, V variant) {
        super(properties, variant);
    }

    public EnergyItem(Item.Properties properties) {
        super(properties);
    }

    public abstract IEnergyConfig<V> getConfig();

    @Override
    public IEnergyContainingItem.Info getEnergyInfo() {
        IEnergyConfig config = this.getConfig();
        return new IEnergyContainingItem.Info(config.getCapacity(this.getVariant()), config.getTransfer(this.getVariant()), config.getTransfer(this.getVariant()));
    }

    @Override
    public boolean isChargeable(ItemStack stack) {
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Energy.ifPresent(stack, energy -> {
            if (energy.getCapacity() > 0L) {
                tooltip.add((Component)new TranslatableComponent("info.lollipop.stored").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Text.COLON).m_7220_((Component)new TranslatableComponent("info.lollipop.fe.stored", new Object[]{Util.addCommas(energy.getStored()), Util.numFormat(energy.getCapacity())}).m_130940_(ChatFormatting.DARK_GRAY)));
                tooltip.add((Component)new TranslatableComponent("info.lollipop.max.io").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Text.COLON).m_7220_((Component)new TranslatableComponent("info.lollipop.fe.pet.tick", new Object[]{Util.numFormat(energy.getMaxExtract())}).m_130940_(ChatFormatting.DARK_GRAY)));
                tooltip.add((Component)new TextComponent(""));
            }
        });
    }

    @Override
    public InfoBox getInfoBox(ItemStack stack, InfoBox box) {
        Energy.ifPresent(stack, energy -> {
            box.set((BaseComponent)new TranslatableComponent("info.lollipop.capacity"), (BaseComponent)new TranslatableComponent("info.lollipop.fe", new Object[]{Util.addCommas(energy.getCapacity())}));
            box.set((BaseComponent)new TranslatableComponent("info.lollipop.max.io"), (BaseComponent)new TranslatableComponent("info.lollipop.fe.pet.tick", new Object[]{Util.addCommas(energy.getMaxExtract())}));
        });
        return box;
    }
}

