/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.forge.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import owmii.powah.api.PowahAPI;

public class CoolantCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("powah", "textures/gui/jei/misc.png");
    public static final ResourceLocation ID = new ResourceLocation("powah", ".coolant");
    private final IDrawable background;
    private final IDrawable icon;

    public CoolantCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 24).addPadding(1, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Items.f_42447_));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("gui.powah.jei.category.coolant");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(recipe.fluid(), 1000));
        ingredients.setInputs((IIngredientType)VanillaTypes.ITEM_STACK, recipe.buckets());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluidStack = iRecipeLayout.getFluidStacks();
        fluidStack.init(0, true, 4, 5);
        fluidStack.set(ingredients);
    }

    public void draw(Recipe recipe, PoseStack matrix, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.f_91062_.m_92883_(matrix, I18n.m_118938_((String)"info.lollipop.temperature", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)"info.lollipop.temperature.c", (Object[])new Object[]{"" + ChatFormatting.DARK_AQUA + recipe.coldness}), 30.0f, 9.0f, 0x444444);
    }

    public static List<Recipe> getRecipes(IIngredientManager ingredientManager) {
        IdentityHashMap fluidsAndBuckets = new IdentityHashMap();
        for (Fluid fluid : Registry.f_122822_) {
            if (PowahAPI.getCoolant(fluid) == 0) continue;
            fluidsAndBuckets.put(fluid, new ArrayList());
        }
        for (ItemStack stack : ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
            BucketItem bucketItem;
            List buckets;
            Item item = stack.m_41720_();
            if (!(item instanceof BucketItem) || (buckets = (List)fluidsAndBuckets.get((bucketItem = (BucketItem)item).getFluid())) == null) continue;
            buckets.add(stack);
        }
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (Map.Entry entry : fluidsAndBuckets.entrySet()) {
            int temperature = PowahAPI.getCoolant((Fluid)entry.getKey());
            if (temperature == 0) continue;
            recipes.add(new Recipe((Fluid)entry.getKey(), (List)entry.getValue(), temperature));
        }
        recipes.sort(Comparator.comparingInt(Recipe::coldness).reversed());
        return recipes;
    }

    public record Recipe(Fluid fluid, List<ItemStack> buckets, int coldness) {
    }
}

