/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import owmii.powah.EnvHandler;
import owmii.powah.block.cable.CableTile;
import owmii.powah.client.model.AbstractModel;
import owmii.powah.client.render.tile.CableRenderer;
import owmii.powah.lib.logistics.Transfer;

public class CableModel
extends AbstractModel<CableTile, CableRenderer> {
    private static final String NORTH = "north";
    private static final String NORTH_PLATE = "north_plate";
    private static final String SOUTH = "south";
    private static final String SOUTH_PLATE = "south_plate";
    private static final String WEST = "west";
    private static final String WEST_PLATE = "west_plate";
    private static final String EAST = "east";
    private static final String EAST_PLATE = "east_plate";
    private static final String DOWN = "down";
    private static final String DOWN_PLATE = "down_plate";
    private static final String UP = "up";
    private static final String UP_PLATE = "up_plate";
    private final ModelPart north;
    private final ModelPart northPlate;
    private final ModelPart south;
    private final ModelPart southPlate;
    private final ModelPart west;
    private final ModelPart westPlate;
    private final ModelPart east;
    private final ModelPart eastPlate;
    private final ModelPart down;
    private final ModelPart downPlate;
    private final ModelPart upPlate;
    private final ModelPart up;
    private static final Map<Transfer, ResourceLocation> TEXTURES = new HashMap<Transfer, ResourceLocation>();

    public CableModel(ModelPart root) {
        super(RenderType::m_110446_);
        this.north = root.m_171324_(NORTH);
        this.northPlate = root.m_171324_(NORTH_PLATE);
        this.south = root.m_171324_(SOUTH);
        this.southPlate = root.m_171324_(SOUTH_PLATE);
        this.west = root.m_171324_(WEST);
        this.westPlate = root.m_171324_(WEST_PLATE);
        this.east = root.m_171324_(EAST);
        this.eastPlate = root.m_171324_(EAST_PLATE);
        this.down = root.m_171324_(DOWN);
        this.downPlate = root.m_171324_(DOWN_PLATE);
        this.up = root.m_171324_(UP);
        this.upPlate = root.m_171324_(UP_PLATE);
    }

    public static LayerDefinition createDefinition() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        PartPose pos = PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f);
        root.m_171599_(NORTH, CubeListBuilder.m_171558_().m_171514_(0, 10).m_171480_().m_171481_(-1.5f, -1.5f, -7.75f, 3.0f, 3.0f, 6.0f), pos);
        root.m_171599_(NORTH_PLATE, CubeListBuilder.m_171558_().m_171514_(0, 20).m_171480_().m_171481_(-2.5f, -2.5f, -8.2f, 5.0f, 5.0f, 1.0f), pos);
        root.m_171599_(SOUTH, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(-1.5f, -1.5f, 1.75f, 3.0f, 3.0f, 6.0f), pos);
        root.m_171599_(SOUTH_PLATE, CubeListBuilder.m_171558_().m_171514_(0, 20).m_171480_().m_171481_(-2.5f, -2.5f, 7.2f, 5.0f, 5.0f, 1.0f), pos);
        root.m_171599_(WEST, CubeListBuilder.m_171558_().m_171514_(19, 0).m_171480_().m_171481_(-7.75f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), pos);
        root.m_171599_(WEST_PLATE, CubeListBuilder.m_171558_().m_171514_(13, 20).m_171480_().m_171481_(-8.2f, -2.5f, -2.5f, 1.0f, 5.0f, 5.0f), pos);
        root.m_171599_(EAST, CubeListBuilder.m_171558_().m_171514_(19, 7).m_171480_().m_171481_(1.75f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), pos);
        root.m_171599_(EAST_PLATE, CubeListBuilder.m_171558_().m_171514_(13, 20).m_171480_().m_171481_(7.2f, -2.5f, -2.5f, 1.0f, 5.0f, 5.0f), pos);
        root.m_171599_(DOWN, CubeListBuilder.m_171558_().m_171514_(38, 10).m_171480_().m_171481_(-1.5f, -7.75f, -1.5f, 3.0f, 6.0f, 3.0f), pos);
        root.m_171599_(DOWN_PLATE, CubeListBuilder.m_171558_().m_171514_(26, 20).m_171480_().m_171481_(-2.5f, -8.2f, -2.5f, 5.0f, 1.0f, 5.0f), pos);
        root.m_171599_(UP, CubeListBuilder.m_171558_().m_171514_(38, 0).m_171480_().m_171481_(-1.5f, 1.75f, -1.5f, 3.0f, 6.0f, 3.0f), pos);
        root.m_171599_(UP_PLATE, CubeListBuilder.m_171558_().m_171514_(26, 20).m_171480_().m_171481_(-2.5f, 7.2f, -2.5f, 5.0f, 1.0f, 5.0f), pos);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    @Override
    public void render(CableTile te, CableRenderer renderer, PoseStack matrix, MultiBufferSource rtb, int light, int ov) {
        VertexConsumer buffer;
        Transfer type;
        if (te.m_58904_() == null) {
            return;
        }
        Direction[] flags = new Direction[6];
        for (Direction side : te.energySides) {
            BlockPos pos = te.m_58899_().m_142300_(side);
            BlockEntity tile = te.m_58904_().m_7702_(pos);
            Transfer config = te.getSideConfig().getType(side);
            if (tile instanceof CableTile || !EnvHandler.INSTANCE.hasEnergy(te.m_58904_(), pos, side.m_122424_()) || !config.canExtract && !config.canReceive) continue;
            flags[side.m_122411_()] = side;
        }
        if (flags[0] != null && !(type = te.getSideConfig().getType(flags[0])).equals((Object)Transfer.NONE)) {
            buffer = rtb.m_6299_(this.m_103119_(TEXTURES.get((Object)type)));
            this.up.m_104301_(matrix, buffer, light, ov);
            this.upPlate.m_104301_(matrix, buffer, light, ov);
        }
        if (flags[1] != null && !(type = te.getSideConfig().getType(flags[1])).equals((Object)Transfer.NONE)) {
            buffer = rtb.m_6299_(this.m_103119_(TEXTURES.get((Object)type)));
            this.down.m_104301_(matrix, buffer, light, ov);
            this.downPlate.m_104301_(matrix, buffer, light, ov);
        }
        if (flags[2] != null && !(type = te.getSideConfig().getType(flags[2])).equals((Object)Transfer.NONE)) {
            buffer = rtb.m_6299_(this.m_103119_(TEXTURES.get((Object)type)));
            this.south.m_104301_(matrix, buffer, light, ov);
            this.southPlate.m_104301_(matrix, buffer, light, ov);
        }
        if (flags[3] != null && !(type = te.getSideConfig().getType(flags[3])).equals((Object)Transfer.NONE)) {
            buffer = rtb.m_6299_(this.m_103119_(TEXTURES.get((Object)type)));
            this.north.m_104301_(matrix, buffer, light, ov);
            this.northPlate.m_104301_(matrix, buffer, light, ov);
        }
        if (flags[4] != null && !(type = te.getSideConfig().getType(flags[4])).equals((Object)Transfer.NONE)) {
            buffer = rtb.m_6299_(this.m_103119_(TEXTURES.get((Object)type)));
            this.west.m_104301_(matrix, buffer, light, ov);
            this.westPlate.m_104301_(matrix, buffer, light, ov);
        }
        if (flags[5] != null && !(type = te.getSideConfig().getType(flags[5])).equals((Object)Transfer.NONE)) {
            buffer = rtb.m_6299_(this.m_103119_(TEXTURES.get((Object)type)));
            this.east.m_104301_(matrix, buffer, light, ov);
            this.eastPlate.m_104301_(matrix, buffer, light, ov);
        }
    }

    static {
        TEXTURES.put(Transfer.ALL, new ResourceLocation("powah", "textures/model/tile/energy_cable_all.png"));
        TEXTURES.put(Transfer.RECEIVE, new ResourceLocation("powah", "textures/model/tile/energy_cable_out.png"));
        TEXTURES.put(Transfer.EXTRACT, new ResourceLocation("powah", "textures/model/tile/energy_cable_in.png"));
    }
}

