/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.delogger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.unrealdinnerbone.delogger.DeLoggerConfig;
import com.unrealdinnerbone.delogger.LoggerFilter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.OnStartupTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LoggerHacks {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void init() {
        Path configFile = FMLPaths.CONFIGDIR.get().resolve("delogger2.json");
        if (LoggerHacks.createFile(configFile)) {
            try {
                DeLoggerConfig config = LoggerHacks.createConfig(configFile);
                LoggerHacks.disableLogger(config);
                if (config.printWarningMessage) {
                    LOGGER.info("!!! SOME LOGGERS HAVE MOVED TO THE DEBUG FILE (Please Include them in your bug reports) !!!");
                }
            }
            catch (IOException e) {
                LOGGER.error("Error reading json from delogger.json", (Throwable)e);
            }
        }
    }

    public static DeLoggerConfig createConfig(Path path) throws IOException {
        DeLoggerConfig deLoggerConfig = (DeLoggerConfig)GSON.fromJson((Reader)Files.newBufferedReader(path), DeLoggerConfig.class);
        if (deLoggerConfig == null || deLoggerConfig.dontChangeMe == null) {
            deLoggerConfig = new DeLoggerConfig();
        }
        Files.writeString(path, (CharSequence)GSON.toJson((Object)deLoggerConfig), new OpenOption[0]);
        return deLoggerConfig;
    }

    private static boolean createFile(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
                return true;
            }
            catch (IOException e) {
                LOGGER.error("Error creating delogger.json", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static void disableLogger(DeLoggerConfig deLoggerConfig) {
        Logger logger = LOGGER;
        if (logger instanceof org.apache.logging.log4j.core.Logger) {
            org.apache.logging.log4j.core.Logger logger2 = (org.apache.logging.log4j.core.Logger)logger;
            org.apache.logging.log4j.core.Logger root = LoggerHacks.getRoot(logger2);
            if (deLoggerConfig.enableDebugLog) {
                root.addAppender((Appender)LoggerHacks.createAppender());
            }
            LoggerFilter filter = new LoggerFilter(deLoggerConfig);
            root.getAppenders().values().stream().filter(value -> !deLoggerConfig.whitelistLoggersTypes.contains(value.getName())).filter(value -> value instanceof AbstractFilterable).forEach(value -> ((AbstractFilterable)value).addFilter((Filter)filter));
        } else {
            LOGGER.error("Unsupported Logger used cant disable them!");
        }
    }

    public static org.apache.logging.log4j.core.Logger getRoot(org.apache.logging.log4j.core.Logger logger) {
        if (logger.getParent() != null) {
            return LoggerHacks.getRoot(logger.getParent());
        }
        return logger;
    }

    public static RollingRandomAccessFileAppender createAppender() {
        RollingRandomAccessFileAppender rollingRandomAccessFileAppender = ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().setName("DeLoggerDebug")).withFileName("delogger/debug.log").withFilePattern("delogger/%d{yyyy-MM-dd}-%i.log.gz").setLayout((Layout)PatternLayout.newBuilder().withPattern("[%d{ddMMMyyyy HH:mm:ss.SSS}] [%t/%level] [%logger{36}/%markerSimpleName]: %minecraftFormatting{%msg{nolookups}}{strip}%n%xEx").build())).withPolicy((TriggeringPolicy)CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{OnStartupTriggeringPolicy.createPolicy((long)1L), TimeBasedTriggeringPolicy.newBuilder().build()})).withStrategy((RolloverStrategy)DefaultRolloverStrategy.newBuilder().withMax("99").withFileIndex("min").build()).build();
        rollingRandomAccessFileAppender.addFilter((Filter)new AbstractFilter(){

            public Filter.Result filter(LogEvent event) {
                return event.getLevel() == Level.TRACE || event.getLevel() == Level.DEBUG ? Filter.Result.DENY : Filter.Result.NEUTRAL;
            }
        });
        rollingRandomAccessFileAppender.start();
        return rollingRandomAccessFileAppender;
    }
}

