/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.FakeExplosion;

public class EffectUtil {
    public static ResourceLocation effectIcon = new ResourceLocation("mahoutsukai", "textures/items/spell_scroll.png");
    public static BlockState AIR = Blocks.f_50016_.m_49966_();

    public static boolean noMoreSoaring(LivingEntity player) {
        return player.m_20096_() || player.m_21255_() || player.m_5842_();
    }

    public static void tryFakeExplosion(List<BlockPos> affected, Entity target, Player caster, String name, boolean drop, List<Entity> entities) {
        if (!target.f_19853_.f_46443_) {
            Object player = caster == null ? new SafeFakePlayer((ServerLevel)target.f_19853_, name) : caster;
            FakeExplosion explosion = new FakeExplosion(target.f_19853_, (Entity)player, target.m_20185_(), target.m_20186_(), target.m_20189_(), 10.0f, affected);
            ExplosionEvent.Detonate ee = new ExplosionEvent.Detonate(target.f_19853_, (Explosion)explosion, entities);
            ForgeEventFactory.onExplosionDetonate((Level)target.f_19853_, (Explosion)explosion, entities, (double)10.0);
            if (!ee.isCanceled()) {
                for (BlockPos p : ee.getAffectedBlocks()) {
                    BlockState bs = target.f_19853_.m_8055_(p);
                    if (bs.m_60734_() == Blocks.f_50752_ || bs.m_60795_()) continue;
                    if (drop) {
                        Block.m_49892_((BlockState)bs, (LevelAccessor)target.f_19853_, (BlockPos)p, (BlockEntity)target.f_19853_.m_7702_(p));
                    }
                    target.f_19853_.m_7471_(p, false);
                    target.f_19853_.m_46597_(p, Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    public static void tryFakeExplosion(List<BlockPos> affected, Player caster, String name, boolean drop, ArrayList<Entity> entities) {
        if (!caster.f_19853_.f_46443_) {
            Object player = caster == null ? new SafeFakePlayer((ServerLevel)caster.f_19853_, name) : caster;
            FakeExplosion explosion = new FakeExplosion(caster.f_19853_, (Entity)player, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), 10.0f, affected);
            ExplosionEvent.Detonate ee = new ExplosionEvent.Detonate(caster.f_19853_, (Explosion)explosion, entities);
            ForgeEventFactory.onExplosionDetonate((Level)caster.f_19853_, (Explosion)explosion, entities, (double)4.0);
            if (!ee.isCanceled()) {
                for (BlockPos p : ee.getAffectedBlocks()) {
                    BlockState bs = caster.f_19853_.m_8055_(p);
                    if (bs.m_60734_() == Blocks.f_50752_ || bs.m_60795_()) continue;
                    if (drop) {
                        Block.m_49892_((BlockState)bs, (LevelAccessor)caster.f_19853_, (BlockPos)p, (BlockEntity)caster.f_19853_.m_7702_(p));
                    }
                    caster.f_19853_.m_7471_(p, false);
                    caster.f_19853_.m_46597_(p, Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    public static void buff(LivingEntity player, MobEffect potion, boolean additiveBuff, int ticks) {
        EffectUtil.buff(player, potion, additiveBuff, ticks, true);
    }

    public static void buff(LivingEntity player, MobEffect potion, boolean additiveBuff, int ticks, boolean showparticles) {
        MobEffectInstance e;
        int time = ticks;
        if (additiveBuff && player.m_21023_(potion) && (e = player.m_21124_(potion)) != null && e.m_19557_() > 0) {
            time += e.m_19557_();
        }
        player.m_7292_(new MobEffectInstance(potion, time, 0, false, showparticles));
    }

    public static boolean hasBuff(LivingEntity e, MobEffect potion) {
        return e != null && e.m_21023_(potion);
    }

    public static void debuff(LivingEntity e, MobEffect potion) {
        if (EffectUtil.hasBuff(e, potion)) {
            e.m_21195_(potion);
        }
    }

    public static boolean inRange(LivingEntity victim, LivingEntity binder, Vec3 vicPos, int range, boolean facingRequired) {
        Vec3 look = binder.m_20154_();
        Vec3 eyes = binder.m_20299_(1.0f);
        if (EffectUtil.pointToLineDistance(vicPos, eyes, look.m_82549_(eyes)) < (double)range) {
            if (!facingRequired) {
                return EffectUtil.isLookingAtMe(victim, binder);
            }
            float facing = victim.m_146908_() - binder.m_146908_();
            if ((facing %= 360.0f) < 0.0f) {
                facing += 360.0f;
            }
            return facing > 90.0f && facing < 270.0f;
        }
        return false;
    }

    public static boolean isLookingAtMe(LivingEntity me, LivingEntity player) {
        return EffectUtil.isLookingAtMe((Entity)me, player, 0);
    }

    public static boolean isLookingAtMe(Entity me, LivingEntity player, int limit) {
        Vec3 mv = me.m_20182_();
        float angleToMe = (float)Math.atan2(mv.f_82481_ - player.m_20189_(), mv.f_82479_ - player.m_20185_()) * 57.2958f;
        float yaw = player.m_146908_();
        yaw %= 360.0f;
        angleToMe %= 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (angleToMe < 0.0f) {
            angleToMe += 360.0f;
        }
        float boundUpper = (yaw + 90.0f + 90.0f - (float)limit) % 360.0f;
        float boundLower = (yaw + (float)limit) % 360.0f;
        if (boundLower < 0.0f) {
            boundLower += 360.0f;
        }
        if (boundUpper < 0.0f) {
            boundUpper += 360.0f;
        }
        if (angleToMe < boundUpper && angleToMe > boundLower) {
            return true;
        }
        return boundUpper < boundLower && (angleToMe < boundUpper || angleToMe > boundLower);
    }

    public static void buff(LivingEntity player, MobEffect potion, boolean additiveBuff, int ticks, int amplifier) {
        MobEffectInstance e;
        int time = ticks;
        if (additiveBuff && player.m_21023_(potion) && (e = player.m_21124_(potion)) != null && e.m_19557_() > 0) {
            time += e.m_19557_();
        }
        player.m_7292_(new MobEffectInstance(potion, time, amplifier));
    }

    public static int getBuffLevel(LivingEntity e, MobEffect potion) {
        MobEffectInstance effect = e.m_21124_(potion);
        if (effect != null) {
            return effect.m_19564_();
        }
        return 0;
    }

    public static double pointToLineDistance(Vec3 point, Vec3 line1, Vec3 line2) {
        double d = line2.m_82546_(line1).m_82537_(line1.m_82546_(point)).m_82553_();
        return d /= line2.m_82554_(line1);
    }

    public static Vec3 pointToCenter(Vec3 point, Vec3 line1, Vec3 line2) {
        Vec3 z = line2.m_82546_(line1).m_82537_(line1.m_82546_(point));
        return z;
    }

    public static int getEffectDuration(LivingEntity e, MobEffect p) {
        MobEffectInstance effect = e.m_21124_(p);
        if (effect != null) {
            return effect.m_19557_();
        }
        return 0;
    }

    public static void tryChangeBlockState(boolean killTE, BlockPos p, BlockState newstate, Level world, Player player) {
        EffectUtil.tryChangeBlockState(killTE, p, newstate, world, player, player == null ? null : player.m_142081_());
    }

    public static boolean tryChangeBlockState(boolean killTE, BlockPos p, BlockState newstate, Level world, Player player, UUID uuid) {
        if (world != null && !world.f_46443_) {
            BlockState state = world.m_8055_(p);
            if (state.m_60734_() == Blocks.f_50752_) {
                return false;
            }
            if (!killTE && world.m_7702_(p) != null) {
                return false;
            }
            if (uuid != null) {
                player = new SafeFakePlayer((ServerLevel)world, "faker", uuid);
            }
            if (player == null) {
                player = new SafeFakePlayer((ServerLevel)world, "faker");
            }
            if (p != null && world != null && player != null && state != null) {
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, p, state, player);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled() && event.getResult() != Event.Result.DENY) {
                    world.m_46597_(p, newstate);
                    return true;
                }
            }
        }
        return false;
    }

    public static int getEnchantmentLevel(ItemStack s, Enchantment e) {
        return EnchantmentHelper.m_44843_((Enchantment)e, (ItemStack)s);
    }

    public static boolean hasEnchantment(ItemStack s, Enchantment e) {
        return EffectUtil.getEnchantmentLevel(s, e) > 0;
    }

    public static void addEnchantment(ItemStack s, Enchantment e, int value) {
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)s);
        enchants.put(e, value);
        EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)s);
    }

    public static Vec3 fromBlockPos(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static ServerLevel getNewDimensionByName(ServerLevel world, ResourceLocation key) {
        return world.m_142572_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)key));
    }

    public static ResourceLocation getDimension(Level w) {
        return w.m_46472_().m_135782_();
    }

    public static ResourceLocation getOverworld() {
        return Level.f_46428_.m_135782_();
    }

    public static boolean compareDimensions(ResourceLocation r1, ResourceLocation r2) {
        return r1.equals((Object)r2);
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static float toDegrees(float rad) {
        return rad * 57.29578f;
    }

    public static boolean inEntityBlacklist(Entity e, List<? extends String> z) {
        boolean ret = false;
        if (e != null && e.m_6095_() != null && e.m_6095_().getRegistryName() != null && z != null && z.size() > 0) {
            HashSet<? extends String> set = new HashSet<String>(z);
            String s = e.m_6095_().getRegistryName().toString();
            ret = set.contains(s) || set.contains(e.m_6095_().getRegistryName().m_135827_());
        }
        return ret;
    }

    public static boolean inGenericBlacklist(String e, List<? extends String> z) {
        boolean ret = false;
        if (e != null && z != null && z.size() > 0) {
            String s = e;
            HashSet<? extends String> set = new HashSet<String>(z);
            ret = set.contains(s);
        }
        return ret;
    }

    public static boolean inItemBlacklist(Item e, List<? extends String> z) {
        boolean ret = false;
        if (e != null && e.getRegistryName() != null && z != null && z.size() > 0) {
            HashSet<? extends String> set = new HashSet<String>(z);
            String s = e.getRegistryName().toString();
            ret = set.contains(s) || set.contains(e.getRegistryName().m_135827_());
        }
        return ret;
    }

    public static boolean inEnchantBlacklist(Enchantment e, List<? extends String> z) {
        boolean ret = false;
        if (e != null && e.getRegistryName() != null && z != null && z.size() > 0) {
            HashSet<? extends String> set = new HashSet<String>(z);
            String s = e.getRegistryName().toString();
            ret = set.contains(s) || set.contains(e.getRegistryName().m_135827_());
        }
        return ret;
    }

    public static boolean inBlockBlacklist(Block b, List<? extends String> z) {
        boolean ret = false;
        if (b != null && b.getRegistryName() != null && z != null && z.size() > 0) {
            HashSet<? extends String> set = new HashSet<String>(z);
            String s = b.getRegistryName().toString();
            ret = set.contains(s) || set.contains(b.getRegistryName().m_135827_());
        }
        return ret;
    }

    public static void magicAttack(LivingEntity living, float d, LivingEntity caster) {
        living.f_20889_ = 100;
        if (caster instanceof Player) {
            living.f_20888_ = (Player)caster;
        }
        living.m_6469_(DamageSource.f_19319_, d);
    }

    public static void genericAttack(LivingEntity living, float d, DamageSource source, LivingEntity caster) {
        living.f_20889_ = 100;
        if (caster instanceof Player) {
            living.f_20888_ = (Player)caster;
        }
        living.m_6469_(source, d);
    }
}

