/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.exchange;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class AlchemicalExchangeMahoujinTileEntity
extends MahoujinTileEntity
implements BlockEntityTicker<AlchemicalExchangeMahoujinTileEntity> {
    private int tickCounter = 0;
    private long placedTime = 0L;
    private int processingLayer = 0;
    private static final String PLACED_TIME_TAG = "MAHOUTSUKAI_PLACED_TIME_TAG";
    private static final String PROCESSING_LAYER_TAG = "MAHOUTSUKAI_PROCESSING_LAYER_TAG";
    private static HashSet<BlockState> dirtClass = new HashSet();
    private static HashSet<BlockState> stoneClass = new HashSet();
    private static HashSet<BlockState> gemClass = new HashSet();
    private static HashSet<BlockState> metalClass = new HashSet();
    private static HashSet<BlockState> clayClass = new HashSet();
    private static HashSet<BlockState> woodClass = new HashSet();
    private static HashSet<BlockState> grassClass = new HashSet();
    private static HashSet<BlockState> specialClass = new HashSet();
    private static HashSet<BlockState> fluidClass = new HashSet();
    private static HashSet<BlockState> movingFluidClass = new HashSet();
    private static ArrayList<HashSet> blockClasses = new ArrayList();
    private ArrayList<Integer> indices = null;

    public AlchemicalExchangeMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.alchemicalExchange.get(), p, bs);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, AlchemicalExchangeMahoujinTileEntity blockEntity) {
        if (!level.f_46443_) {
            if (this.tickCounter == MTConfig.ALCHEMICAL_EXCHANGE_BLOCK_CYCLE) {
                this.transformLayers();
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
    }

    public void setPlacedTime(long t) {
        this.placedTime = t;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128405_(PROCESSING_LAYER_TAG, this.processingLayer);
        compound.m_128356_(PLACED_TIME_TAG, this.placedTime);
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.placedTime = compound.m_128454_(PLACED_TIME_TAG);
        this.processingLayer = compound.m_128451_(PROCESSING_LAYER_TAG);
        super.m_142466_(compound);
    }

    public void transformLayers() {
        long p = this.f_58857_.m_46468_() % 24000L;
        if (p < 0L) {
            p += 24000L;
        }
        p -= p % 20L;
        if (this.indices == null) {
            this.indices = this.generateIndices(blockClasses, this.getCaster());
        }
        if (p == this.placedTime) {
            this.processingLayer = 1;
            this.transformLayer(this.processingLayer, this.indices, this.getCaster());
        } else if (this.processingLayer > 0) {
            this.transformLayer(this.processingLayer, this.indices, this.getCaster());
            ++this.processingLayer;
            if (this.processingLayer >= MTConfig.ALCHEMICAL_EXCHANGE_HEIGHT) {
                this.processingLayer = 0;
                this.indices = null;
            }
        }
    }

    public ArrayList<Integer> generateIndices(ArrayList<HashSet> lengths, Player player) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int z = 0; z < lengths.size(); ++z) {
            ret.add(this.f_58857_.f_46441_.nextInt(Math.max(1, lengths.get(z).size())));
        }
        return ret;
    }

    public boolean transformLayer(int layer, ArrayList<Integer> indices, Player player) {
        Stream layerBlocks = BlockPos.m_121990_((BlockPos)this.f_58858_.m_142082_(-2, -layer, -2), (BlockPos)this.f_58858_.m_142082_(2, -layer, 2));
        layerBlocks.forEach(tmp -> {
            Block b = this.f_58857_.m_8055_(tmp).m_60734_();
            if (!Utils.isBlockAir(this.f_58857_, tmp)) {
                boolean nearbyBatteriesGaveMana;
                int liquid = this.f_58857_.f_46441_.nextInt(2);
                BlockState tb = null;
                if (b instanceof LiquidBlock) {
                    tb = new ArrayList<BlockState>(fluidClass).get(liquid);
                } else {
                    for (int i = 0; i < blockClasses.size(); ++i) {
                        int target;
                        HashSet s = blockClasses.get(i);
                        if (!s.contains(this.f_58857_.m_8055_(tmp)) || (target = i < indices.size() ? (Integer)indices.get(i) : 0) >= s.size()) continue;
                        tb = (BlockState)new ArrayList(s).get(target);
                        break;
                    }
                }
                if (tb != null && ((nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.f_58858_, this.f_58857_, this.getCasterUUID(), MTConfig.ALCHEMICAL_EXCHANGE_MANA_COST)) || player != null && PlayerManaManager.drainMana(player, MTConfig.ALCHEMICAL_EXCHANGE_MANA_COST, false, false) == MTConfig.ALCHEMICAL_EXCHANGE_MANA_COST)) {
                    EffectUtil.tryChangeBlockState(false, tmp, tb, this.f_58857_, this.getCaster());
                    if (player != null) {
                        PlayerManaManager.updateClientMahou((ServerPlayer)player, Utils.getPlayerMahou(player));
                    }
                }
            }
        });
        return true;
    }

    public static Block getBlockFromRegistryName(String registryName) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(registryName));
    }

    public static Iterable<Holder<Block>> getBlockTagFromRegistryName(String registryName) {
        TagKey tagkey = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(registryName));
        return Registry.f_122824_.m_206058_(tagkey);
    }

    public static void init() {
        try {
            blockClasses = new ArrayList();
            dirtClass = new HashSet();
            stoneClass = new HashSet();
            metalClass = new HashSet();
            gemClass = new HashSet();
            clayClass = new HashSet();
            woodClass = new HashSet();
            specialClass = new HashSet();
            grassClass = new HashSet();
            fluidClass = new HashSet();
            movingFluidClass = new HashSet();
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(dirtClass, MTConfig.ALCHEMICAL_DIRT_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(stoneClass, MTConfig.ALCHEMICAL_STONE_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(metalClass, MTConfig.ALCHEMICAL_METAL_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(gemClass, MTConfig.ALCHEMICAL_GEM_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(clayClass, MTConfig.ALCHEMICAL_CLAY_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(woodClass, MTConfig.ALCHEMICAL_WOOD_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(specialClass, MTConfig.ALCHEMICAL_SPECIAL_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(grassClass, MTConfig.ALCHEMICAL_GRASS_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(fluidClass, MTConfig.ALCHEMICAL_FLUID_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(movingFluidClass, MTConfig.ALCHEMICAL_MOVING_FLUID_CLASS);
            blockClasses.add(dirtClass);
            blockClasses.add(stoneClass);
            blockClasses.add(metalClass);
            blockClasses.add(gemClass);
            blockClasses.add(clayClass);
            blockClasses.add(woodClass);
            blockClasses.add(specialClass);
            blockClasses.add(grassClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addBlocksToList(HashSet<BlockState> lst, List<String> registryNames) {
        for (int i = 0; i < registryNames.size(); ++i) {
            String s = registryNames.get(i);
            String[] variant = s.split("@");
            if (variant.length <= 0) continue;
            Block b = AlchemicalExchangeMahoujinTileEntity.getBlockFromRegistryName(variant[0]);
            if (b == null || b == Blocks.f_50016_) {
                Iterable<Holder<Block>> tag = AlchemicalExchangeMahoujinTileEntity.getBlockTagFromRegistryName(variant[0]);
                if (tag != null) {
                    Iterator<Holder<Block>> tagged = tag.iterator();
                    while (tagged.hasNext()) {
                        Block taggedBlock = (Block)tagged.next().m_203334_();
                        if (taggedBlock == null) continue;
                        lst.add(taggedBlock.m_49966_());
                    }
                    continue;
                }
                System.out.println("Mahou Tsukai Alchemical Exchange: Registry block " + s + " not found.");
                continue;
            }
            BlockState bs = b.m_49966_();
            lst.add(bs);
        }
    }
}

