/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.displacement;

import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;

public class EquivalentDisplacementMahoujinTileEntity
extends MahoujinTileEntity
implements BlockEntityTicker<EquivalentDisplacementMahoujinTileEntity> {
    TicketType<ChunkPos> ticket = null;
    private int receivingTickCounter = 0;
    private int tickCounter = 0;
    private BlockPos targetLocation = null;
    private ResourceLocation targetDimension = null;
    public static String TELEPORTER_BOUND_TAG_X = "MAHOUTSUKAI_BOUND_TELEPORTER_TAG_X";
    public static String TELEPORTER_BOUND_TAG_Y = "MAHOUTSUKAI_BOUND_TELEPORTER_TAG_Y";
    public static String TELEPORTER_BOUND_TAG_Z = "MAHOUTSUKAI_BOUND_TELEPORTER_TAG_Z";
    public static String TELEPORTER_BOUND_TAG_D = "MAHOUTSUKAI_BOUND_TELEPORTER_TAG_D";

    public EquivalentDisplacementMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.equivalentDisplacement.get(), p, bs);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        if (this.targetLocation != null) {
            compound.m_128405_(TELEPORTER_BOUND_TAG_X, this.targetLocation.m_123341_());
            compound.m_128405_(TELEPORTER_BOUND_TAG_Y, this.targetLocation.m_123342_());
            compound.m_128405_(TELEPORTER_BOUND_TAG_Z, this.targetLocation.m_123343_());
        }
        if (this.targetDimension != null) {
            compound.m_128359_(TELEPORTER_BOUND_TAG_D, this.targetDimension.toString());
        }
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_(TELEPORTER_BOUND_TAG_X) && compound.m_128441_(TELEPORTER_BOUND_TAG_Y) && compound.m_128441_(TELEPORTER_BOUND_TAG_Z)) {
            int x = compound.m_128451_(TELEPORTER_BOUND_TAG_X);
            int y = compound.m_128451_(TELEPORTER_BOUND_TAG_Y);
            int z = compound.m_128451_(TELEPORTER_BOUND_TAG_Z);
            this.targetLocation = new BlockPos(x, y, z);
        }
        this.targetDimension = compound.m_128441_(TELEPORTER_BOUND_TAG_D) ? new ResourceLocation(compound.m_128461_(TELEPORTER_BOUND_TAG_D)) : DimensionType.f_63845_.m_135782_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.loadChunks();
        }
        super.m_142466_(compound);
    }

    public BlockPos getTargetLocation() {
        return this.targetLocation;
    }

    public ResourceLocation getTargetDimension() {
        return this.targetDimension;
    }

    public void setTargetLocation(BlockPos pos) {
        this.targetLocation = pos;
    }

    public void setTargetDimension(ResourceLocation d) {
        this.targetDimension = d;
    }

    public ResourceLocation getDimension() {
        if (this.f_58857_ != null) {
            return EffectUtil.getDimension(this.f_58857_);
        }
        return null;
    }

    public void setReceivingTickCounter(int t) {
        this.receivingTickCounter = t;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, EquivalentDisplacementMahoujinTileEntity blockEntity) {
        if (!level.f_46443_) {
            if (this.receivingTickCounter <= 0) {
                if (this.tickCounter == MTConfig.EQUIVALENT_DISPLACEMENT_BLOCK_CYCLE) {
                    EquivalentDisplacementMahoujinTileEntity tte;
                    BlockPos target = this.getTargetLocation();
                    ResourceLocation d = this.getDimension();
                    if (target != null && (!target.equals((Object)this.f_58858_) || d != this.targetDimension) && EquivalentDisplacementMahoujinTileEntity.doITeleport(this.f_58858_, target, d, this.targetDimension) && (tte = this.getTargetTE(target, this.targetDimension)) != null && tte.getCasterUUID().equals(this.getCasterUUID())) {
                        Entity here = this.entityReadyToTeleport();
                        Entity there = tte.entityReadyToTeleport();
                        if (here != null && there != null && !here.m_20163_() && !there.m_20163_()) {
                            Player caster = this.getCaster();
                            boolean nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.f_58858_, level, this.getCasterUUID(), MTConfig.EQUIVALENT_DISPLACEMENT_MANA_COST);
                            if (nearbyBatteriesGaveMana || caster != null && PlayerManaManager.drainMana(caster, MTConfig.EQUIVALENT_DISPLACEMENT_MANA_COST, false, false) == MTConfig.EQUIVALENT_DISPLACEMENT_MANA_COST) {
                                MahouTsukaiTeleporter.teleport(here, (double)target.m_123341_() + 0.5, target.m_123342_(), (double)target.m_123343_() + 0.5, this.targetDimension);
                                MahouTsukaiTeleporter.teleport(there, (double)this.f_58858_.m_123341_() + 0.5, this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5, d);
                                this.setReceivingTickCounter(MTConfig.EQUIVALENT_DISPLACEMENT_RECEIVE_COOLDOWN);
                                tte.setReceivingTickCounter(MTConfig.EQUIVALENT_DISPLACEMENT_RECEIVE_COOLDOWN);
                            }
                        }
                    }
                    this.tickCounter = 0;
                }
                ++this.tickCounter;
            } else {
                --this.receivingTickCounter;
            }
            this.loadChunks();
        }
    }

    public void loadChunks() {
        if (this.ticket == null && !this.f_58857_.f_46443_) {
            this.ticket = TicketType.m_9462_((String)this.serializeTicket(), Comparator.comparingLong(ChunkPos::m_45588_));
        } else if (this.ticket != null && !this.f_58857_.f_46443_) {
            ChunkPos pos = new ChunkPos(this.m_58899_());
            ((ServerLevel)this.f_58857_).m_7726_().m_8387_(this.ticket, pos, 1, (Object)pos);
        }
    }

    public void releaseChunks() {
        if (this.ticket != null && !this.f_58857_.f_46443_) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8438_(this.ticket, new ChunkPos(this.m_58899_()), 11, (Object)new ChunkPos(this.f_58858_));
        }
    }

    public String serializeTicket() {
        Object ret = "mahoutsukai_";
        ret = (String)ret + this.f_58858_.m_123341_() + "_" + this.f_58858_.m_123342_() + "_" + this.f_58858_.m_123343_() + "_";
        ret = this.getDimension() != null ? (String)ret + this.getDimension().toString() : (String)ret + "overworld";
        return ret;
    }

    public static boolean doITeleport(BlockPos me, BlockPos target, ResourceLocation md, ResourceLocation td) {
        if (md != td && !MTConfig.EQUIVALENT_DISPLACEMENT_DIMENSIONAL_TRAVEL) {
            return false;
        }
        double maxd = MTConfig.EQUIVALENT_DISPLACEMENT_MAX_DISTANCE;
        if (maxd > 0.0 && me.m_123331_((Vec3i)target) > maxd * maxd) {
            return false;
        }
        if (me.m_123341_() != target.m_123341_()) {
            return me.m_123341_() < target.m_123341_();
        }
        if (me.m_123342_() != target.m_123342_()) {
            return me.m_123342_() < target.m_123342_();
        }
        if (me.m_123343_() != target.m_123343_()) {
            return me.m_123343_() < target.m_123343_();
        }
        return md.hashCode() < td.hashCode();
    }

    public Entity entityReadyToTeleport() {
        List lst = this.f_58857_.m_45976_(Entity.class, new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 1)));
        if (lst.isEmpty()) {
            return null;
        }
        return (Entity)lst.get(0);
    }

    public EquivalentDisplacementMahoujinTileEntity getTargetTE(BlockPos pos, ResourceLocation dimension) {
        BlockEntity te;
        ServerLevel worldServer = EffectUtil.getNewDimensionByName((ServerLevel)this.f_58857_, dimension);
        if (worldServer != null && (te = worldServer.m_7702_(pos)) instanceof EquivalentDisplacementMahoujinTileEntity) {
            return (EquivalentDisplacementMahoujinTileEntity)te;
        }
        return null;
    }
}

