/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class DisplacementBoundaryMahoujinTileEntity
extends BoundaryMahoujinTileEntity {
    private static final boolean livingOnly = true;

    public DisplacementBoundaryMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.displacementBoundary.get(), true, p, bs);
    }

    @Override
    public int getManaCost() {
        return MTConfig.DISPLACEMENT_BARRIER_MANA_COST;
    }

    @Override
    public int getManaCycle() {
        return MTConfig.DISPLACEMENT_BARRIER_MANA_CYCLE;
    }

    @Override
    public int getBarrierCycle() {
        return MTConfig.DISPLACEMENT_BARRIER_CYCLE;
    }

    @Override
    public int getBarrierRadius() {
        return MTConfig.DISPLACEMENT_BARRIER_RADIUS;
    }

    @Override
    public void doBarrier(List<LivingEntity> entities) {
        double x1 = this.f_58858_.m_123341_() - this.getBarrierRadius() + 1;
        double x2 = this.f_58858_.m_123341_() + this.getBarrierRadius() - 1;
        double z1 = this.f_58858_.m_123343_() - this.getBarrierRadius() + 1;
        double z2 = this.f_58858_.m_123343_() + this.getBarrierRadius() - 1;
        Player caster = this.getCaster();
        for (Entity entity : entities) {
            if (ContractMahoujinTileEntity.isImmuneToSpell(this.f_58857_, this.getCasterUUID(), entity) || entity instanceof ArmorStand) continue;
            double x = entity.m_20185_();
            double y = entity.m_20186_();
            double z = entity.m_20189_();
            Vec3 lv = entity.m_20154_();
            double lx = lv.f_82479_;
            double lz = lv.f_82481_;
            BlockPos newPos = this.getDestination(this, x, y, z, lx, lz);
            BlockPos oldPos = new BlockPos(x, y, z);
            boolean doSwitch = !((double)oldPos.m_123341_() > x1 && (double)oldPos.m_123341_() < x2 && (double)oldPos.m_123343_() > z1 && (double)oldPos.m_123343_() < z2);
            if (!doSwitch) continue;
            BlockPos ascendedPos = this.getAscendedDestination(newPos, this.f_58857_, entity);
            if (ascendedPos != null) {
                newPos = ascendedPos;
            }
            if (this.f_58857_.f_46443_) continue;
            if (entity instanceof ServerPlayer && !((ServerPlayer)entity).m_5833_() && !((ServerPlayer)entity).m_7500_()) {
                ((ServerPlayer)entity).f_8906_.m_9774_((double)newPos.m_123341_(), (double)newPos.m_123342_(), (double)newPos.m_123343_(), entity.m_146908_(), entity.m_146909_());
                continue;
            }
            entity.m_6021_((double)newPos.m_123341_(), (double)newPos.m_123342_(), (double)newPos.m_123343_());
        }
    }

    public BlockPos getDestination(DisplacementBoundaryMahoujinTileEntity te, double x, double y, double z, double lx, double lz) {
        double nz;
        BlockPos ret = null;
        double nx = x;
        double ny = y;
        if (te != null) {
            double x1 = te.m_58899_().m_123341_() - this.getBarrierRadius();
            double x2 = x1 + (double)(this.getBarrierRadius() * 2);
            double z1 = te.m_58899_().m_123343_() - this.getBarrierRadius();
            double z2 = z1 + (double)(this.getBarrierRadius() * 2);
            for (nz = z; nx > x1 && nx < x2 && nz > z1 && nz < z2; nx += lx, nz += lz) {
            }
        }
        ret = new BlockPos(nx, ny, nz);
        return ret;
    }

    public BlockPos getAscendedDestination(BlockPos p, Level w, Entity e) {
        BlockPos tmp = p;
        while (tmp.m_123342_() < w.m_151558_()) {
            if (this.okPosition(tmp, w, e)) {
                return tmp;
            }
            tmp = tmp.m_7494_();
        }
        return null;
    }

    public boolean okPosition(BlockPos p, Level w, Entity e) {
        int i = 0;
        while ((float)i < e.m_20206_()) {
            BlockPos tmp = p.m_142082_(0, i, 0);
            if (!Utils.isBlockAir(this.f_58857_, tmp)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((ItemLike)ModItems.boundaryDisplacementScroll);
    }
}

