/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.sounds;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.sounds.ModSounds;

public class BeamMovingSound
extends AbstractTickableSoundInstance {
    private final Player player;
    private final MysticStaffBeamMahoujinEntity beam;
    private float lastvolume = 0.0f;

    public BeamMovingSound(Player player, MysticStaffBeamMahoujinEntity beam) {
        super(ModSounds.BEAM_TWINKLE, SoundSource.NEUTRAL);
        this.player = player;
        this.beam = beam;
        this.f_119580_ = SoundInstance.Attenuation.NONE;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119573_ = 0.001f;
        this.lastvolume = 0.001f;
    }

    public void m_7788_() {
        if (this.beam.m_6084_()) {
            float len = this.beam.getBeamLength();
            float pt = this.beam.getRotationPitch();
            float yw = this.beam.getRotationYaw();
            Vec3 direction = Vec3.m_82498_((float)(90.0f - pt), (float)(360.0f - yw + 180.0f)).m_82541_();
            Vec3 position = this.beam.m_20182_();
            double d = this.distanceToLine(position, position.m_82549_(direction.m_82490_((double)len)), this.player.m_20182_().m_82549_(new Vec3(0.0, 1.0, 0.0)));
            this.lastvolume = this.f_119573_;
            if (d > 128.0) {
                this.f_119573_ = 0.0f;
            } else {
                this.f_119574_ = 0.3f + 0.4f * this.beam.getSphereSize() / 0.7f;
                this.f_119574_ += this.beam.getBeamSize() * 0.4f / 0.7f;
                this.f_119573_ = (float)Math.min((double)(this.beam.getSphereSize() * 0.1f + this.beam.getBeamSize() * 0.1f) * (4.0 / d), 1.0);
                this.f_119573_ = (float)((double)this.f_119573_ * MTConfig.MYSTIC_STAFF_BEAM_VOLUME_FACTOR);
            }
        } else {
            this.m_119609_();
        }
    }

    public double distanceToLine(Vec3 v, Vec3 w, Vec3 p) {
        Vec3 VW = v.m_82546_(w);
        if (VW.m_82556_() == 0.0) {
            return p.m_82554_(v);
        }
        Vec3 z = v.m_82546_(VW.m_82490_(v.m_82546_(p).m_82526_(VW) / VW.m_82526_(VW)));
        double dv = z.m_82557_(v);
        double dw = z.m_82557_(w);
        double dvw = v.m_82557_(w);
        if (dv > dvw) {
            return p.m_82554_(w);
        }
        if (dw > dvw) {
            return p.m_82554_(v);
        }
        return p.m_82554_(z);
    }
}

