/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.eventbus.api.Event;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.fluids.MurkyWater;
import stepsword.mahoutsukai.render.gui.FogProjectorScreen;
import stepsword.mahoutsukai.render.overlay.RenderFogProjectors;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RenderPowerConsolidation {
    public static float distanceToMurkyWater(Entity entity) {
        int r = (int)MTConfig.POWER_CONSOLIDATION_FOG_RADIUS;
        BlockPos minPos = entity.m_142538_().m_142082_(-r, -r, -r);
        BlockPos maxPos = entity.m_142538_().m_142082_(r, r, r);
        ChunkPos minCPos = new ChunkPos(minPos);
        ChunkPos maxCPos = new ChunkPos(maxPos);
        float ret = -1.0f;
        try {
            for (int x = minCPos.f_45578_; x < maxCPos.f_45578_ + 1; ++x) {
                for (int z = minCPos.f_45579_; z < maxCPos.f_45579_ + 1; ++z) {
                    LevelChunk c = entity.f_19853_.m_6325_(x, z);
                    IChunkMahou chunkMahou = Utils.getChunkMahou(c);
                    ConcurrentSet<BlockPos> blocks = chunkMahou.getLakeBlocks();
                    if (blocks == null || blocks.size() <= 0) continue;
                    for (BlockPos p : blocks) {
                        Block b = entity.f_19853_.m_8055_(p).m_60734_();
                        if (b != ModBlocks.murkyFluid.get() || Math.abs(p.m_123341_() - entity.m_142538_().m_123341_()) >= r || Math.abs(p.m_123343_() - entity.m_142538_().m_123343_()) >= r || Math.abs(p.m_123342_() - entity.m_142538_().m_123342_()) >= r) continue;
                        float d = (float)entity.m_20182_().m_82554_(EffectUtil.fromBlockPos(p).m_82520_(0.5, 0.5, 0.5));
                        if (ret == -1.0f) {
                            ret = d;
                        }
                        if (!(ret > d)) continue;
                        ret = d;
                    }
                }
            }
        }
        catch (Exception e) {
            return -1.0f;
        }
        return ret;
    }

    public static boolean powerConsolidationFogColor(EntityViewRenderEvent.FogColors event) {
        boolean ret = false;
        double d = RenderPowerConsolidation.distanceToMurkyWater(Minecraft.m_91087_().m_91288_());
        if (Utils.isInMurkyWater(Minecraft.m_91087_().m_91288_())) {
            event.setRed(0.0f);
            event.setGreen(0.15686275f);
            event.setBlue(0.0f);
            ret = true;
        } else if (d <= MTConfig.POWER_CONSOLIDATION_FOG_RADIUS && d >= 0.0) {
            float c = 180.0f;
            float td = 0.0f;
            float tr = 0.0f;
            float tg = 0.0f;
            float tb = 0.0f;
            double colorstrength = (MTConfig.POWER_CONSOLIDATION_FOG_RADIUS - d) / MTConfig.POWER_CONSOLIDATION_FOG_RADIUS;
            td = (float)((double)td + (colorstrength *= 2.0));
            tr = (float)((double)tr + (double)c * colorstrength);
            tg = (float)((double)tg + (double)c * colorstrength);
            tb = (float)((double)tb + (double)c * colorstrength);
            float r = (tr += event.getRed() * 255.0f) / (td += 1.0f) / 255.0f;
            float g = (tg += event.getGreen() * 255.0f) / td / 255.0f;
            float b = (tb += event.getBlue() * 255.0f) / td / 255.0f;
            event.setRed(r);
            event.setGreen(g);
            event.setBlue(b);
            ret = true;
        }
        return ret;
    }

    public static boolean powerConsolidationBlockOverlay(RenderBlockOverlayEvent event) {
        return Minecraft.m_91087_().m_91288_() != null && Utils.isInMurkyWater(Minecraft.m_91087_().m_91288_());
    }

    public static boolean powerConsolidationRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        boolean ret = RenderPowerConsolidation.doFog(event.getNearPlaneDistance(), event.getFarPlaneDistance(), event);
        if (ret) {
            event.setResult(Event.Result.ALLOW);
        }
        return ret;
    }

    public static void powerConsolidationFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (Utils.isInMurkyWater(Minecraft.m_91087_().m_91288_())) {
            event.setDensity(10.0f);
            event.setCanceled(true);
            RenderSystem.m_157438_((float)((float)MurkyWater.COLOR.getRed() / 255.0f), (float)((float)MurkyWater.COLOR.getGreen() / 255.0f), (float)((float)MurkyWater.COLOR.getBlue() / 255.0f), (float)1.0f);
        }
    }

    public static boolean doFog(float nearPlane, float farPlane, EntityViewRenderEvent.RenderFogEvent event) {
        double f = RenderPowerConsolidation.distanceToMurkyWater(Minecraft.m_91087_().m_91288_());
        double top = MTConfig.POWER_CONSOLIDATION_FOG_RADIUS;
        if ((f = Math.min(f, top)) > 0.0) {
            double strength = 50.0 - 50.0 / top * f;
            double f1 = Math.min(strength, (double)FogProjectorScreen.camera_fog_strength_max) / (double)FogProjectorScreen.camera_fog_strength_max;
            float oldstart = nearPlane;
            double f2 = RenderFogProjectors.fogScaleFormula(farPlane, f1);
            double f3 = RenderFogProjectors.fogScaleFormula(oldstart, f1);
            double fogStart = Mth.m_14008_((double)f3, (double)1.0, (double)oldstart);
            double fogEnd = Mth.m_14008_((double)f2, (double)4.0, (double)farPlane);
            if (oldstart == 0.0f) {
                fogStart = 0.0;
            }
            float fg = 0.7058824f;
            event.setNearPlaneDistance((float)fogStart);
            event.setFarPlaneDistance((float)fogEnd);
            event.setFogShape(FogShape.SPHERE);
            return true;
        }
        return false;
    }
}

