/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.shaders.FogShape;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.Event;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.render.gui.FogProjectorScreen;
import stepsword.mahoutsukai.tile.FogProjectorTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RenderFogProjectors {
    public static ConcurrentSet<FogProjectorTileEntity> distanceToFog(Entity entity) {
        int r = (int)MTConfig.FOG_PROJECTOR_MAX_RADIUS;
        BlockPos minPos = entity.m_142538_().m_142082_(-r, -r, -r);
        BlockPos maxPos = entity.m_142538_().m_142082_(r, r, r);
        ChunkPos minCPos = new ChunkPos(minPos);
        ChunkPos maxCPos = new ChunkPos(maxPos);
        ConcurrentSet ret = new ConcurrentSet();
        try {
            for (int x = minCPos.f_45578_; x < maxCPos.f_45578_ + 1; ++x) {
                for (int z = minCPos.f_45579_; z < maxCPos.f_45579_ + 1; ++z) {
                    IChunkMahou chunkMahou;
                    ConcurrentSet<BlockPos> blocks;
                    LevelChunk c = entity.f_19853_.m_6325_(x, z);
                    if (!(c instanceof LevelChunk) || (blocks = (chunkMahou = Utils.getChunkMahou(c)).getFogProjectors()) == null || blocks.size() <= 0) continue;
                    for (BlockPos p : blocks) {
                        BlockEntity be;
                        Block b = entity.f_19853_.m_8055_(p).m_60734_();
                        if (b != ModBlocks.fogProjector.get() || Math.abs(p.m_123341_() - entity.m_142538_().m_123341_()) >= r || Math.abs(p.m_123343_() - entity.m_142538_().m_123343_()) >= r || Math.abs(p.m_123342_() - entity.m_142538_().m_123342_()) >= r || !((be = entity.f_19853_.m_7702_(p)) instanceof FogProjectorTileEntity) || !((FogProjectorTileEntity)be).get_camera_fog_toggle() || entity.f_19853_.m_46753_(p)) continue;
                        ret.add((Object)((FogProjectorTileEntity)be));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static boolean fogProjectorColor(EntityViewRenderEvent.FogColors event) {
        boolean ret = false;
        double td = 0.0;
        double tr = 0.0;
        double tg = 0.0;
        double tb = 0.0;
        boolean doChange = false;
        ConcurrentSet<FogProjectorTileEntity> blocks = RenderFogProjectors.distanceToFog(Minecraft.m_91087_().m_91288_());
        for (FogProjectorTileEntity te : blocks) {
            Vec3 v = EffectUtil.fromBlockPos(te.m_58899_()).m_82520_(0.5, 0.5, 0.5);
            double d = v.m_82554_(Minecraft.m_91087_().m_91288_().m_20182_());
            if (d <= 0.0) {
                d = 1.0E-8;
            }
            if (!(d < (double)te.get_camera_fog_radius())) continue;
            double colorstrength = ((double)te.get_camera_fog_radius() - d) / (double)te.get_camera_fog_radius();
            td += (colorstrength *= 2.0);
            tr += (double)te.get_camera_fog_color_r() * colorstrength;
            tg += (double)te.get_camera_fog_color_g() * colorstrength;
            tb += (double)te.get_camera_fog_color_b() * colorstrength;
            doChange = true;
        }
        td += 1.0;
        tr += (double)(event.getRed() * 255.0f);
        tg += (double)(event.getGreen() * 255.0f);
        tb += (double)(event.getBlue() * 255.0f);
        if (td > 0.0 && doChange) {
            float r = (float)(tr / td / 255.0);
            float g = (float)(tg / td / 255.0);
            float b = (float)(tb / td / 255.0);
            event.setRed(r);
            event.setGreen(g);
            event.setBlue(b);
            ret = true;
        }
        return ret;
    }

    public static boolean fogProjectorRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        boolean ret = RenderFogProjectors.doFog(event.getNearPlaneDistance(), event.getFarPlaneDistance(), event);
        if (ret) {
            event.setResult(Event.Result.ALLOW);
        }
        return ret;
    }

    public static double getStrength() {
        double strength = 0.0;
        ConcurrentSet<FogProjectorTileEntity> blocks = RenderFogProjectors.distanceToFog(Minecraft.m_91087_().m_91288_());
        for (FogProjectorTileEntity te : blocks) {
            Vec3 v = EffectUtil.fromBlockPos(te.m_58899_()).m_82520_(0.5, 0.5, 0.5);
            double d = v.m_82554_(Minecraft.m_91087_().m_91288_().m_20182_());
            if (!(d < (double)te.get_camera_fog_radius())) continue;
            strength += (double)te.get_camera_fog_strength() - (double)(te.get_camera_fog_strength() / te.get_camera_fog_radius()) * d;
        }
        return strength;
    }

    public static boolean doFog(float nearPlane, float farPlane, EntityViewRenderEvent.RenderFogEvent event) {
        boolean ret = false;
        double strength = RenderFogProjectors.getStrength();
        if (strength > 0.0) {
            float offset = 2.0f;
            double f1 = Math.min(strength, (double)FogProjectorScreen.camera_fog_strength_max) / (double)FogProjectorScreen.camera_fog_strength_max;
            float oldstart = nearPlane;
            double f2 = RenderFogProjectors.fogScaleFormula(farPlane, f1);
            double f3 = RenderFogProjectors.fogScaleFormula(oldstart, f1);
            double fogStart = Mth.m_14008_((double)f3, (double)1.0, (double)oldstart);
            double fogEnd = Mth.m_14008_((double)f2, (double)4.0, (double)farPlane);
            if (oldstart == 0.0f) {
                fogStart = 0.0;
            }
            float fg = 0.7058824f;
            event.setNearPlaneDistance((float)fogStart);
            event.setFarPlaneDistance((float)fogEnd);
            event.setFogShape(FogShape.SPHERE);
            ret = true;
        }
        return ret;
    }

    public static double fogScaleFormula(float offset, double x) {
        return (x - 1.0) * (x - 1.0) * (x - 1.0) * (x - 1.0) * (double)offset;
    }
}

