/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import stepsword.mahoutsukai.item.spells.projection.WeaponProjectile.WeaponProjectileBow;

public class WeaponProjectileBowModel
implements IModelGeometry<WeaponProjectileBowModel> {
    public static ResourceLocation standby = new ResourceLocation("mahoutsukai", "item/weapon_projectile_bow_standby");
    public static ResourceLocation pulling0 = new ResourceLocation("mahoutsukai", "item/weapon_projectile_bow_pulling_0");
    public static ResourceLocation pulling1 = new ResourceLocation("mahoutsukai", "item/weapon_projectile_bow_pulling_1");
    public static ResourceLocation pulling2 = new ResourceLocation("mahoutsukai", "item/weapon_projectile_bow_pulling_2");
    private final ResourceLocation bowTexture;
    private final ResourceLocation projectileTexture;
    private final String ammo;
    private final int pulling;

    public WeaponProjectileBowModel(ResourceLocation bt, ResourceLocation pt, String ammo, int pull) {
        this.bowTexture = bt;
        this.projectileTexture = pt;
        this.ammo = ammo;
        this.pulling = pull;
    }

    public Collection<? extends IModelGeometryPart> getParts() {
        return null;
    }

    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return Optional.empty();
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite particleSprite;
        ImmutableMap transformMap;
        Transformation transform;
        ImmutableList.Builder builder;
        block16: {
            builder = ImmutableList.builder();
            if (this.bowTexture != null) {
                BakedModel ibakedmodel = Minecraft.m_91087_().m_91304_().getModel(this.bowTexture);
                builder.addAll((Iterable)ibakedmodel.getQuads(null, null, new Random(), null));
            }
            modelTransform = new CompositeModelState(modelTransform, (ModelState)new SimpleModelState(new Transformation(null, new Quaternion(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
            transform = modelTransform.m_6189_();
            ModelState transformsFromModel = owner.getCombinedTransform();
            ImmutableMap immutableMap = transformMap = transformsFromModel != null ? PerspectiveMapWrapper.getTransforms((ModelState)new CompositeModelState(transformsFromModel, modelTransform)) : PerspectiveMapWrapper.getTransforms((ModelState)modelTransform);
            if (this.ammo != null && this.pulling >= 0) {
                float tx = 0.0f;
                float tz = 0.0f;
                if (this.pulling == 0) {
                    tx = 3.0f;
                    tz = 3.0f;
                } else if (this.pulling == 1) {
                    tx = 2.0f;
                    tz = 2.0f;
                } else if (this.pulling == 2) {
                    tx = 1.0f;
                    tz = 1.0f;
                }
                transform = new Transformation(new Vector3f(-tx / 16.0f + 1.0f, tz / 16.0f, 0.0f), new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), 90.0f, true), new Vector3f(1.01f, 1.01f, 1.01f), null);
                transform.blockCenterToCorner();
            }
            particleSprite = this.bowTexture != null ? spriteGetter.apply(owner.resolveTexture(this.bowTexture.toString())) : null;
            try {
                if (this.ammo == null || this.ammo.equals("")) break block16;
                ItemStack ammostack = ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)this.ammo));
                ResourceLocation pt = this.projectileTexture;
                ModelResourceLocation mpt = ForgeModelBakery.getInventoryVariant((String)ammostack.m_41720_().getRegistryName().toString());
                if (pt == null) {
                    BakedModel m = Minecraft.m_91087_().m_91304_().getModel((ResourceLocation)mpt);
                    BakedModel bm = Minecraft.m_91087_().m_91291_().m_174264_(new ItemStack((ItemLike)Items.f_42383_), null, null, 0);
                    TextureAtlasSprite stackIcon = bm.m_6160_();
                    pt = stackIcon.m_118413_();
                }
                BakedModel ammoModel = Minecraft.m_91087_().m_91291_().m_174264_(ammostack, null, null, 0);
                try {
                    if (ammoModel.m_6840_(null, null, new Random()).size() <= 0) {
                        ammoModel = new ItemLayerModel(ImmutableList.of((Object)new Material(TextureAtlas.f_118260_, pt))).bake(owner, bakery, spriteGetter, modelTransform, overrides, modelLocation);
                    }
                }
                catch (Exception e2) {
                    try {
                        if (ammoModel.m_6840_(null, null, new Random()).size() <= 0) {
                            ammoModel = new ItemLayerModel(ImmutableList.of((Object)new Material(TextureAtlas.f_118259_, pt))).bake(owner, bakery, spriteGetter, modelTransform, overrides, modelLocation);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                QuadTransformer qt = new QuadTransformer(transform);
                builder.addAll((Iterable)qt.processMany(ammoModel.getQuads(null, null, new Random(), null)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new BakedWeaponProjectileBowModel(bakery, owner, this, (ImmutableList<BakedQuad>)builder.build(), particleSprite, (ImmutableMap<ItemTransforms.TransformType, Transformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap(), transform.isIdentity(), modelTransform, owner.isSideLit());
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        return texs;
    }

    private static final class BakedWeaponProjectileBowModel
    extends BakedItemModel {
        private final IModelConfiguration owner;
        private final WeaponProjectileBowModel parent;
        private final Map<String, BakedModel> cache;
        private final ModelState originalTransform;
        private final boolean isSideLit;

        BakedWeaponProjectileBowModel(ModelBakery bakery, IModelConfiguration owner, WeaponProjectileBowModel parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemTransforms.TransformType, Transformation> transforms, Map<String, BakedModel> cache, boolean untransformed, ModelState originalTransform, boolean isSideLit) {
            super(quads, particle, transforms, (ItemOverrides)new WeaponProjectileBowOverrideHandler(bakery), untransformed, isSideLit);
            this.owner = owner;
            this.parent = parent;
            this.cache = cache;
            this.originalTransform = originalTransform;
            this.isSideLit = isSideLit;
        }
    }

    private static final class WeaponProjectileBowOverrideHandler
    extends ItemOverrides {
        private final ModelBakery bakery;

        private WeaponProjectileBowOverrideHandler(ModelBakery bakery) {
            this.bakery = bakery;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int v1) {
            float pull = 0.0f;
            BakedWeaponProjectileBowModel model = (BakedWeaponProjectileBowModel)originalModel;
            String ammoLoc = "";
            String ammoNBT = "";
            if (stack != null && stack.m_41720_() instanceof WeaponProjectileBow && entity != null && entity.m_21211_().equals(stack)) {
                WeaponProjectileBow bow = (WeaponProjectileBow)stack.m_41720_();
                ItemStack ammo = bow.getAmmoStack(stack);
                ItemPropertyFunction getter = ItemProperties.m_117829_((Item)bow, (ResourceLocation)new ResourceLocation("pull"));
                if (getter != null) {
                    pull = getter.m_141951_(stack, world, entity, entity.m_142049_());
                }
                if (ammo != null && !ammo.m_41619_()) {
                    CompoundTag nbt;
                    TextureAtlasSprite stackIcon;
                    BakedModel bm = Minecraft.m_91087_().m_91291_().m_174264_(ammo, null, null, entity.m_142049_());
                    if (bm != null && (stackIcon = bm.m_6160_()) != null) {
                        ammoLoc = stackIcon.m_118413_().toString();
                    }
                    if ((nbt = ammo.m_41739_(new CompoundTag())) != null) {
                        ammoNBT = nbt.toString();
                    }
                }
            }
            int pullState = -1;
            String tex = ":item/weapon_projectile_bow_standby";
            if (pull > 0.0f && pull < 0.7f) {
                pullState = 0;
                tex = ":item/weapon_projectile_bow_pulling_0";
            } else if (pull >= 0.7f && pull < 1.5f) {
                pullState = 1;
                tex = ":item/weapon_projectile_bow_pulling_1";
            } else if (pull >= 1.5f) {
                pullState = 2;
                tex = ":item/weapon_projectile_bow_pulling_2";
            }
            WeaponProjectileBowModel parent = new WeaponProjectileBowModel(new ResourceLocation("mahoutsukai" + tex), new ResourceLocation(ammoLoc), ammoNBT, pullState);
            BakedModel bakedModel = parent.bake(model.owner, this.bakery, ForgeModelBakery.defaultTextureGetter(), model.originalTransform, model.m_7343_(), new ResourceLocation("mahoutsukai:weapon_projectile_bow"));
            return bakedModel;
        }
    }

    public static enum Loader implements IModelLoader<WeaponProjectileBowModel>
    {
        INSTANCE;


        public void m_6213_(ResourceManager resourceManager) {
        }

        public WeaponProjectileBowModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new WeaponProjectileBowModel(null, null, null, 0);
        }
    }
}

