/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;

public class ProximityProjectionKeysModel
implements IModelGeometry<ProximityProjectionKeysModel> {
    public static ResourceLocation redkey = new ResourceLocation("mahoutsukai", "items/red_key_64");
    public static ResourceLocation redkeymodel = new ResourceLocation("mahoutsukai", "item/proximity_projection_key");

    public Collection<? extends IModelGeometryPart> getParts() {
        return null;
    }

    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return Optional.empty();
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        float tx = 8.0f;
        float tz = 8.0f;
        float distance = 2.1f;
        Transformation transform1 = new Transformation(new Vector3f(-tx / 16.0f, tz / 16.0f, 0.0f), new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -90.0f, true), new Vector3f(1.33f, 1.33f, 1.33f), null);
        Transformation transform2 = new Transformation(new Vector3f(-tx / 16.0f, tz / 16.0f, 0.0f + distance / 16.0f), new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -90.0f, true), new Vector3f(1.33f, 1.33f, 1.33f), null);
        Transformation transform3 = new Transformation(new Vector3f(-tx / 16.0f, tz / 16.0f, 0.0f - distance / 16.0f), new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -90.0f, true), new Vector3f(1.33f, 1.33f, 1.33f), null);
        transform1.blockCenterToCorner();
        transform2.blockCenterToCorner();
        transform3.blockCenterToCorner();
        BakedModel akey1 = Minecraft.m_91087_().m_91304_().getModel(redkeymodel);
        BakedModel akey2 = Minecraft.m_91087_().m_91304_().getModel(redkeymodel);
        BakedModel akey3 = Minecraft.m_91087_().m_91304_().getModel(redkeymodel);
        ModelState transformsFromModel = owner.getCombinedTransform();
        ImmutableMap transformMap = transformsFromModel != null ? PerspectiveMapWrapper.getTransforms((ModelState)new CompositeModelState(transformsFromModel, modelTransform)) : PerspectiveMapWrapper.getTransforms((ModelState)modelTransform);
        ImmutableList.Builder quadBuilder = ImmutableList.builder();
        if (akey1 != null && akey2 != null && akey3 != null) {
            QuadTransformer qt1 = new QuadTransformer(transform1);
            QuadTransformer qt2 = new QuadTransformer(transform2);
            QuadTransformer qt3 = new QuadTransformer(transform3);
            quadBuilder.addAll((Iterable)qt1.processMany(akey1.getQuads(null, null, new Random(), (IModelData)EmptyModelData.INSTANCE)));
            quadBuilder.addAll((Iterable)qt2.processMany(akey2.getQuads(null, null, new Random(), (IModelData)EmptyModelData.INSTANCE)));
            quadBuilder.addAll((Iterable)qt3.processMany(akey3.getQuads(null, null, new Random(), (IModelData)EmptyModelData.INSTANCE)));
        }
        return new BakedProximityProjectionKeysModel(bakery, owner, this, (ImmutableList<BakedQuad>)quadBuilder.build(), spriteGetter.apply(owner.resolveTexture(redkey.toString())), (ImmutableMap<ItemTransforms.TransformType, Transformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap(), modelTransform.m_6189_().isIdentity(), modelTransform, owner.isSideLit());
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        texs.add(owner.resolveTexture(redkey.toString()));
        return texs;
    }

    private static final class BakedProximityProjectionKeysModel
    extends BakedItemModel {
        private final IModelConfiguration owner;
        private final ProximityProjectionKeysModel parent;
        private final Map<String, BakedModel> cache;
        private final ModelState originalTransform;
        private final boolean isSideLit;

        BakedProximityProjectionKeysModel(ModelBakery bakery, IModelConfiguration owner, ProximityProjectionKeysModel parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemTransforms.TransformType, Transformation> transforms, Map<String, BakedModel> cache, boolean untransformed, ModelState originalTransform, boolean isSideLit) {
            super(quads, particle, transforms, (ItemOverrides)new ProximityProjectionKeysOverrideHandler(bakery), untransformed, isSideLit);
            this.owner = owner;
            this.parent = parent;
            this.cache = cache;
            this.originalTransform = originalTransform;
            this.isSideLit = isSideLit;
        }
    }

    private static final class ProximityProjectionKeysOverrideHandler
    extends ItemOverrides {
        private final ModelBakery bakery;

        private ProximityProjectionKeysOverrideHandler(ModelBakery bakery) {
            this.bakery = bakery;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int p_173469_) {
            BakedProximityProjectionKeysModel model = (BakedProximityProjectionKeysModel)originalModel;
            ProximityProjectionKeysModel parent = new ProximityProjectionKeysModel();
            BakedModel bakedModel = parent.bake(model.owner, this.bakery, ForgeModelBakery.defaultTextureGetter(), model.originalTransform, model.m_7343_(), new ResourceLocation("mahoutsukai:proximity_projection_keys"));
            return bakedModel;
        }
    }

    public static enum Loader implements IModelLoader<ProximityProjectionKeysModel>
    {
        INSTANCE;


        public void m_6213_(ResourceManager resourceManager) {
        }

        public ProximityProjectionKeysModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new ProximityProjectionKeysModel();
        }
    }
}

