/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.Keybinds;
import stepsword.mahoutsukai.item.replica.Replica;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.ReplicaSwitchPacket;

public class ReplicaGui
extends Screen {
    private int NUM_SECTORS = 7;
    int slotSelected = -1;
    ItemStack stack;
    Level world;

    public ReplicaGui(Level w, ItemStack i) {
        super((Component)new TextComponent(""));
        this.world = w;
        this.stack = i;
        this.f_96541_ = Minecraft.m_91087_();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        int maxRadius = 80;
        double angle = ReplicaGui.mouseAngle(x, y, mouseX, mouseY);
        float step = (float)Math.PI / 180;
        float degPer = (float)Math.PI * 2 / (float)this.NUM_SECTORS;
        this.slotSelected = -1;
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buf = tess.m_85915_();
        GlStateManager.m_84094_();
        GlStateManager.m_84110_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < this.NUM_SECTORS; ++i) {
            boolean mouseInSector = (double)(degPer * (float)i) < angle && angle < (double)(degPer * (float)(i + 1));
            float radius = maxRadius;
            if (mouseInSector) {
                radius *= 1.025f;
            }
            int gs = 64;
            if (i % 2 == 0) {
                gs += 25;
            }
            int r = gs;
            int g = gs;
            int b = gs;
            int a = 102;
            if (i == 0) {
                buf.m_5483_((double)x, (double)y, 0.0).m_6122_(r, g, b, a).m_5752_();
            }
            if (mouseInSector) {
                this.slotSelected = i;
                b = 255;
                g = 255;
                r = 255;
            }
            for (float j = 0.0f; j < degPer + step / 2.0f; j += step) {
                float rad = j + (float)i * degPer;
                float xp = (float)x + Mth.m_14089_((float)rad) * radius;
                float yp = (float)y + Mth.m_14031_((float)rad) * radius;
                if (j == 0.0f) {
                    buf.m_5483_((double)xp, (double)yp, 0.0).m_6122_(r, g, b, a).m_5752_();
                }
                buf.m_5483_((double)xp, (double)yp, 0.0).m_6122_(r, g, b, a).m_5752_();
            }
        }
        tess.m_85914_();
        GlStateManager.m_84091_();
        GlStateManager.m_84109_();
        if (stack != null) {
            for (int j = 0; j < this.NUM_SECTORS; ++j) {
                boolean mouseInSector = (double)(degPer * (float)j) < angle && angle < (double)(degPer * (float)(j + 1));
                float radius = maxRadius;
                if (mouseInSector) {
                    radius *= 1.025f;
                }
                float rad = (float)j * degPer;
                float xp = (float)x + Mth.m_14089_((float)rad) * radius;
                float yp = (float)y + Mth.m_14031_((float)rad) * radius;
                float xsp = xp - 4.0f;
                float ysp = yp;
                String name = j < this.NUM_SECTORS - 1 ? (this.stack.m_41720_() instanceof Replica ? Replica.getDamageTypeForSlot(this.stack, j) : "EMPTY") : "CLEAR ALL";
                int width = this.f_96547_.m_92895_(name);
                double mod = 0.6;
                float nextRad = (float)(j + 1) * degPer;
                float x3 = (float)x + Mth.m_14089_((float)nextRad) * radius;
                float y3 = (float)y + Mth.m_14031_((float)nextRad) * radius;
                xsp = xp + (float)x + x3 - 33.0f;
                ysp = yp + (float)y + y3;
                this.f_96547_.m_92750_(stack, name, xsp /= 3.0f, ysp /= 3.0f, 0xFFFFFF);
                mod = 0.8;
            }
        }
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (Mth.m_14136_((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }

    public void m_96624_() {
        super.m_96624_();
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Keybinds.changeMysticCode.getKey().m_84873_())) {
            this.f_96541_.m_91152_(null);
            if (this.slotSelected != -1) {
                int slot = this.slotSelected;
                ReplicaSwitchPacket message = new ReplicaSwitchPacket(slot);
                PacketHandler.sendToServer(message);
            }
        }
        ImmutableSet set = ImmutableSet.of((Object)this.f_96541_.f_91066_.f_92085_, (Object)this.f_96541_.f_91066_.f_92086_, (Object)this.f_96541_.f_91066_.f_92087_, (Object)this.f_96541_.f_91066_.f_92088_, (Object)this.f_96541_.f_91066_.f_92090_, (Object)this.f_96541_.f_91066_.f_92091_, (Object[])new KeyMapping[]{this.f_96541_.f_91066_.f_92089_});
        for (KeyMapping k : set) {
            KeyMapping.m_90837_((InputConstants.Key)k.getKey(), (boolean)k.m_90857_());
        }
    }
}

