/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import stepsword.mahoutsukai.Keybinds;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.gui.MahoujinHUD;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.circuits.ManaCircuitTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MahouGui {
    public static void manaText(PoseStack matrix) {
        Font fr = Minecraft.m_91087_().f_91062_;
        String preText = "Mahou";
        int color = 0xDDDDFF;
        IMahou mahou = Utils.getPlayerMahou((Player)Minecraft.m_91087_().f_91074_);
        if (mahou != null && mahou.hasMagic() && mahou.getVisible()) {
            int storedMana = mahou.getStoredMana();
            int maxMana = mahou.getMaxMana();
            fr.m_92750_(matrix, preText + " " + storedMana + " / " + maxMana, (float)MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_X, (float)MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_Y, color);
            MahouGui.infoOverlay(matrix, mahou, 0, fr, color);
        }
        MahouGui.circuitOverlay(matrix, fr, preText, color);
        MahouGui.projectorOverlay(matrix, fr);
    }

    public static void infoOverlay(PoseStack matrix, IMahou mahou, int dist, Font fr, int color) {
        if (mahou.getDeathCollectionUsesLeft() > 0.0f) {
            String souls = I18n.m_118938_((String)"mahoutsukai.souls.collected", (Object[])new Object[0]);
            String drain = I18n.m_118938_((String)"mahoutsukai.souls.drain", (Object[])new Object[0]);
            double mdrain = (double)mahou.getDeathCollectionUsesLeft() * MTConfig.DEATH_COLLECTION_DRAIN_PER_SOUL;
            String manadrain = String.format("%.2f", mdrain);
            fr.m_92750_(matrix, souls + " " + mahou.getDeathCollectionUsesLeft() + " (-" + manadrain + " " + drain + ")", (float)MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_X, (float)(MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_Y + (dist += 12)), color);
        }
        if (mahou.getDamageExchangeUses() > 0) {
            String damageExchange = I18n.m_118938_((String)"mahoutsukai.damage_exchange.count", (Object[])new Object[0]);
            fr.m_92750_(matrix, damageExchange + " " + mahou.getDamageExchangeUses(), (float)MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_X, (float)(MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_Y + (dist += 12)), color);
        }
        if (mahou.getImmunityDamageType() != null && EffectUtil.hasBuff((LivingEntity)Minecraft.m_91087_().f_91074_, ModEffects.IMMUNITY_EXCHANGE)) {
            String immunityExchange = I18n.m_118938_((String)"mahoutsukai.immunity_exchange.last", (Object[])new Object[0]);
            fr.m_92750_(matrix, immunityExchange + " " + mahou.getImmunityDamageType(), (float)MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_X, (float)(MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_Y + (dist += 12)), color);
        }
    }

    public static void mahoujinOverlay(PoseStack matrix) {
        MahoujinTileEntity mte;
        BlockEntity te;
        BlockHitResult bresult;
        BlockPos pos;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        HitResult result = Minecraft.m_91087_().f_91077_;
        if (result != null && player != null && result.m_6662_() == HitResult.Type.BLOCK && (pos = (bresult = (BlockHitResult)result).m_82425_()) != null && (te = player.f_19853_.m_7702_(pos)) instanceof MahoujinTileEntity && ((mte = (MahoujinTileEntity)te).getCatalysts() == null || mte.getCatalysts().size() == 0) && player.m_21205_().m_41619_()) {
            MahoujinHUD.renderHUD(Minecraft.m_91087_());
        }
    }

    public static void circuitOverlay(PoseStack matrix, Font fr, String preText, int color) {
        BlockEntity te;
        BlockHitResult bresult;
        BlockPos pos;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        HitResult result = Minecraft.m_91087_().f_91077_;
        if (result != null && player != null && result.m_6662_() == HitResult.Type.BLOCK && (pos = (bresult = (BlockHitResult)result).m_82425_()) != null && (te = player.f_19853_.m_7702_(pos)) instanceof ManaCircuitTileEntity) {
            String s;
            ManaCircuitTileEntity mte = (ManaCircuitTileEntity)te;
            int xc = Minecraft.m_91087_().m_91268_().m_85445_() / 2;
            int yc = Minecraft.m_91087_().m_91268_().m_85446_() / 2 + 8;
            if (mte.isRedstoneOn()) {
                s = new TranslatableComponent("mahoutsukai.circuit.poweredon").getString();
                fr.m_92750_(matrix, s, (float)(xc - 30), (float)yc, color);
            } else {
                s = new TranslatableComponent("mahoutsukai.circuit.poweredoff").getString();
                fr.m_92750_(matrix, s, (float)(xc - 30), (float)yc, color);
            }
            fr.m_92750_(matrix, preText + " " + mte.getMana() + " / " + mte.getMaxMana(), (float)(xc - 30), (float)(yc + 14), color);
            if (player.m_142081_().equals(mte.getOwnerUUID())) {
                s = new TranslatableComponent("mahoutsukai.circuit.yours").getString();
                fr.m_92750_(matrix, s, (float)(xc - 30), (float)(yc + 28), color);
            } else {
                s = new TranslatableComponent("mahoutsukai.circuit.notyours").getString();
                fr.m_92750_(matrix, s, (float)(xc - 30), (float)(yc + 28), color);
            }
            if (mte.getFae()) {
                s = new TranslatableComponent("mahoutsukai.circuit.fae_open").getString();
                fr.m_92750_(matrix, s, (float)(xc - 30), (float)(yc + 42), color);
            } else {
                s = new TranslatableComponent("mahoutsukai.circuit.fae_closed").getString();
                fr.m_92750_(matrix, s, (float)(xc - 30), (float)(yc + 42), color);
            }
        }
    }

    public static void projectorOverlay(PoseStack matrix, Font fr) {
        BlockEntity te;
        BlockHitResult bresult;
        BlockPos pos;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        HitResult result = Minecraft.m_91087_().f_91077_;
        int active = 0xDDDDFF;
        int inactive = 0x444466;
        if (result != null && player != null && result.m_6662_() == HitResult.Type.BLOCK && (pos = (bresult = (BlockHitResult)result).m_82425_()) != null && (te = player.f_19853_.m_7702_(pos)) instanceof MahoujinProjectorTileEntity && player.m_21205_().m_41720_() instanceof ArmorItem) {
            int xc = Minecraft.m_91087_().m_91268_().m_85445_() / 2;
            int yc = Minecraft.m_91087_().m_91268_().m_85446_() / 2 + 8;
            String s = new TranslatableComponent("mahoutsukai.projector_overlay.armor_replace").getString();
            Object s2 = new TranslatableComponent("mahoutsukai.projector_overlay.armor_add").getString();
            Object s3 = new TranslatableComponent("mahoutsukai.projector_overlay.armor_remove").getString();
            s2 = "[" + Keybinds.changeMysticCode.m_90863_().getString().toUpperCase() + "]" + (String)s2;
            s3 = "[" + Keybinds.drawMahoujin.m_90863_().getString().toUpperCase() + "]" + (String)s3;
            fr.m_92750_(matrix, s, (float)(xc - 30), (float)(yc + 14), active);
            fr.m_92750_(matrix, (String)s2, (float)(xc - 30), (float)(yc + 28), Keybinds.changeMysticCode.m_90857_() ? active : inactive);
            fr.m_92750_(matrix, (String)s3, (float)(xc - 30), (float)(yc + 42), !Keybinds.changeMysticCode.m_90857_() && Keybinds.drawMahoujin.m_90857_() ? active : inactive);
        }
    }
}

