/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import stepsword.mahoutsukai.entity.FamiliarEntity;
import stepsword.mahoutsukai.render.entity.familiar.FamiliarModelRenderer;

public class ModelFamiliar
extends HierarchicalModel<FamiliarEntity> {
    FamiliarModelRenderer body;
    FamiliarModelRenderer tail;
    FamiliarModelRenderer wingLeft;
    FamiliarModelRenderer wingRight;
    FamiliarModelRenderer head;
    FamiliarModelRenderer beak1;
    FamiliarModelRenderer legLeft;
    FamiliarModelRenderer legRight;
    List<FamiliarModelRenderer> parts = new ArrayList<FamiliarModelRenderer>();
    List<FamiliarModelRenderer> renderparts = new ArrayList<FamiliarModelRenderer>();
    private State state = State.STANDING;

    public ModelFamiliar() {
        this.body = new FamiliarModelRenderer((Model)this, 0, 0);
        this.body.addBox(-1.5f, 2.0f, -1.5f, 3.0f, 4.0f, 3.0f);
        this.body.m_104227_(0.0f, 16.5f, -3.0f);
        this.tail = new FamiliarModelRenderer((Model)this, 0, 0);
        this.tail.addBox(-1.5f, -1.0f, -1.0f, 3.0f, 4.0f, 1.0f);
        this.tail.m_104227_(0.0f, 21.07f, 1.16f);
        this.wingLeft = new FamiliarModelRenderer((Model)this, 0, 0);
        this.wingLeft.addBox(-1.0f, 1.8f, -1.5f, 1.0f, 5.0f, 3.0f);
        this.wingLeft.m_104227_(1.5f, 16.94f, -3.26f);
        this.wingRight = new FamiliarModelRenderer((Model)this, 0, 0);
        this.wingRight.addBox(-0.0f, 1.8f, -1.5f, 1.0f, 5.0f, 3.0f);
        this.wingRight.m_104227_(-1.5f, 16.94f, -3.26f);
        this.head = new FamiliarModelRenderer((Model)this, 0, 0);
        this.head.addBox(-1.0f, 0.5f, -1.0f, 2.0f, 3.0f, 2.0f);
        this.head.m_104227_(0.0f, 15.69f, -2.76f);
        this.beak1 = new FamiliarModelRenderer((Model)this, 0, 0);
        this.beak1.addBox(-0.5f, 1.2f, -0.5f, 1.0f, 1.0f, 1.0f);
        this.beak1.m_104227_(0.0f, -0.5f, -1.5f);
        this.head.addChild(this.beak1);
        this.legLeft = new FamiliarModelRenderer((Model)this, 0, 0);
        this.legLeft.addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        this.legLeft.m_104227_(1.0f, 22.0f, -1.05f);
        this.legRight = new FamiliarModelRenderer((Model)this, 0, 0);
        this.legRight.addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        this.legRight.m_104227_(-1.0f, 22.0f, -1.05f);
        this.parts.add(this.body);
        this.parts.add(this.tail);
        this.parts.add(this.wingLeft);
        this.parts.add(this.wingRight);
        this.parts.add(this.head);
        this.parts.add(this.beak1);
        this.parts.add(this.legLeft);
        this.parts.add(this.legRight);
        for (FamiliarModelRenderer b : this.parts) {
            this.addBoxesToEachFace(b);
        }
    }

    public void addBoxesToEachFace(FamiliarModelRenderer box) {
        float rs = -0.001f;
        int sz = box.cubeList.size();
        for (int j = 0; j < sz; ++j) {
            FamiliarModelRenderer.ModelBox b = (FamiliarModelRenderer.ModelBox)((Object)box.cubeList.get(j));
            FamiliarModelRenderer mr = new FamiliarModelRenderer((Model)this, 0, 0);
            mr.addBox(b.posX1 + rs, b.posY1 + rs, b.posZ1 + rs, b.posX2 - b.posX1 - rs - rs, b.posY2 - b.posY1 - rs - rs, b.posZ2 - b.posZ1 - rs - rs);
            box.addChild(mr);
            mr.isRenderChild = true;
        }
    }

    public Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)((Object)this.body), (Object)((Object)this.wingLeft), (Object)((Object)this.wingRight), (Object)((Object)this.tail), (Object)((Object)this.head), (Object)((Object)this.legLeft), (Object)((Object)this.legRight));
    }

    public Iterable<FamiliarModelRenderer> getFParts() {
        return ImmutableList.of((Object)((Object)this.body), (Object)((Object)this.wingLeft), (Object)((Object)this.wingRight), (Object)((Object)this.tail), (Object)((Object)this.head), (Object)((Object)this.legLeft), (Object)((Object)this.legRight));
    }

    public void setupAnim(FamiliarEntity familiarEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks * 0.3f;
        this.head.rotateAngleX = headPitch * ((float)Math.PI / 180);
        this.head.rotateAngleY = netHeadYaw * ((float)Math.PI / 180);
        this.head.rotateAngleZ = 0.0f;
        this.head.rotationPointX = 0.0f;
        this.body.rotationPointX = 0.0f;
        this.tail.rotationPointX = 0.0f;
        this.wingRight.rotationPointX = -1.3f;
        this.wingLeft.rotationPointX = 1.3f;
        if (this.state != State.FLYING) {
            if (this.state == State.SITTING) {
                return;
            }
            this.legLeft.rotateAngleX += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.legRight.rotateAngleX += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        this.head.rotationPointY = 15.69f + f;
        this.tail.rotateAngleX = 1.015f + Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.3f * limbSwingAmount;
        this.tail.rotationPointY = 21.07f + f;
        this.body.rotationPointY = 16.5f + f;
        this.wingLeft.rotateAngleZ = -0.0873f - ageInTicks;
        this.wingLeft.rotationPointY = 17.94f + f;
        this.wingRight.rotateAngleZ = 0.0873f + ageInTicks;
        this.wingRight.rotationPointY = 17.94f + f;
        this.legLeft.rotationPointY = 22.0f + f;
        this.legRight.rotationPointY = 22.0f + f;
    }

    public void prepareMobModel(FamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.body.rotateAngleX = 0.4937f;
        this.wingLeft.rotateAngleX = -0.69813174f;
        this.wingLeft.rotateAngleY = (float)(-Math.PI);
        this.wingRight.rotateAngleX = -0.69813174f;
        this.wingRight.rotateAngleY = (float)(-Math.PI);
        this.legLeft.rotateAngleX = -0.0299f;
        this.legRight.rotateAngleX = -0.0299f;
        this.legLeft.rotationPointY = 22.0f;
        this.legRight.rotationPointY = 22.0f;
        if (entitylivingbaseIn instanceof FamiliarEntity) {
            FamiliarEntity familiar = entitylivingbaseIn;
            if (familiar.m_142592_()) {
                this.legLeft.rotateAngleX += 0.69813174f;
                this.legRight.rotateAngleX += 0.69813174f;
                this.state = State.FLYING;
            } else {
                this.state = State.STANDING;
            }
            this.legLeft.rotateAngleZ = 0.0f;
            this.legRight.rotateAngleZ = 0.0f;
        }
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
    }

    public ModelPart m_142109_() {
        return null;
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.getFParts().forEach(p_228272_8_ -> p_228272_8_.render(stack, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    static enum State {
        FLYING,
        STANDING,
        SITTING;

    }
}

