/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.proxy;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import stepsword.mahoutsukai.Keybinds;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.client.ClientHandlerModEventBus;
import stepsword.mahoutsukai.entity.mahoujin.GandrEntity;
import stepsword.mahoutsukai.entity.mahoujin.ReplicaTeleportMahoujinEntity;
import stepsword.mahoutsukai.item.guide.ContentsPage;
import stepsword.mahoutsukai.item.guide.DoubleInfoPage;
import stepsword.mahoutsukai.item.guide.GuidebookInstance;
import stepsword.mahoutsukai.item.guide.InfoPage;
import stepsword.mahoutsukai.item.guide.Page;
import stepsword.mahoutsukai.item.guide.SpellPage;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.ProjectorRightClickPacket;
import stepsword.mahoutsukai.proxy.CommonProxy;
import stepsword.mahoutsukai.render.gui.FogProjectorScreen;
import stepsword.mahoutsukai.render.gui.MahoujinProjectorScreen;
import stepsword.mahoutsukai.render.gui.PlayerSettingsGUI;
import stepsword.mahoutsukai.render.gui.ReplicaGui;
import stepsword.mahoutsukai.render.gui.WheelGui;
import stepsword.mahoutsukai.render.gui.guide.ContentsPageGui;
import stepsword.mahoutsukai.render.gui.guide.DoubleInfoPageGui;
import stepsword.mahoutsukai.render.gui.guide.InfoPageGui;
import stepsword.mahoutsukai.render.gui.guide.PageGui;
import stepsword.mahoutsukai.render.gui.guide.SpellPageGui;
import stepsword.mahoutsukai.render.particle.FogParticleType;
import stepsword.mahoutsukai.render.particle.LightningParticleType;
import stepsword.mahoutsukai.render.particle.MagicParticleType;
import stepsword.mahoutsukai.render.particle.ModParticles;
import stepsword.mahoutsukai.render.particle.ParticleFog;
import stepsword.mahoutsukai.render.particle.ParticleMagic;
import stepsword.mahoutsukai.render.particle.PetalParticleType;
import stepsword.mahoutsukai.tile.displacement.ScryingMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class ClientProxy
extends CommonProxy {
    boolean sensechanged = false;
    double oldsense;
    static Field entities;
    static Field particles;
    static Map<ParticleRenderType, Queue<Particle>> ps;

    @Override
    public void openProjectorGUI(Level w, BlockPos p) {
        Minecraft.m_91087_().m_91152_((Screen)new MahoujinProjectorScreen(w, p));
    }

    @Override
    public void openSettingsGUI(Level w, UUID uuid) {
        Minecraft.m_91087_().m_91152_((Screen)new PlayerSettingsGUI(w, uuid));
    }

    @Override
    public void openFogProjectorGUI(Level w, BlockPos p) {
        Minecraft.m_91087_().m_91152_((Screen)new FogProjectorScreen(w, p));
    }

    @Override
    public void spawnFog(BlockPos blockPos, float particle_fog_size, float r, float g, float b, float a, float particle_fog_thickness, float particle_fog_speed, boolean particle_fog_random_x, boolean particle_fog_random_y, boolean particle_fog_random_z, float particle_fog_direction_x, float particle_fog_direction_y, float particle_fog_direction_z, boolean particle_fog_shaders, int particle_fog_frequency_num) {
        Vec3 direction = new Vec3((double)particle_fog_direction_x, (double)particle_fog_direction_y, (double)particle_fog_direction_z);
        direction = direction.m_82541_();
        Random random = Minecraft.m_91087_().f_91073_.f_46441_;
        for (int i = 0; i < particle_fog_frequency_num; ++i) {
            double newX = direction.f_82479_;
            double newY = direction.f_82480_;
            double newZ = direction.f_82481_;
            if (particle_fog_random_x) {
                newX = random.nextDouble() * 2.0 - 1.0;
            }
            if (particle_fog_random_y) {
                newY = random.nextDouble() * 2.0 - 1.0;
            }
            if (particle_fog_random_z) {
                newZ = random.nextDouble() * 2.0 - 1.0;
            }
            direction = new Vec3(newX, newY, newZ);
            direction = direction.m_82541_();
            direction = direction.m_82490_((double)particle_fog_speed);
            ParticleFog p = new ParticleFog(Minecraft.m_91087_().f_91073_, new ResourceLocation("mahoutsukai", "textures/particle/fog3.png"), (float)blockPos.m_123341_() + 0.5f, (float)blockPos.m_123342_() + 0.5f, (float)blockPos.m_123343_() + 0.5f, 0.5f, direction.f_82479_, direction.f_82480_, direction.f_82481_, particle_fog_shaders, r, g, b, a, particle_fog_thickness, particle_fog_size);
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)p);
        }
    }

    @Override
    public void openWheelGUI(Level w, ItemStack s) {
        Minecraft.m_91087_().m_91152_((Screen)new WheelGui(w, s));
    }

    @Override
    public void openReplicaWheelGUI(Level w, ItemStack s) {
        Minecraft.m_91087_().m_91152_((Screen)new ReplicaGui(w, s));
    }

    @Override
    public void init() {
        ClientHandler client = new ClientHandler();
        MinecraftForge.EVENT_BUS.register((Object)client);
        ClientHandlerModEventBus clientMod = new ClientHandlerModEventBus();
        MahouTsukaiMod.MOD_EVENT_BUS.register((Object)clientMod);
        super.init();
    }

    @Override
    public boolean handleMaterialAcceleration(Entity entityIn) {
        return false;
    }

    @Override
    public Player getPlayerForScry(Level world, String viewTarget, CompoundTag scryNBT, UUID uuid) {
        Player playertarget = ScryingMahoujinTileEntity.getPlayerByName(viewTarget, world);
        if (playertarget == null && uuid != null) {
            RemotePlayer player = new RemotePlayer((ClientLevel)world, new GameProfile(uuid, viewTarget));
            try {
                player.m_20258_(scryNBT);
            }
            catch (Exception e) {
                System.err.println("Mahou Tsukai: Could not read player NBT:" + e.toString());
            }
            return player;
        }
        if (playertarget != null && scryNBT != null) {
            RemotePlayer player = new RemotePlayer((ClientLevel)world, playertarget.m_36316_());
            try {
                player.m_20258_(scryNBT);
            }
            catch (Exception e) {
                System.err.println("Mahou Tsukai: Could not read player NBT:" + e.toString());
            }
            return player;
        }
        return null;
    }

    @Override
    public void revertPlayer() {
        super.revertPlayer();
    }

    public static HashSet<Entity> getAllEntities(ClientLevel world) {
        return new HashSet<Entity>(StreamSupport.stream(world.m_142646_().m_142273_().spliterator(), false).collect(Collectors.toSet()));
    }

    @Override
    public void openGuideGUI(GuidebookInstance book, Player playerIn) {
        IMahou mahou = Utils.getPlayerMahou(playerIn);
        int savedPage = 0;
        if (mahou != null) {
            savedPage = mahou.getGuidePage();
        }
        book.setCurrentPage(savedPage);
        if (book.getPage() instanceof ContentsPage) {
            Minecraft.m_91087_().m_91152_((Screen)new ContentsPageGui(book, (ContentsPage)book.getPage()));
        } else if (book.getPage() instanceof InfoPage) {
            Minecraft.m_91087_().m_91152_((Screen)new InfoPageGui(book, (InfoPage)book.getPage()));
        } else if (book.getPage() instanceof SpellPage) {
            Minecraft.m_91087_().m_91152_((Screen)new SpellPageGui(book, (SpellPage)book.getPage()));
        } else if (book.getPage() instanceof DoubleInfoPage) {
            Minecraft.m_91087_().m_91152_((Screen)new DoubleInfoPageGui(book, (DoubleInfoPage)book.getPage()));
        } else if (book.getPage() instanceof Page) {
            Minecraft.m_91087_().m_91152_((Screen)new PageGui(book));
        }
    }

    @Override
    public void slowDown() {
        if (!this.sensechanged) {
            this.oldsense = Minecraft.m_91087_().f_91066_.f_92053_;
            Minecraft.m_91087_().f_91066_.f_92053_ *= (double)0.34f;
            this.sensechanged = true;
        }
    }

    @Override
    public void speedUp() {
        if (this.sensechanged) {
            Minecraft.m_91087_().f_91066_.f_92053_ = this.oldsense;
            this.sensechanged = false;
        }
    }

    @Override
    public boolean isMahouTsukai() {
        IMahou mahou = Utils.getPlayerMahou((Player)Minecraft.m_91087_().f_91074_);
        if (mahou != null) {
            return mahou.hasMagic();
        }
        return false;
    }

    @Override
    public void playSound(double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity(null, (SoundEvent)soundIn, (SoundSource)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = event.getSound();
        category = event.getCategory();
        volume = event.getVolume();
        this.playSound(x, y, z, soundIn, category, volume, pitch, false);
    }

    public void playSound(double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch, boolean distanceDelay) {
        double d0 = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82531_(x, y, z);
        SimpleSoundInstance simplesound = new SimpleSoundInstance(soundIn, category, volume, pitch, (double)((float)x), (double)((float)y), (double)((float)z));
        if (distanceDelay && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)simplesound, (int)(d1 * 20.0));
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)simplesound);
        }
    }

    @Override
    public void registerFactories() {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticles.PETAL, PetalParticleType.PetalFactory::new);
        Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)ModParticles.RED_LIGHTNING, (ParticleProvider)new LightningParticleType.LightningFactory(new Color(255, 0, 0, 255), new Color(255, 120, 120)));
        Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)ModParticles.YELLOW_LIGHTNING, (ParticleProvider)new LightningParticleType.LightningFactory(new Color(255, 255, 0, 255), new Color(255, 255, 70)));
        Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)ModParticles.FOG1, (ParticleProvider)new FogParticleType.FogFactory(new ResourceLocation("mahoutsukai", "textures/particle/fog3.png")));
        Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)ModParticles.RED_MAGIC, (ParticleProvider)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 0.2f, 1.0f, 0.0f, 0.0f, 1.0f, true));
        Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)ModParticles.YELLOW_MAGIC, (ParticleProvider)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 0.6f, 1.0f, 1.0f, 0.2f, 0.9f, false));
        Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)ModParticles.BLACK_MAGIC, (ParticleProvider)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 0.2f, 0.0f, 0.0f, 0.0f, 1.0f, true));
        Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)ModParticles.RED_MAGIC_BIG, (ParticleProvider)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 1.2f, 1.0f, 0.0f, 0.0f, 0.0f, true));
        Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)ModParticles.BLACK_MAGIC_BIG, (ParticleProvider)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 1.2f, 0.0f, 0.0f, 0.0f, 1.0f, true));
    }

    public static HashSet<Particle> getNoRenderParticles(ParticleEngine manager) {
        Queue<Particle> q;
        if (ps == null) {
            ps = (Map)ObfuscationReflectionHelper.getPrivateValue(ParticleEngine.class, (Object)manager, (String)"f_107289_");
        }
        if (ps != null && (q = ps.get(ParticleRenderType.f_107434_)) != null) {
            return new HashSet<Particle>(q);
        }
        return new HashSet<Particle>();
    }

    @Override
    public void smiteParticles(double x, double y, double z, Random rand, boolean boom, float size, float r, float g, float b) {
        block4: {
            double range = 0.0;
            if (Minecraft.m_91087_().f_91073_ == null) break block4;
            if (!boom) {
                for (int i = 0; i < 6; ++i) {
                    double xoff = (rand.nextDouble() - 0.5) * range;
                    double yoff = (rand.nextDouble() - 0.5) * 1.2;
                    double zoff = (rand.nextDouble() - 0.5) * range;
                    ParticleMagic p = new ParticleMagic(Minecraft.m_91087_().f_91073_, x + xoff, y + (double)i * 0.16, z + zoff, 0.5f, 0.0, 0.0, 0.0, "textures/particle/white_magic_particle", size, r, g, b, 1.0f, 36.0f);
                    Minecraft.m_91087_().f_91061_.m_107344_((Particle)p);
                }
            } else {
                for (int i = 0; i < 30; ++i) {
                    double xoff = 0.0;
                    double yoff = 0.0;
                    double zoff = 0.0;
                    Vec3 vec = new Vec3(rand.nextDouble() - 0.5, 0.0, rand.nextDouble() - 0.5).m_82541_();
                    ParticleMagic p = new ParticleMagic(Minecraft.m_91087_().f_91073_, x, y, z, 0.5f, vec.f_82479_, 0.0, vec.f_82481_, "textures/particle/white_magic_particle", size, r, g, b, 1.0f, 27.0f);
                    Minecraft.m_91087_().f_91061_.m_107344_((Particle)p);
                }
            }
        }
    }

    @Override
    public void spawnGandrParticle(GandrEntity entity) {
        float[] rgb = entity.getColor();
        ParticleMagic p = new ParticleMagic(Minecraft.m_91087_().f_91073_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.5f, 0.0, 0.0, 0.0, "textures/particle/white_magic_particle", 0.2f, rgb[0], rgb[1], rgb[2], 1.0f, false);
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)p);
    }

    @Override
    public void spawnReplicaTeleportParticles(ReplicaTeleportMahoujinEntity entity) {
        float[] rgb = entity.getColor();
        float radius = entity.getCircleSize();
        ParticleStatus particlestatus = Minecraft.m_91087_().f_91066_.f_92073_;
        int particles = 22;
        if (particlestatus == ParticleStatus.DECREASED) {
            particles = 10;
        } else if (particlestatus == ParticleStatus.MINIMAL) {
            particles = 5;
        }
        int i = 0;
        while ((float)i < radius * (float)particles) {
            if (Math.random() < 0.03) {
                double r = (double)radius * Math.sqrt(Math.random());
                double theta = Math.random() * 2.0 * Math.PI;
                double x = entity.m_20185_() + r * Math.cos(theta);
                double z = entity.m_20189_() + r * Math.sin(theta);
                double y = entity.m_20186_() + Math.random() * 0.4;
                ParticleMagic p = new ParticleMagic(Minecraft.m_91087_().f_91073_, x, y, z, (float)(Math.random() * 0.4) + 0.2f, 0.0, Math.random() * 0.03 + 0.01, 0.0, "textures/particle/white_magic_particle", (float)Math.random() * 0.6f + 0.1f, rgb[0], rgb[1], rgb[2], 1.0f, false, 0.99);
                Minecraft.m_91087_().f_91061_.m_107344_((Particle)p);
            }
            ++i;
        }
    }

    @Override
    public void projectorArmorClick(Player player, BlockPos pos) {
        if (player.m_21205_().m_41720_() instanceof ArmorItem) {
            ProjectorRightClickPacket.ARMOR_ACTION action = ProjectorRightClickPacket.ARMOR_ACTION.REPLACE;
            if (Keybinds.changeMysticCode.m_90857_()) {
                action = ProjectorRightClickPacket.ARMOR_ACTION.ADD;
            } else if (Keybinds.drawMahoujin.m_90857_()) {
                action = ProjectorRightClickPacket.ARMOR_ACTION.REMOVE;
            }
            ProjectorRightClickPacket packet = new ProjectorRightClickPacket(action, pos);
            PacketHandler.sendToServer(packet);
        }
    }

    static {
        ps = null;
    }
}

