/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.SmiteEntity;
import stepsword.mahoutsukai.entity.mahoujin.ReplicaTeleportMahoujinEntity;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.item.replica.Replica;
import stepsword.mahoutsukai.item.spells.projection.PowerConsolidation.Caliburn;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RagePotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ItemAbilityPacket {
    ABILITY ability;

    public ItemAbilityPacket() {
    }

    public ItemAbilityPacket(ABILITY a) {
        this.ability = a;
    }

    public void fromBytes(ByteBuf buf) {
        int n = buf.readInt();
        this.ability = n < ABILITY.values().length ? ABILITY.values()[n] : ABILITY.CALIBURN;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.ability.ordinal());
    }

    public static void encode(ItemAbilityPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static ItemAbilityPacket decode(FriendlyByteBuf buf) {
        ItemAbilityPacket msg = new ItemAbilityPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final ItemAbilityPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                if (((NetworkEvent.Context)context.get()).getSender() instanceof ServerPlayer) {
                    if (message.ability == ABILITY.CALIBURN) {
                        ItemAbilityPacket.handleAbilityCaliburn(((NetworkEvent.Context)context.get()).getSender());
                    } else if (message.ability == ABILITY.MORGAN) {
                        ItemAbilityPacket.handleAbilityMorgan(((NetworkEvent.Context)context.get()).getSender());
                    } else if (message.ability == ABILITY.REPLICA) {
                        ItemAbilityPacket.handleAbilityReplica(((NetworkEvent.Context)context.get()).getSender());
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleAbilityCaliburn(ServerPlayer player) {
        ICaliburnMahou mahou;
        int radius = MTConfig.POWER_CONSOLIDATION_SMITE_RADIUS;
        AABB aabb = new AABB(player.m_20182_().m_82520_((double)(-radius), -4.0, (double)(-radius)), player.m_20182_().m_82520_((double)radius, 4.0, (double)radius));
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof Caliburn && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.CM_COOLDOWN) && PlayerManaManager.drainMana((Player)player, MTConfig.CALIBURN_MORGAN_ABILITY_MANA_COST, false, false) == MTConfig.CALIBURN_MORGAN_ABILITY_MANA_COST && (mahou = Utils.getCaliburnMahou(stack)) != null) {
            int targets = 0;
            List lst = player.f_19853_.m_45976_(LivingEntity.class, aabb);
            for (LivingEntity target : lst) {
                if (target.m_142081_().equals(player.m_142081_()) || !Caliburn.specialTarget(target)) continue;
                ++targets;
            }
            for (LivingEntity target : lst) {
                if (target.m_142081_().equals(player.m_142081_()) || !Caliburn.specialTarget(target)) continue;
                SmiteEntity smite = new SmiteEntity(target.f_19853_, target, 0.9019608f, 0.9019608f, 0.16470589f, 1.0f, 0.1f, mahou.getAttackDamage() / (float)targets);
                smite.m_6034_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                target.f_19853_.m_7967_((Entity)smite);
            }
            EffectUtil.buff((LivingEntity)player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
        }
    }

    public static void handleAbilityMorgan(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof Morgan && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.CM_COOLDOWN)) {
            EffectUtil.buff((LivingEntity)player, ModEffects.RAGE, false, MTConfig.MORGAN_RAGE_TIME);
            RagePotion.notifyIfRage((LivingEntity)player);
            EffectUtil.buff((LivingEntity)player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
        }
    }

    public static void handleAbilityReplica(ServerPlayer player) {
        if (player.m_21211_().m_41720_() instanceof Replica && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.CM_COOLDOWN)) {
            Vec3 teleport = Replica.getTeleportLocation(player.m_21211_());
            ResourceLocation dim = Replica.getTeleportDimension(player.m_21211_());
            if (dim == null) {
                dim = Level.f_46428_.m_135782_();
            }
            if (teleport != null) {
                boolean allowed = true;
                if (MTConfig.REPLICA_TELEPORT_MAX_DISTANCE > 0.0 && teleport.m_82557_(player.m_20182_()) > MTConfig.REPLICA_TELEPORT_MAX_DISTANCE * MTConfig.REPLICA_TELEPORT_MAX_DISTANCE) {
                    allowed = false;
                }
                if (!MTConfig.REPLICA_TELEPORT_CROSS_DIMENSION && !dim.equals((Object)EffectUtil.getDimension(player.f_19853_))) {
                    allowed = false;
                }
                if (allowed && PlayerManaManager.drainMana((Player)player, MTConfig.REPLICA_TELEPORT_MANA_COST, false, false) == MTConfig.REPLICA_TELEPORT_MANA_COST) {
                    ReplicaTeleportMahoujinEntity repte = new ReplicaTeleportMahoujinEntity(player.f_19853_, (LivingEntity)player, 0.24f, 0.94f, 1.0f, 0.8f, dim, teleport, true);
                    repte.m_6034_(player.m_20185_(), player.m_20186_() + 0.005, player.m_20189_());
                    player.f_19853_.m_7967_((Entity)repte);
                    ReplicaTeleportMahoujinEntity repte2 = new ReplicaTeleportMahoujinEntity(player.f_19853_, (LivingEntity)player, 0.24f, 0.94f, 1.0f, 0.8f, dim, teleport, true, false);
                    repte2.m_6034_(teleport.f_82479_, teleport.f_82480_ + 0.005, teleport.f_82481_);
                    player.f_19853_.m_7967_((Entity)repte2);
                    EffectUtil.buff((LivingEntity)player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
                }
            }
        }
    }

    public static enum ABILITY {
        MORGAN,
        CALIBURN,
        REPLICA;

    }
}

