/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection.WeaponProjectile;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.spells.projection.ProjectionSpellScroll;
import stepsword.mahoutsukai.render.item.WeaponProjectileBowRenderer;
import stepsword.mahoutsukai.util.Utils;

public class WeaponProjectileBow
extends BowItem {
    String name = "weapon_projectile_bow";
    public static String AMMO_STACK = "mahoutsukai_ammo_stack";
    private String MODE_TAG = "MAHOUTSUKAI_WPBOW_MODE";

    public WeaponProjectileBow() {
        super(new Item.Properties().m_41487_(1).m_41503_(MTConfig.WEAPON_SHOOTER_DURABILITY).m_41491_(ModItems.MAHOUTSUKAI_CREATIVE_TAB));
    }

    public WeaponProjectileBow setup() {
        this.setRegistryName(this.name);
        return this;
    }

    public boolean m_41465_() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.WEAPON_SHOOTER_DURABILITY;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        boolean flag2;
        ItemStack stack = player.m_21120_(hand);
        ItemStack s = new ItemStack((ItemLike)Items.f_41852_);
        ItemStack weapon = new ItemStack((ItemLike)Items.f_41852_);
        if (this.getMode(stack) == 1) {
            s = this.findAmmo(player, stack, true);
            if (s == null || s.m_41619_() || s.m_41720_() == Items.f_42412_) {
                CompoundTag nbt;
                IScrollMahou mahou;
                ItemStack scroll = this.findProjection(player, stack);
                if (scroll.m_41720_() instanceof ProjectionSpellScroll) {
                    ((ProjectionSpellScroll)scroll.m_41720_()).useAction(scroll, world, (LivingEntity)player, true);
                }
                s = this.findAmmo(player, stack, true);
                if (world.f_46443_ && (s == null || s.m_41619_() || s.m_41720_() == Items.f_42412_) && scroll.m_41720_() instanceof ProjectionSpellScroll && (mahou = Utils.getScrollMahou(scroll)) != null && (nbt = mahou.getSpellStorage()) != null && nbt.m_128441_("MAHOUTSUKAI_MEMORIZED_WEAPON")) {
                    s = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("MAHOUTSUKAI_MEMORIZED_WEAPON")).m_41777_();
                }
            }
            weapon = s;
        } else {
            weapon = s = this.findAmmo(player, stack, false);
        }
        boolean flag = s != null && !s.m_41619_() && s.m_41720_() != Items.f_42412_;
        boolean bl = flag2 = weapon != null && !weapon.m_41619_() && weapon.m_41720_() != Items.f_42412_;
        if ((!flag && !world.f_46443_ || !flag2 && world.f_46443_) && !player.m_20163_()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!player.m_20163_()) {
            this.setAmmoStack(stack, weapon);
            player.m_6672_(hand);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        this.setMode(stack, (this.getMode(stack) + 1) % 2);
        int mode = this.getMode(stack);
        TranslatableComponent tt = mode == 0 ? new TranslatableComponent("mahoutsukai.weaponprojectiles.normal") : new TranslatableComponent("mahoutsukai.weaponprojectiles.projections");
        player.m_5661_((Component)tt, true);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public ItemStack findAmmo(Player player, ItemStack shootable, boolean projectedOnly) {
        ItemStack itemstack1;
        int i;
        if (!(shootable.m_41720_() instanceof WeaponProjectileBow)) {
            return ItemStack.f_41583_;
        }
        Predicate<ItemStack> prepredicate = ((WeaponProjectileBow)shootable.m_41720_()).getPreInventoryAmmoPredicate();
        Predicate<ItemStack> predicate = ((WeaponProjectileBow)shootable.m_41720_()).m_6442_();
        ItemStack itemstack = WeaponProjectileBow.m_43010_((LivingEntity)player, (Predicate)predicate);
        if (!itemstack.m_41619_()) {
            return itemstack;
        }
        prepredicate = ((WeaponProjectileBow)shootable.m_41720_()).getPreInventoryAmmoPredicate();
        predicate = ((WeaponProjectileBow)shootable.m_41720_()).m_6437_();
        for (i = 0; i < player.m_150109_().m_6643_(); ++i) {
            itemstack1 = player.m_150109_().m_8020_(i);
            if (!prepredicate.test(itemstack1)) continue;
            return itemstack1;
        }
        if (!projectedOnly) {
            for (i = 0; i < player.m_150109_().m_6643_(); ++i) {
                itemstack1 = player.m_150109_().m_8020_(i);
                if (!predicate.test(itemstack1)) continue;
                return itemstack1;
            }
        }
        return player.m_150110_().f_35937_ ? new ItemStack((ItemLike)Items.f_42412_) : ItemStack.f_41583_;
    }

    public ItemStack findProjection(Player player, ItemStack shootable) {
        if (!(shootable.m_41720_() instanceof WeaponProjectileBow)) {
            return ItemStack.f_41583_;
        }
        Predicate<ItemStack> predicate = a -> a.m_41720_() instanceof ProjectionSpellScroll;
        ItemStack itemstack = WeaponProjectileBow.m_43010_((LivingEntity)player, predicate);
        if (!itemstack.m_41619_()) {
            return itemstack;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack1 = player.m_150109_().m_8020_(i);
            if (!predicate.test(itemstack1)) continue;
            return itemstack1;
        }
        return player.m_150110_().f_35937_ ? new ItemStack((ItemLike)Items.f_42412_) : ItemStack.f_41583_;
    }

    public void deleteAmmoStack(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_(AMMO_STACK)) {
            nbt.m_128365_(AMMO_STACK, (Tag)new CompoundTag());
            stack.m_41751_(nbt);
        }
    }

    public void setAmmoStack(ItemStack bow, ItemStack projectile) {
        CompoundTag nbt = bow.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128365_(AMMO_STACK, (Tag)projectile.m_41777_().serializeNBT());
        bow.m_41751_(nbt);
    }

    public ItemStack getAmmoStack(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_(AMMO_STACK)) {
            return ItemStack.m_41712_((CompoundTag)((CompoundTag)nbt.m_128423_(AMMO_STACK))).m_41777_();
        }
        return null;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public Predicate<ItemStack> getPreInventoryAmmoPredicate() {
        return s -> this.isArrow((ItemStack)s) && ProjectionSpellEffect.getProjected(s);
    }

    public Predicate<ItemStack> m_6437_() {
        return s -> this.isArrow((ItemStack)s);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity shooter, int useTicks) {
        if (shooter instanceof Player) {
            float f;
            Player player = (Player)shooter;
            ItemStack projectile = new ItemStack((ItemLike)Items.f_41852_);
            projectile = this.getMode(stack) == 1 ? this.findAmmo(player, stack, true) : this.findAmmo(player, stack, false);
            int i = this.m_8105_(stack) - useTicks;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)world, (Player)player, (int)i, (projectile != ItemStack.f_41583_ ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!player.f_19853_.f_46443_) {
                List<Integer> settings = MahouSettings.getIntSettings(player, MahouSettings.Spell.WEAPON_PROJECTILE);
                Utils.color(stack, settings.get(0).intValue(), settings.get(1).intValue(), settings.get(2).intValue(), settings.get(3).intValue(), settings.get(4).intValue(), settings.get(5).intValue());
            }
            if (projectile != ItemStack.f_41583_ && (double)(f = WeaponProjectileBow.m_40661_((int)i)) >= 0.1) {
                if (!world.f_46443_) {
                    if (!this.isArrow(projectile)) {
                        return;
                    }
                    WeaponProjectileEntity projectileEntity = new WeaponProjectileEntity(world, shooter, projectile.m_41777_());
                    projectileEntity.shoot((Entity)shooter, shooter.f_19858_, shooter.f_19857_, 0.0f, (float)((double)f * MTConfig.WEAPON_SHOOTER_PROJECTILE_SPEED), 1.0f);
                    projectileEntity.m_5602_((Entity)shooter);
                    world.m_7967_((Entity)projectileEntity);
                    stack.m_41622_(1, shooter, a -> {});
                }
                if (!player.m_7500_()) {
                    projectile.m_41774_(1);
                    if (stack.m_41619_()) {
                        player.m_150109_().m_36057_(projectile);
                    }
                }
                world.m_5594_(null, shooter.m_142538_(), SoundEvents.f_11687_, SoundSource.NEUTRAL, 1.0f, 1.0f / (shooter.m_21187_().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            }
        }
    }

    protected boolean isArrow(ItemStack stack) {
        Item tmpi = stack.m_41720_();
        return tmpi instanceof SwordItem || tmpi instanceof DiggerItem || tmpi instanceof ShieldItem || tmpi instanceof ShearsItem || tmpi instanceof FishingRodItem || tmpi instanceof HoeItem || tmpi instanceof TridentItem;
    }

    public void setMode(ItemStack gauntlet, int mode) {
        CompoundTag nbt = gauntlet.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128405_(this.MODE_TAG, mode);
        gauntlet.m_41751_(nbt);
    }

    public int getMode(ItemStack gauntlet) {
        CompoundTag nbt = gauntlet.m_41783_();
        if (nbt != null && nbt.m_128441_(this.MODE_TAG)) {
            return nbt.m_128451_(this.MODE_TAG);
        }
        return 0;
    }

    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(WeaponProjectileBowRenderer::new);
    }
}

