/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.replica;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.ReplicaKnockbackParticlePacket;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.item.ReplicaRenderer;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.Utils;

public class Replica
extends ItemBase {
    public static HashMap<String, DamageSource> DAMAGE_SOURCE_REGISTRY = new HashMap();

    public Replica() {
        super("replica", new Item.Properties().m_41487_(1).m_41503_(MTConfig.REPLICA_DURABILITY));
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (!player.f_19853_.f_46443_ && player.m_20142_()) {
            Replica.coverMove(player);
        }
        player.m_6672_(handIn);
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (count == 72000 && !player.f_19853_.f_46443_ && player instanceof Player) {
            if (!player.m_20142_() && player.m_20163_()) {
                Replica.saveTeleportLocation(stack, (Player)player);
            }
            if (!EffectUtil.hasBuff(player, ModEffects.REPLICA_SHOCKWAVE_COOLDOWN) && PlayerManaManager.drainMana((Player)player, MTConfig.REPLICA_ATTACK_MANA_COST, false, false) == MTConfig.REPLICA_ATTACK_MANA_COST) {
                this.bigKnockback((Player)player, stack);
                EffectUtil.buff(player, ModEffects.REPLICA_SHOCKWAVE_COOLDOWN, false, MTConfig.REPLICA_SHOCKWAVE_COOLDOWN, false);
            }
        }
        player.m_20334_(0.0, 0.0, 0.0);
        player.f_19864_ = true;
    }

    public void bigKnockback(Player playerIn, ItemStack stack) {
        double maxRadius = MTConfig.REPLICA_ATTACK_RANGE;
        ReplicaKnockbackParticlePacket packet = new ReplicaKnockbackParticlePacket(playerIn.m_20185_(), playerIn.m_20186_() + (double)(playerIn.m_20206_() / 2.0f), playerIn.m_20189_(), 0.2f, 0.2f, 0.2f);
        PacketHandler.sendTracking((Entity)playerIn, packet);
        PacketHandler.sendTo((ServerPlayer)playerIn, packet);
        List lst = playerIn.f_19853_.m_45976_(LivingEntity.class, new AABB(playerIn.m_20185_() - maxRadius, playerIn.m_20186_() - maxRadius, playerIn.m_20189_() - maxRadius, playerIn.m_20185_() + maxRadius, playerIn.m_20186_() + maxRadius, playerIn.m_20189_() + maxRadius));
        int multiplier = 0;
        double damage = MTConfig.REPLICA_BASE_DAMAGE;
        for (LivingEntity e : lst) {
            if (!ContractMahoujinTileEntity.isImmuneToSpell(playerIn.f_19853_, playerIn.m_142081_(), (Entity)e)) continue;
            ++multiplier;
        }
        for (LivingEntity e : lst) {
            if (ContractMahoujinTileEntity.isImmuneToSpell(playerIn.f_19853_, playerIn.m_142081_(), (Entity)e)) continue;
            String type = Replica.getDamageTypeForSlot(stack, Replica.getSelectedSlot(stack));
            DamageSource source = DamageSource.f_19318_;
            source = Replica.getDamageSource(type, (LivingEntity)playerIn);
            e.m_6469_(source, (float)Math.min((double)multiplier * damage, MTConfig.REPLICA_MAX_DAMAGE));
            Vec3 v = e.m_20182_().m_82546_(playerIn.m_20182_());
            this.boop((Entity)e, 3.0f, -v.f_82479_, -v.f_82480_, -v.f_82481_);
        }
    }

    public static void coverMove(Player player) {
        double totalRange = MTConfig.REPLICA_COVER_MOVE_RANGE;
        Vec3 myloc = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
        List lst = player.f_19853_.m_45976_(LivingEntity.class, new AABB(player.m_20185_() - totalRange, player.m_20186_() - totalRange, player.m_20189_() - totalRange, player.m_20185_() + totalRange, player.m_20186_() + totalRange, player.m_20189_() + totalRange));
        ArrayList<LivingEntity> inRange = new ArrayList<LivingEntity>();
        HashSet<LivingEntity> needsHelp = new HashSet<LivingEntity>();
        HashSet<LivingEntity> players = new HashSet<LivingEntity>();
        for (LivingEntity tmp : lst) {
            if (!EffectUtil.inRange(tmp, (LivingEntity)player, myloc, (int)totalRange, false) || !ContractMahoujinTileEntity.isImmuneToSpell(player.f_19853_, player.m_142081_(), (Entity)tmp) || player == tmp) continue;
            inRange.add(tmp);
            if (tmp instanceof Player) {
                players.add(tmp);
            }
            if (!Replica.needsHelp(tmp)) continue;
            needsHelp.add(tmp);
        }
        Collections.sort(inRange, Replica.getDistanceSorter((LivingEntity)player));
        LivingEntity e = Replica.coverMoveTarget(inRange, needsHelp, players);
        if (e != null) {
            Vec3 facing = Replica.coverMoveFacing(e);
            if (facing == null) {
                MahouTsukaiTeleporter.teleport((Entity)player, EffectUtil.getDimension(player.f_19853_), e.m_20182_().m_82549_(new Vec3(1.0, 0.0, 0.0)));
                player.f_19864_ = true;
            } else {
                facing = facing.m_82541_();
                float pitch = (float)Math.asin(-facing.f_82480_);
                float yaw = (float)Math.atan2(facing.f_82479_, facing.f_82481_);
                player.f_19857_ = EffectUtil.toDegrees(-yaw);
                player.f_19858_ = EffectUtil.toDegrees(pitch);
                MahouTsukaiTeleporter.teleport((Entity)player, EffectUtil.getDimension(player.f_19853_), e.m_20182_().m_82549_(facing.m_82490_(0.2)));
                player.f_19864_ = true;
            }
        }
    }

    public static LivingEntity coverMoveTarget(ArrayList<LivingEntity> inRange, HashSet<LivingEntity> needsHelp, HashSet<LivingEntity> players) {
        for (LivingEntity living : inRange) {
            if (!needsHelp.contains(living) || !players.contains(living)) continue;
            return living;
        }
        for (LivingEntity living : inRange) {
            if (!needsHelp.contains(living)) continue;
            return living;
        }
        for (LivingEntity living : inRange) {
            if (!players.contains(living)) continue;
            return living;
        }
        Iterator<LivingEntity> iterator = inRange.iterator();
        if (iterator.hasNext()) {
            LivingEntity living;
            living = iterator.next();
            return living;
        }
        return null;
    }

    public static void saveTeleportLocation(ItemStack s, Player player) {
        Vec3 save = player.m_20182_();
        CompoundTag nbt = s.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128347_("mahou_teleport_x", save.f_82479_);
        nbt.m_128347_("mahou_teleport_y", save.f_82480_);
        nbt.m_128347_("mahou_teleport_z", save.f_82481_);
        nbt.m_128359_("mahou_teleport_dim", EffectUtil.getDimension(player.f_19853_).toString());
        s.m_41751_(nbt);
    }

    public static Vec3 getTeleportLocation(ItemStack s) {
        CompoundTag nbt = s.m_41783_();
        if (nbt != null && nbt.m_128441_("mahou_teleport_x") && nbt.m_128441_("mahou_teleport_y") && nbt.m_128441_("mahou_teleport_z")) {
            return new Vec3(nbt.m_128459_("mahou_teleport_x"), nbt.m_128459_("mahou_teleport_y"), nbt.m_128459_("mahou_teleport_z"));
        }
        return null;
    }

    public static ResourceLocation getTeleportDimension(ItemStack s) {
        CompoundTag nbt = s.m_41783_();
        if (nbt != null && nbt.m_128441_("mahou_teleport_dim")) {
            return new ResourceLocation(nbt.m_128461_("mahou_teleport_dim"));
        }
        return null;
    }

    public static boolean getFriendlyOnly(ItemStack s) {
        CompoundTag nbt = s.m_41783_();
        if (nbt != null && nbt.m_128441_("mahou_friendly")) {
            return nbt.m_128471_("mahou_friendly");
        }
        return false;
    }

    public static void setFriendlyOnly(ItemStack s, boolean b) {
        CompoundTag nbt = s.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128379_("mahou_friendly", b);
        s.m_41751_(nbt);
    }

    public static Vec3 coverMoveFacing(LivingEntity e) {
        return Replica.coverMoveFacing(e, null);
    }

    public static Vec3 coverMoveFacing(LivingEntity e, Entity ignore) {
        int inTroubleRange = 15;
        List lst = e.f_19853_.m_45976_(LivingEntity.class, new AABB(e.m_20185_() - (double)inTroubleRange, e.m_20186_() - (double)inTroubleRange, e.m_20189_() - (double)inTroubleRange, e.m_20185_() + (double)inTroubleRange, e.m_20186_() + (double)inTroubleRange, e.m_20189_() + (double)inTroubleRange));
        Collections.sort(lst, Replica.getDistanceSorter(e));
        lst.remove(e);
        if (ignore != null) {
            lst.remove(ignore);
        }
        Vec3 ret = null;
        for (LivingEntity attacker : lst) {
            if (ret == null) {
                ret = attacker.m_20182_().m_82546_(e.m_20182_());
            }
            if (attacker.m_142581_() != e && (!(attacker instanceof Mob) || ((Mob)attacker).m_5448_() != e) && (!(attacker instanceof Player) || ContractMahoujinTileEntity.isImmuneToSpell(e.f_19853_, e.m_142081_(), (Entity)attacker))) continue;
            ret = attacker.m_20182_().m_82546_(e.m_20182_());
            return ret;
        }
        return ret;
    }

    public static Comparator<LivingEntity> getDistanceSorter(final LivingEntity player) {
        Comparator<LivingEntity> compareDistance = new Comparator<LivingEntity>(){

            @Override
            public int compare(LivingEntity o1, LivingEntity o2) {
                double d = o1.m_20270_((Entity)player) - o2.m_20270_((Entity)player);
                if (d < 0.0) {
                    return -1;
                }
                if (d > 0.0) {
                    return 1;
                }
                return 0;
            }
        };
        return compareDistance;
    }

    public static boolean needsHelp(LivingEntity e) {
        int inTroubleRange = 15;
        List lst = e.f_19853_.m_45976_(LivingEntity.class, new AABB(e.m_20185_() - (double)inTroubleRange, e.m_20186_() - (double)inTroubleRange, e.m_20189_() - (double)inTroubleRange, e.m_20185_() + (double)inTroubleRange, e.m_20186_() + (double)inTroubleRange, e.m_20189_() + (double)inTroubleRange));
        for (LivingEntity attacker : lst) {
            if (attacker.m_142581_() != e && (!(attacker instanceof Mob) || ((Mob)attacker).m_5448_() != e)) continue;
            return true;
        }
        return false;
    }

    public static void replicaBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer().m_21205_().m_41720_() instanceof Replica) {
            ItemStack s;
            boolean friendly = Replica.getFriendlyOnly(s = event.getPlayer().m_21205_());
            Replica.setFriendlyOnly(s, !friendly);
            TranslatableComponent tt = friendly ? new TranslatableComponent("mahoutsukai.replica.friendlyoff") : new TranslatableComponent("mahoutsukai.replica.friendlyon");
            event.getPlayer().m_5661_((Component)tt, true);
        }
    }

    public static void printItems() {
        ImmutableList list = ImmutableList.copyOf((Iterable)Registry.f_122827_);
        Object s = "";
        for (Item i : list) {
            if (!i.getRegistryName().m_135827_().equals("mahoutsukai")) continue;
            s = (String)s + "\"" + i.getRegistryName().toString() + "\",";
        }
        System.out.println((String)s);
    }

    public static void printBlocks() {
        ImmutableList list = ImmutableList.copyOf((Iterable)Registry.f_122824_);
        Object s = "";
        for (Block i : list) {
            if (!i.getRegistryName().m_135827_().equals("mahoutsukai")) continue;
            s = (String)s + "\"" + i.getRegistryName().toString() + "\",";
        }
        System.out.println((String)s);
    }

    private void boop(Entity entity, float strength, double x, double y, double z) {
        entity.f_19812_ = true;
        float f = Mth.m_14116_((float)((float)(x * x + z * z + y * y)));
        Vec3 motion = entity.m_20184_();
        double motionX = motion.m_7096_();
        double motionY = motion.m_7098_();
        double motionZ = motion.m_7094_();
        motionX /= 2.0;
        motionZ /= 2.0;
        motionY /= 2.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.f_19864_ = true;
        if (entity.m_20096_()) {
            motionY /= 2.0;
            if ((motionY += (double)strength) > (double)0.4f) {
                motionY = 0.4f;
            }
        }
        entity.m_20334_(motionX, motionY, motionZ);
    }

    public static void setSelectedSlot(ItemStack s, int i) {
        CompoundTag nbt = s.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128405_("replica_selected_slot", i);
        s.m_41751_(nbt);
    }

    public static int getSelectedSlot(ItemStack s) {
        CompoundTag nbt = s.m_41783_();
        if (nbt != null && nbt.m_128441_("replica_selected_slot")) {
            return nbt.m_128451_("replica_selected_slot");
        }
        return 0;
    }

    public static String getDamageTypeForSlot(ItemStack s, int i) {
        CompoundTag nbt = s.m_41783_();
        String key = "mahou_replica_dt" + i;
        if (nbt != null && nbt.m_128441_(key)) {
            return nbt.m_128461_(key);
        }
        return "EMPTY";
    }

    public static void tryAddDamageType(ItemStack s, DamageSource source, LivingEntity e) {
        String type = source.m_19385_();
        if (!EffectUtil.inGenericBlacklist(type, MTConfig.REPLICA_BANNED_DAMAGE_TYPES) && (DAMAGE_SOURCE_REGISTRY.containsKey(type) || Replica.getDamageSource(type, e) != DamageSource.f_19318_)) {
            String slot;
            CompoundTag nbt = s.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            for (int i = 0; i < 6 && !(slot = Replica.getDamageTypeForSlot(s, i)).equals(type); ++i) {
                if (!slot.equals("EMPTY")) continue;
                String key = "mahou_replica_dt" + i;
                nbt.m_128359_(key, type);
                break;
            }
            s.m_41751_(nbt);
        }
    }

    public static void replicaLivingAttack(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        Replica.replicaDamageSource(event.getEntityLiving(), source);
    }

    public static boolean replicaLivingHurt(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        if (event.getEntityLiving() != null && event.getEntityLiving().m_21211_().m_41720_() instanceof Replica) {
            for (int i = 0; i < 6; ++i) {
                String s = Replica.getDamageTypeForSlot(event.getEntityLiving().m_21211_(), i);
                if (!s.equals(source.f_19326_)) continue;
                event.setAmount(0.0f);
                return true;
            }
        }
        return false;
    }

    public static void replicaDamageSource(LivingEntity entity, DamageSource source) {
        ServerPlayer e;
        IMahou mahou;
        if (!entity.f_19853_.f_46443_ && entity.m_21254_() && entity.m_21211_().m_41720_() instanceof Replica) {
            Replica.tryAddDamageType(entity.m_21211_(), source, entity);
            entity.m_21211_().m_41622_(1, entity, a -> {});
        }
        if (!MTConfig.REPLICA_DISABLED && entity.m_21254_() && entity.m_21211_().m_41720_() instanceof ShieldItem && entity instanceof ServerPlayer && (mahou = Utils.getPlayerMahou((Player)(e = (ServerPlayer)entity))) != null && (double)mahou.getDamageExchangeUses() > 0.9 * (double)MTConfig.DAMAGE_EXCHANGE_CAP && (double)mahou.getDeathCollectionUsesLeft() >= Math.min(100.0, MTConfig.DEATH_COLLECTION_MAX) && EffectUtil.hasBuff((LivingEntity)e, ModEffects.IMMUNITY_EXCHANGE) && e.m_21230_() > 15 && e.m_21205_().m_41720_() == Items.f_42740_ && StrengtheningSpellEffect.getStrengthened(e.m_21205_()) > 0) {
            e.m_150109_().m_8016_(e.m_150109_().f_35977_);
            ItemStack change = new ItemStack((ItemLike)ModItems.replica);
            if (MTConfig.REPLICA_IS_UNBREAKABLE) {
                CompoundTag nbt = change.m_41783_();
                if (nbt == null) {
                    nbt = new CompoundTag();
                }
                nbt.m_128379_("Unbreakable", true);
                change.m_41751_(nbt);
            }
            if (!e.m_150109_().m_36040_(e.m_150109_().f_35977_, change)) {
                e.m_36176_(change, false);
            }
            ModTriggers.REPLICA.trigger(e);
        }
    }

    public static void clearDamageTypes(ItemStack s) {
        CompoundTag nbt = s.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        for (int i = 0; i < 6; ++i) {
            String key = "mahou_replica_dt" + i;
            nbt.m_128359_(key, "EMPTY");
        }
        s.m_41751_(nbt);
    }

    public static void initVanillaDamageTypes() {
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19305_.f_19326_, DamageSource.f_19305_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19306_.f_19326_, DamageSource.f_19306_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19307_.f_19326_, DamageSource.f_19307_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19308_.f_19326_, DamageSource.f_19308_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19309_.f_19326_, DamageSource.f_19309_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19310_.f_19326_, DamageSource.f_19310_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19311_.f_19326_, DamageSource.f_19311_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19312_.f_19326_, DamageSource.f_19312_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19313_.f_19326_, DamageSource.f_19313_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19314_.f_19326_, DamageSource.f_19314_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19315_.f_19326_, DamageSource.f_19315_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19316_.f_19326_, DamageSource.f_19316_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19317_.f_19326_, DamageSource.f_19317_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19318_.f_19326_, DamageSource.f_19318_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19319_.f_19326_, DamageSource.f_19319_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19320_.f_19326_, DamageSource.f_19320_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19321_.f_19326_, DamageSource.f_19321_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19322_.f_19326_, DamageSource.f_19322_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19323_.f_19326_, DamageSource.f_19323_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19324_.f_19326_, DamageSource.f_19324_);
        DAMAGE_SOURCE_REGISTRY.put(DamageSource.f_19325_.f_19326_, DamageSource.f_19325_);
    }

    public static DamageSource getDamageSource(String key, LivingEntity e) {
        DamageSource ret = DamageSource.f_19318_;
        if (DAMAGE_SOURCE_REGISTRY.containsKey(key)) {
            ret = DAMAGE_SOURCE_REGISTRY.get(key);
        } else {
            DamageSource BEE_STING = DamageSource.m_19364_((LivingEntity)e);
            DamageSource MOB = DamageSource.m_19370_((LivingEntity)e);
            DamageSource INDIRECT = DamageSource.m_19340_((Entity)e, (LivingEntity)e);
            DamageSource ARROW = DamageSource.m_19346_((AbstractArrow)new Arrow(e.f_19853_, e), (Entity)e);
            DamageSource EXPLOSION = DamageSource.m_19373_((LivingEntity)e);
            DamageSource THORNS = DamageSource.m_19335_((Entity)e);
            DamageSource WITHER_SKULL = DamageSource.m_19355_((WitherSkull)new WitherSkull(e.f_19853_, e, e.m_20185_(), e.m_20186_(), e.m_20189_()), (Entity)e);
            DamageSource TRIDENT = DamageSource.m_19337_((Entity)e, (Entity)e);
            DamageSource FIREWORK = DamageSource.m_19352_((FireworkRocketEntity)new FireworkRocketEntity(e.f_19853_, new ItemStack((ItemLike)Items.f_42688_), e), (Entity)e);
            DamageSource THROWN = DamageSource.m_19361_((Entity)e, (Entity)e);
            HashMap<String, DamageSource> map = new HashMap<String, DamageSource>();
            map.put(BEE_STING.f_19326_, BEE_STING);
            map.put(MOB.f_19326_, MOB);
            map.put(INDIRECT.f_19326_, INDIRECT);
            map.put(ARROW.f_19326_, ARROW);
            map.put(EXPLOSION.f_19326_, EXPLOSION);
            map.put(THORNS.f_19326_, THORNS);
            map.put(WITHER_SKULL.f_19326_, WITHER_SKULL);
            map.put(TRIDENT.f_19326_, TRIDENT);
            map.put(FIREWORK.f_19326_, FIREWORK);
            map.put(THROWN.f_19326_, THROWN);
            if (map.containsKey(key)) {
                ret = (DamageSource)map.get(key);
            }
        }
        return ret;
    }

    public static void replicaExplosionProtection(ExplosionEvent.Detonate event) {
        List lst = event.getExplosion().m_46081_();
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        if (lst.size() > 0 || event.getAffectedEntities().size() > 0) {
            for (BlockPos p : lst) {
                if ((float)p.m_123341_() < minX) {
                    minX = p.m_123341_();
                }
                if ((float)p.m_123342_() < minY) {
                    minY = p.m_123342_();
                }
                if ((float)p.m_123343_() < minZ) {
                    minZ = p.m_123343_();
                }
                if ((float)p.m_123341_() > maxX) {
                    maxX = p.m_123341_();
                }
                if ((float)p.m_123342_() > maxY) {
                    maxY = p.m_123342_();
                }
                if (!((float)p.m_123343_() > maxZ)) continue;
                maxZ = p.m_123343_();
            }
            for (Entity e : event.getAffectedEntities()) {
                BlockPos p = e.m_142538_();
                if ((float)p.m_123341_() < minX) {
                    minX = p.m_123341_();
                }
                if ((float)p.m_123342_() < minY) {
                    minY = p.m_123342_();
                }
                if ((float)p.m_123343_() < minZ) {
                    minZ = p.m_123343_();
                }
                if ((float)p.m_123341_() > maxX) {
                    maxX = p.m_123341_();
                }
                if ((float)p.m_123342_() > maxY) {
                    maxY = p.m_123342_();
                }
                if (!((float)p.m_123343_() > maxZ)) continue;
                maxZ = p.m_123343_();
            }
            ChunkPos bottom = new ChunkPos(new BlockPos((double)(minX -= 14.0f), (double)(minY -= 14.0f), (double)(minZ -= 14.0f)));
            ChunkPos top = new ChunkPos(new BlockPos((double)(maxX += 14.0f), (double)(maxY += 14.0f), (double)(maxZ += 14.0f)));
            AABB aabb = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            List entities = event.getWorld().m_45976_(Player.class, aabb);
            if (entities.size() > 0) {
                Iterator iter = lst.iterator();
                while (iter.hasNext()) {
                    boolean remove = false;
                    BlockPos p = (BlockPos)iter.next();
                    for (Player entity : entities) {
                        Vec3 vec1;
                        if (!(entity.m_21211_().m_41720_() instanceof Replica) || !Replica.isPointInRadiusOfCircle(entity, vec1 = EffectUtil.fromBlockPos(p).m_82520_(0.5, 0.5, 0.5))) continue;
                        remove = true;
                        break;
                    }
                    if (!remove) continue;
                    iter.remove();
                }
                Iterator affected = event.getAffectedEntities().iterator();
                while (affected.hasNext()) {
                    boolean remove = false;
                    Entity a = (Entity)affected.next();
                    Vec3 p = a.m_20182_();
                    Vec3 p2 = a.m_20182_().m_82520_(0.0, (double)a.m_20206_(), 0.0);
                    for (Player entity : entities) {
                        if (!(entity.m_21211_().m_41720_() instanceof Replica) || !Replica.isPointInRadiusOfCircle(entity, p) && !Replica.isPointInRadiusOfCircle(entity, p2)) continue;
                        remove = true;
                        break;
                    }
                    if (!remove) continue;
                    affected.remove();
                }
            }
        }
    }

    public static boolean isPointInRadiusOfCircle(Player player, Vec3 pos) {
        Vec3 sphereMid = Replica.getSphereMid(player);
        double distance = pos.m_82554_(sphereMid);
        return distance < (double)Replica.getSphereMidRadius();
    }

    public static Vec3 getSphereMid(Player player) {
        Vec3 sphereMid = player.m_20182_().m_82546_(player.m_20154_().m_82541_().m_82490_((double)Replica.getSphereMidRadius() - 0.5));
        return sphereMid;
    }

    public static float getSphereMidRadius() {
        float sphereMidRadius = 3.8f;
        return sphereMidRadius;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.REPLICA_DURABILITY;
    }

    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(ReplicaRenderer::new);
    }
}

