/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.attunedgems;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.mahoutsukai.capability.gemmahou.GemMahou;
import stepsword.mahoutsukai.capability.gemmahou.GemMahouProvider;
import stepsword.mahoutsukai.capability.gemmahou.GemMahouStorage;
import stepsword.mahoutsukai.capability.gemmahou.IGemMahou;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.util.Utils;

public class AttunedGem
extends ItemBase {
    private int MAX_MANA;

    public AttunedGem(String gem, int maxMana) {
        super("attuned_" + gem, ModItems.MAHOUTSUKAI_CREATIVE_TAB, 1);
        this.MAX_MANA = maxMana;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new GemMahouProvider();
    }

    public boolean m_142522_(ItemStack itemStack) {
        return true;
    }

    public int m_142158_(ItemStack itemStack) {
        float zz = this.getDuraRatio(itemStack);
        return Math.round(zz * 13.0f);
    }

    public float getDuraRatio(ItemStack stack) {
        IGemMahou gemMahou = Utils.getGemMahou(stack);
        float q = gemMahou != null ? (float)gemMahou.getStoredMana() : (float)this.getMaxMana();
        float zz = q / (float)this.getMaxMana();
        return zz;
    }

    public int m_142159_(ItemStack itemStack) {
        float f = Math.max(0.0f, this.getDuraRatio(itemStack));
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int getMaxMana() {
        return this.MAX_MANA;
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag ret = super.getShareTag(stack);
        if (ret == null) {
            IGemMahou mahou = Utils.getGemMahou(stack);
            return (CompoundTag)GemMahouStorage.writeNBT(mahou);
        }
        return ret;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbtt) {
        if (nbtt != null) {
            IGemMahou gemMahou = Utils.getGemMahou(stack);
            GemMahou serverGemMahou = new GemMahou();
            GemMahouStorage.readNBT(serverGemMahou, (Tag)nbtt);
            if (gemMahou != null) {
                gemMahou.setStoredMana(serverGemMahou.getStoredMana());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IGemMahou gemMahou;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        Item item = stack.m_41720_();
        if (item instanceof AttunedGem && Utils.getGemMahou(stack) != null && (gemMahou = Utils.getGemMahou(stack)) != null) {
            String maxMana = "" + ((AttunedGem)item).getMaxMana();
            String storedMana = "" + gemMahou.getStoredMana();
            tooltip.add((Component)new TextComponent(storedMana + " / " + maxMana));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && stack.m_41720_() instanceof AttunedGem && !player.m_20163_()) {
            this.charge(stack, player);
            AttunedGem.triggerUpdate((ServerPlayer)player, stack);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void charge(ItemStack itemStack, Player player) {
        IMahou playerMahou = Utils.getPlayerMahou(player);
        IGemMahou gemMahou = Utils.getGemMahou(itemStack);
        if (gemMahou != null && playerMahou != null) {
            int storedMana = gemMahou.getStoredMana();
            double chargeRate = playerMahou.getChargeRate();
            int playerMaxMana = playerMahou.getMaxMana();
            int manaDifference = (int)Math.ceil((double)playerMaxMana * chargeRate);
            if (storedMana < this.getMaxMana()) {
                manaDifference = Math.min(manaDifference, this.getMaxMana() - storedMana);
                manaDifference = PlayerManaManager.drainMana(player, manaDifference, true, false);
                gemMahou.setStoredMana(storedMana + manaDifference);
            }
            if ((storedMana = gemMahou.getStoredMana()) >= this.getMaxMana()) {
                gemMahou.setStoredMana(this.getMaxMana());
            }
            itemStack.m_41751_((CompoundTag)GemMahouStorage.writeNBT(gemMahou));
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        return stack;
    }

    public static void triggerUpdate(ServerPlayer player, ItemStack stack) {
        player.f_8906_.m_141995_((Packet)new ClientboundSetCarriedItemPacket(player.m_150109_().f_35977_));
    }
}

