/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;

public class ReplicaTeleportMahoujinEntity
extends Entity {
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_GOAL_X = "MAHOUTSUKAI_GOAL_X";
    private static final String TAG_GOAL_Y = "MAHOUTSUKAI_GOAL_Y";
    private static final String TAG_GOAL_Z = "MAHOUTSUKAI_GOAL_Z";
    private static final String TAG_GOAL_DIM = "MAHOUTSUKAI_GOAL_DIM";
    private static final String TAG_FRIENDLY_ONLY = "MAHOUTSUKAI_FRIENDLY_ONLY";
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.m_135353_(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.m_135353_(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> GOAL_X = SynchedEntityData.m_135353_(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> GOAL_Y = SynchedEntityData.m_135353_(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> GOAL_Z = SynchedEntityData.m_135353_(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> GOAL_DIM = SynchedEntityData.m_135353_(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> FRIENDLY_ONLY = SynchedEntityData.m_135353_(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int casterUUID = 0;
    public boolean doTeleport = true;
    public static final String entityName = "replica_teleport_mahoujin_entity";

    public ReplicaTeleportMahoujinEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super(ModEntities.REPLICA_TELEPORT, worldIn);
        this.f_19811_ = true;
    }

    public ReplicaTeleportMahoujinEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public ReplicaTeleportMahoujinEntity(Level world) {
        super(ModEntities.REPLICA_TELEPORT, world);
        this.f_19811_ = true;
    }

    public ReplicaTeleportMahoujinEntity(Level world, LivingEntity caster, float r, float g, float b, float a, ResourceLocation dim, Vec3 goal, boolean friendly) {
        this(world);
        this.casterUUID = caster.m_142049_();
        this.setColor(r, g, b, a);
        this.setGoal(goal);
        this.setGoalDim(dim);
        this.setFriendlyOnly(friendly);
        this.sizer(0.0f);
    }

    public ReplicaTeleportMahoujinEntity(Level world, LivingEntity caster, float r, float g, float b, float a, ResourceLocation dim, Vec3 goal, boolean friendly, boolean doTeleport) {
        this(world, caster, r, g, b, a, dim, goal, friendly);
        this.doTeleport = doTeleport;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(GOAL_X, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(GOAL_Y, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(GOAL_Z, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_A, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(GOAL_DIM, (Object)"minecraft:overworld");
        this.f_19804_.m_135372_(FRIENDLY_ONLY, (Object)true);
    }

    public void m_8119_() {
        super.m_8119_();
        int teleportStart = MTConfig.REPLICA_TELEPORT_START_TELEPORTING;
        int teleportEnd = MTConfig.REPLICA_TELEPORT_STOP_TELEPORTING;
        int dieTime = MTConfig.REPLICA_TELEPORT_LIFE;
        float maxRadius = (float)MTConfig.REPLICA_TELEPORT_FRIEND_RANGE;
        this.m_20334_(0.0, 0.0, 0.0);
        if (!this.f_19853_.f_46443_) {
            this.setLife(this.getLife() + 1);
            Entity caster = this.f_19853_.m_6815_(this.casterUUID);
            if (caster == null || !caster.m_6084_()) {
                this.m_146870_();
            }
            if (this.getLife() < teleportStart && this.getCircleSize() < maxRadius) {
                this.setCircleSize(this.getCircleSize() + 2.0f * maxRadius / (float)teleportStart);
            }
            if (this.getLife() >= teleportStart && this.getLife() < teleportEnd && this.doTeleport) {
                AABB aabb = new AABB(this.m_20185_() - (double)maxRadius, this.m_20186_() - (double)maxRadius, this.m_20189_() - (double)maxRadius, this.m_20185_() + (double)maxRadius, this.m_20186_() + (double)maxRadius, this.m_20189_() + (double)maxRadius);
                List entities = this.f_19853_.m_45976_(Entity.class, aabb);
                Vec3 goal = this.getGoal();
                ResourceLocation res = this.getGoalDim();
                boolean teleportAll = this.getFriendlyOnly();
                for (Entity e : entities) {
                    if (!(e instanceof ItemEntity) && (!(e instanceof LivingEntity) || !teleportAll && !ContractMahoujinTileEntity.isImmuneToSpell(this.f_19853_, caster.m_142081_(), e)) || !(e.m_20182_().m_82557_(this.m_20182_()) < (double)(maxRadius * maxRadius))) continue;
                    MahouTsukaiTeleporter.teleport(e, goal.f_82479_, goal.f_82480_, goal.f_82481_, res);
                }
            }
            if (this.getLife() > teleportEnd && this.getLife() < dieTime) {
                this.setCircleSize(Math.max(0.0f, this.getCircleSize() - 2.0f * maxRadius / (float)(dieTime - teleportEnd)));
            }
            if (this.getLife() >= dieTime) {
                this.m_146870_();
            }
        } else {
            MahouTsukaiMod.proxy.spawnReplicaTeleportParticles(this);
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public void setColor(float r, float g, float b, float a) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        this.f_19804_.m_135381_(COLOR_A, (Object)Float.valueOf(a));
    }

    public void setGoal(Vec3 vec) {
        this.f_19804_.m_135381_(GOAL_X, (Object)Float.valueOf((float)vec.f_82479_));
        this.f_19804_.m_135381_(GOAL_Y, (Object)Float.valueOf((float)vec.f_82480_));
        this.f_19804_.m_135381_(GOAL_Z, (Object)Float.valueOf((float)vec.f_82481_));
    }

    public Vec3 getGoal() {
        return new Vec3((double)((Float)this.f_19804_.m_135370_(GOAL_X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(GOAL_Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(GOAL_Z)).floatValue());
    }

    public void setFriendlyOnly(boolean b) {
        this.f_19804_.m_135381_(FRIENDLY_ONLY, (Object)b);
    }

    public boolean getFriendlyOnly() {
        return (Boolean)this.f_19804_.m_135370_(FRIENDLY_ONLY);
    }

    protected void m_20101_() {
    }

    @Nullable
    public AABB m_142469_() {
        return ZERO_AABB;
    }

    public float[] getColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_A)).floatValue()};
    }

    public void sizer(float s) {
        this.setCircleSize(s);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setCircleSize(compound.m_128457_(TAG_CIRCLE_SIZE));
        this.setLife(compound.m_128451_(TAG_LIFE));
        this.setColor(compound.m_128457_(TAG_COLOR_R), compound.m_128457_(TAG_COLOR_G), compound.m_128457_(TAG_COLOR_B), compound.m_128457_(TAG_COLOR_A));
        this.setGoal(new Vec3((double)compound.m_128457_(TAG_GOAL_X), (double)compound.m_128457_(TAG_GOAL_Y), (double)compound.m_128457_(TAG_GOAL_Z)));
        this.setGoalDim(new ResourceLocation(compound.m_128461_(TAG_GOAL_DIM)));
        this.setFriendlyOnly(compound.m_128471_(TAG_FRIENDLY_ONLY));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.m_128405_(TAG_LIFE, this.getLife());
        float[] colors = this.getColor();
        compound.m_128350_(TAG_COLOR_R, colors[0]);
        compound.m_128350_(TAG_COLOR_G, colors[1]);
        compound.m_128350_(TAG_COLOR_B, colors[2]);
        compound.m_128350_(TAG_COLOR_A, colors[3]);
        Vec3 goal = this.getGoal();
        compound.m_128350_(TAG_GOAL_X, (float)goal.f_82479_);
        compound.m_128350_(TAG_GOAL_Y, (float)goal.f_82480_);
        compound.m_128350_(TAG_GOAL_Z, (float)goal.f_82481_);
        compound.m_128359_(TAG_GOAL_DIM, this.getGoalDim().toString());
        compound.m_128379_(TAG_FRIENDLY_ONLY, this.getFriendlyOnly());
    }

    public AABB m_6921_() {
        return bb;
    }

    public ResourceLocation getGoalDim() {
        return new ResourceLocation((String)this.f_19804_.m_135370_(GOAL_DIM));
    }

    public void setGoalDim(ResourceLocation dim) {
        this.f_19804_.m_135381_(GOAL_DIM, (Object)dim.toString());
    }

    public float getCircleSize() {
        return ((Float)this.f_19804_.m_135370_(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.f_19804_.m_135381_(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(int l) {
        this.f_19804_.m_135381_(LIFE, (Object)l);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

