/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.fae;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.Leylines;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.fae.FaeAIFollow;
import stepsword.mahoutsukai.entity.fae.FaeAIWander;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.networking.FaeNoisePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.sounds.ModSounds;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class FaeEntity
extends Animal
implements FlyingAnimal {
    public static final String entityName = "fae";
    public static final String chime = "";
    public static ResourceLocation loot = new ResourceLocation("mahoutsukai", "fae");
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(FaeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(FaeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(FaeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";

    public FaeEntity(Level worldIn) {
        super(ModEntities.FAE, worldIn);
        this.f_19811_ = true;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
        this.randomColor();
    }

    public FaeEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super(ModEntities.FAE, worldIn);
        this.f_19811_ = true;
    }

    public FaeEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
        this.f_19811_ = true;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
        this.randomColor();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return new FaeEntity((Level)world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FaeAIFollow((PathfinderMob)this, 1.0, 8.0f, 7.0f, 2.0f));
        this.f_21345_.m_25352_(2, (Goal)new FaeAIWander((PathfinderMob)this, 1.0, 1));
        this.f_21345_.m_25352_(0, (Goal)new BreedGoal((Animal)this, 1.0));
    }

    public void m_8107_() {
        float[] colors;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        super.m_8107_();
        AABB bb = this.m_142469_();
        if (!this.f_19853_.f_46443_ && (colors = this.getColor())[0] == colors[1] && colors[1] == colors[2]) {
            this.randomColor();
        }
        x = this.m_20185_();
        y = this.m_20186_();
        z = this.m_20189_();
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation pathnavigateflying = new FlyingPathNavigation((Mob)this, worldIn){};
        pathnavigateflying.m_26440_(false);
        pathnavigateflying.m_26443_(true);
        return pathnavigateflying;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public AABB m_6921_() {
        return bb;
    }

    protected void m_6138_() {
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6898_(ItemStack stack) {
        Item[] tasty;
        for (Item item : tasty = new Item[]{ModItems.powderedEye, ModItems.powderedEmerald, ModItems.powderedIron, ModItems.powderedDiamond, ModItems.powderedEnder, ModItems.powderedQuartz, ModItems.powderedGold}) {
            if (item != stack.m_41720_()) continue;
            return true;
        }
        return false;
    }

    public void m_7023_(Vec3 v) {
        float strafe = (float)v.f_82479_;
        float vertical = (float)v.f_82480_;
        float forward = (float)v.f_82481_;
        Vec3 motion = this.m_20184_();
        double motionX = motion.f_82479_;
        double motionY = motion.f_82480_;
        double motionZ = motion.f_82481_;
        float ff = 0.008f;
        if (!Utils.isBlockAir(this.f_19853_, this.m_142538_().m_7495_())) {
            motionY += (double)ff;
        }
        this.m_20334_(motionX, motionY, motionZ);
        if (this.m_20069_()) {
            this.m_19920_(0.02f, v);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, v);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            float f = 0.91f;
            float f1 = 0.16277136f / (f * f * f);
            this.m_19920_(this.m_20096_() ? 0.1f * f1 : 0.02f, v);
            f = 0.91f;
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)f));
        }
        this.f_20923_ = this.f_20924_;
        double d1 = this.m_20185_() - this.f_19854_;
        double d0 = this.m_20189_() - this.f_19856_;
        float f2 = Mth.m_14116_((float)((float)(d1 * d1 + d0 * d0))) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.f_20924_ += (f2 - this.f_20924_) * 0.4f;
        this.f_20925_ += this.f_20924_;
    }

    public void randomColor() {
        float b;
        float g;
        float r;
        int choice = this.m_21187_().nextInt(11);
        if (choice == 0) {
            r = 140.0f;
            g = 0.0f;
            b = 255.0f;
        } else if (choice == 1) {
            r = 51.0f;
            g = 241.0f;
            b = 255.0f;
        } else if (choice == 2) {
            r = 255.0f;
            g = 94.0f;
            b = 0.0f;
        } else if (choice == 3) {
            r = 0.0f;
            g = 222.0f;
            b = 18.0f;
        } else if (choice == 4) {
            r = 255.0f;
            g = 0.0f;
            b = 0.0f;
        } else if (choice == 5) {
            r = 255.0f;
            g = 209.0f;
            b = 41.0f;
        } else if (choice == 6) {
            r = 26.0f;
            g = 5.0f;
            b = 255.0f;
        } else if (choice == 7) {
            r = 68.0f;
            g = 5.0f;
            b = 255.0f;
        } else if (choice == 8) {
            r = 255.0f;
            g = 150.0f;
            b = 201.0f;
        } else if (choice == 9) {
            r = 172.0f;
            g = 255.0f;
            b = 28.0f;
        } else {
            r = 255.0f;
            g = 28.0f;
            b = 77.0f;
        }
        this.setColor(r, g, b);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
    }

    public void setColor(float r, float g, float b) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        this.m_20225_(false);
    }

    public float[] getColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue()};
    }

    public float m_6134_() {
        return 1.0f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        boolean faesound;
        boolean bl = faesound = MTConfig.FAE_NOISE && MahouTsukaiMod.proxy.isMahouTsukai();
        if (faesound) {
            int z = this.m_21187_().nextInt(4);
            SoundEvent[] arr = new SoundEvent[]{ModSounds.FAE_CHIME_1, ModSounds.FAE_CHIME_2, ModSounds.FAE_CHIME_3, ModSounds.FAE_CHIME_4};
            return arr[z];
        }
        return null;
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    public void m_5496_(SoundEvent soundIn, float volume, float pitch) {
        if (!this.m_20067_()) {
            if (!this.f_19853_.f_46443_) {
                this.playSound(this.m_20185_(), this.m_20186_(), this.m_20189_(), soundIn, this.m_5720_(), volume, pitch);
            } else if (MahouTsukaiMod.proxy.isMahouTsukai()) {
                // empty if block
            }
        }
    }

    public void playSound(double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity(null, (SoundEvent)soundIn, (SoundSource)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = event.getSound();
        category = event.getCategory();
        volume = event.getVolume();
        this.sendToAllNear(this.f_19853_.m_142572_().m_6846_(), x, y, z, volume > 1.0f ? (double)(16.0f * volume) : 16.0, EffectUtil.getDimension(this.f_19853_), new FaeNoisePacket((int)x, (int)y, (int)z, soundIn, category, volume, pitch));
    }

    public void sendToAllNear(PlayerList list, double x, double y, double z, double radius, ResourceLocation dimension, FaeNoisePacket packetIn) {
        if (list != null) {
            for (int i = 0; i < list.m_11314_().size(); ++i) {
                double d2;
                double d1;
                double d0;
                ServerPlayer serverPlayer = (ServerPlayer)list.m_11314_().get(i);
                IMahou mahou = Utils.getPlayerMahou((Player)serverPlayer);
                if (mahou == null || !mahou.hasMagic() || !EffectUtil.compareDimensions(EffectUtil.getDimension(serverPlayer.f_19853_), dimension) || !((d0 = x - serverPlayer.m_20185_()) * d0 + (d1 = y - serverPlayer.m_20186_()) * d1 + (d2 = z - serverPlayer.m_20189_()) * d2 < radius * radius)) continue;
                PacketHandler.sendTo(serverPlayer, packetIn);
            }
        }
    }

    @Nullable
    protected ResourceLocation m_7582_() {
        return loot;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22280_, (double)0.8f).m_22268_(Attributes.f_22279_, (double)0.4f);
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType reason) {
        if (reason == MobSpawnType.BREEDING || reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.MOB_SUMMONED) {
            return true;
        }
        Leylines.LeyLineShape keepshape = Leylines.LeyLineShape.NONE;
        ChunkPos cp = new ChunkPos(this.m_142538_());
        for (int i = cp.m_45604_(); i <= cp.m_45608_(); ++i) {
            for (int j = cp.m_45605_(); j <= cp.m_45609_(); ++j) {
                Leylines.LeyLineShape shape = Leylines.leyOrientation(new BlockPos(i, 0, j));
                if (keepshape == Leylines.LeyLineShape.NONE) {
                    keepshape = shape;
                }
                if (keepshape == Leylines.LeyLineShape.NED || keepshape == Leylines.LeyLineShape.NWD || keepshape == Leylines.LeyLineShape.HORIZ || keepshape == Leylines.LeyLineShape.VERT && shape != Leylines.LeyLineShape.NONE) {
                    keepshape = shape;
                }
                if (keepshape != Leylines.LeyLineShape.CROSS || shape != Leylines.LeyLineShape.STAR) continue;
                keepshape = Leylines.LeyLineShape.STAR;
            }
        }
        float thresh = 1.0f;
        thresh = keepshape == Leylines.LeyLineShape.CROSS ? 0.2f : (keepshape == Leylines.LeyLineShape.STAR ? 0.0f : (keepshape == Leylines.LeyLineShape.NONE ? 0.7f : 0.4f));
        thresh = (float)((double)thresh * MTConfig.FAE_SPAWN_RATE);
        return Math.random() > (double)thresh && super.m_5545_(world, reason);
    }

    public static boolean getCanSpawnHere(EntityType<FaeEntity> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, Random random) {
        if (reason == MobSpawnType.BREEDING || reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.MOB_SUMMONED) {
            return true;
        }
        Leylines.LeyLineShape keepshape = Leylines.LeyLineShape.NONE;
        ChunkPos cp = new ChunkPos(pos);
        for (int i = cp.m_45604_(); i <= cp.m_45608_(); ++i) {
            for (int j = cp.m_45605_(); j <= cp.m_45609_(); ++j) {
                Leylines.LeyLineShape shape = Leylines.leyOrientation(new BlockPos(i, 0, j));
                if (keepshape == Leylines.LeyLineShape.NONE) {
                    keepshape = shape;
                }
                if (keepshape == Leylines.LeyLineShape.NED || keepshape == Leylines.LeyLineShape.NWD || keepshape == Leylines.LeyLineShape.HORIZ || keepshape == Leylines.LeyLineShape.VERT && shape != Leylines.LeyLineShape.NONE) {
                    keepshape = shape;
                }
                if (keepshape != Leylines.LeyLineShape.CROSS || shape != Leylines.LeyLineShape.STAR) continue;
                keepshape = Leylines.LeyLineShape.STAR;
            }
        }
        float thresh = 1.0f;
        thresh = keepshape == Leylines.LeyLineShape.CROSS ? 0.2f : (keepshape == Leylines.LeyLineShape.STAR ? 0.0f : (keepshape == Leylines.LeyLineShape.NONE ? 0.7f : 0.4f));
        thresh = (float)((double)thresh * MTConfig.FAE_SPAWN_RATE);
        return random.nextDouble() > (double)thresh;
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source == DamageSource.f_19315_ || source == DamageSource.f_19310_ || source == DamageSource.f_19322_ || source == DamageSource.f_19316_;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        float[] colors = this.getColor();
        compound.m_128350_(TAG_COLOR_R, colors[0]);
        compound.m_128350_(TAG_COLOR_G, colors[1]);
        compound.m_128350_(TAG_COLOR_B, colors[2]);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setColor(compound.m_128457_(TAG_COLOR_R), compound.m_128457_(TAG_COLOR_G), compound.m_128457_(TAG_COLOR_B));
    }

    protected void usePlayerItem(Player player, ItemStack stack) {
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_142592_() {
        return !this.m_20096_();
    }

    public boolean m_20145_() {
        return true;
    }

    public boolean m_20177_(Player player) {
        return !EffectUtil.hasBuff((LivingEntity)player, ModEffects.FAY_SIGHT_EYES);
    }
}

