/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkHooks;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.sounds.ModSounds;
import stepsword.mahoutsukai.util.EffectUtil;

public class SmiteEntity
extends Entity {
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final String TAG_BEAM_LENGTH = "MAHOUTSUKAI_BEAM_LENGTH";
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> BEAM_SIZE = SynchedEntityData.m_135353_(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.m_135353_(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.m_135353_(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> BEAM_LENGTH = SynchedEntityData.m_135353_(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public Entity target;
    public float damage;
    public float prev_beam_len;
    public float prev_beam_size;
    public float maxlen = 250.0f;
    public int m;
    public static final String entityName = "smite_entity";

    public SmiteEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public SmiteEntity(Level world) {
        super(ModEntities.SMITE, world);
        this.f_19811_ = true;
    }

    public SmiteEntity(Level world, LivingEntity target, float r, float g, float b, float a, float size, float damage) {
        this(world);
        this.setColor(r, g, b, a);
        this.sizer(size);
        this.target = target;
        this.damage = damage;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_A, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DISTANCE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BEAM_LENGTH, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (!this.f_19853_.f_46443_) {
            if (this.target == null) {
                this.m_146870_();
                return;
            }
            this.m_6034_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            if ((double)this.getBeamSize() < (double)this.target.m_20205_() * 1.5) {
                this.setBeamSize(this.getBeamSize() + 0.1f);
            } else if (this.getBeamLength() < this.maxlen) {
                this.setBeamLength(this.getBeamLength() + 10.0f);
                if (this.getBeamLength() == this.maxlen - 10.0f) {
                    this.f_19853_.m_5594_(null, new BlockPos(this.m_20182_()), ModSounds.SMITE, SoundSource.NEUTRAL, (float)MTConfig.SMITE_VOLUME, 1.0f);
                }
            } else {
                ++this.m;
                if (this.m > 5) {
                    EffectUtil.magicAttack((LivingEntity)this.target, this.damage, null);
                    this.m_146870_();
                }
            }
        } else {
            float[] rgb = this.getColor();
            for (double i = (double)this.prev_beam_len; i < (double)this.getBeamLength(); i += 1.0) {
                MahouTsukaiMod.proxy.smiteParticles(this.m_20185_(), this.m_20186_() + (double)this.maxlen - i, this.m_20189_(), this.f_19796_, false, this.getBeamSize(), rgb[0], rgb[1], rgb[2]);
            }
            if (this.getBeamLength() == this.maxlen - 10.0f) {
                MahouTsukaiMod.proxy.smiteParticles(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), this.f_19796_, true, this.getBeamSize(), rgb[0], rgb[1], rgb[2]);
            }
        }
        this.prev_beam_len = this.getBeamLength();
        this.prev_beam_size = this.getBeamSize();
    }

    public boolean m_6087_() {
        return false;
    }

    public void m_6123_(Player entityIn) {
    }

    public void setColor(float r, float g, float b, float a) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        this.f_19804_.m_135381_(COLOR_A, (Object)Float.valueOf(a));
    }

    protected void m_20101_() {
    }

    @Nullable
    public AABB m_142469_() {
        return ZERO_AABB;
    }

    public float[] getColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_A)).floatValue()};
    }

    public void sizer(float s) {
        this.setBeamSize(s);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setBeamSize(compound.m_128457_(TAG_BEAM_SIZE));
        this.setBeamLength(compound.m_128457_(TAG_BEAM_LENGTH));
        this.setColor(compound.m_128457_(TAG_COLOR_R), compound.m_128457_(TAG_COLOR_G), compound.m_128457_(TAG_COLOR_B), compound.m_128457_(TAG_COLOR_A));
        this.setDistance(compound.m_128457_(TAG_DISTANCE));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_(TAG_BEAM_SIZE, this.getBeamSize());
        compound.m_128350_(TAG_BEAM_LENGTH, this.getBeamLength());
        float[] colors = this.getColor();
        compound.m_128350_(TAG_COLOR_R, colors[0]);
        compound.m_128350_(TAG_COLOR_G, colors[1]);
        compound.m_128350_(TAG_COLOR_B, colors[2]);
        compound.m_128350_(TAG_COLOR_A, colors[3]);
        compound.m_128350_(TAG_DISTANCE, this.getDistance());
    }

    public AABB m_6921_() {
        return bb;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getBeamSize() {
        return ((Float)this.f_19804_.m_135370_(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float s) {
        this.f_19804_.m_135381_(BEAM_SIZE, (Object)Float.valueOf(s));
    }

    public float getBeamLength() {
        return ((Float)this.f_19804_.m_135370_(BEAM_LENGTH)).floatValue();
    }

    public void setBeamLength(float s) {
        this.f_19804_.m_135381_(BEAM_LENGTH, (Object)Float.valueOf(s));
    }

    public float getDistance() {
        return ((Float)this.f_19804_.m_135370_(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.f_19804_.m_135381_(DISTANCE, (Object)Float.valueOf(d));
    }
}

