/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.familiar.SummonFamiliarSpellEffect;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.networking.GardenPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.particle.ModParticles;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class FamiliarEntity
extends ShoulderRidingEntity
implements FlyingAnimal {
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    public static final int exploreRadius = 5;
    SitWhenOrderedToGoal sitGoal;
    private UUID familiarId = null;
    public int r;
    public int g;
    public int b;
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_GARDEN_TICKS = "MAHOUTSUKAI_GARDEN_TICKS";
    private static final String TAG_HOLIDAY = "MAHOUTSUKAI_HOLIDAY";
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> HOLIDAY = SynchedEntityData.m_135353_(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GARDEN_TICKS = SynchedEntityData.m_135353_(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private String searchBlock = null;
    public static final String entityName = "familiar_entity";
    TicketType<ChunkPos> ticket = null;
    BlockPos lastInteresting = null;

    public FamiliarEntity(Level worldIn) {
        super(ModEntities.FAMILIAR, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21530_();
    }

    public FamiliarEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super(ModEntities.FAMILIAR, worldIn);
    }

    public FamiliarEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    protected void m_8099_() {
        this.sitGoal = new SitWhenOrderedToGoal((TamableAnimal)this);
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)this.sitGoal);
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (double)MTConfig.FAMILIAR_HEALTH).m_22268_(Attributes.f_22280_, (double)0.8f).m_22268_(Attributes.f_22279_, (double)0.4f);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.m_26440_(true);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.6f;
    }

    public void m_8107_() {
        super.m_8107_();
        this.calculateFlapping();
        if (!this.f_19853_.f_46443_) {
            this.updateMap();
            this.loadChunks();
            this.reportSurroundings();
            this.gardenUpdate();
        }
    }

    public void activateGarden() {
        int gardenTime = 1200;
        this.setGardenTicks(gardenTime);
        this.acknowledge();
    }

    public void acknowledge() {
        if (this.m_142480_() != null) {
            int z = this.m_21187_().nextInt(4) + 1;
            TranslatableComponent s = new TranslatableComponent("mahoutsukai.acknowledge" + z);
            if (this.m_142480_() instanceof Player) {
                ((Player)this.m_142480_()).m_5661_((Component)new TextComponent(ChatFormatting.AQUA + this.getMyName() + ": " + s.getString()), MTConfig.FAMILIAR_ACTION_BAR_MESSAGES);
            }
        }
    }

    public void gardenUpdate() {
        float blue;
        float green;
        float red;
        int gardenTime = MTConfig.FAMILIARS_GARDEN_TIME;
        int tick = this.getGardenTicks();
        int startup = 20;
        float colorRatio = 1.0f;
        float gr = 232.0f;
        float gg = 86.0f;
        float gb = 186.0f;
        float nr = 91.0f;
        float ng = 209.0f;
        float nb = 252.0f;
        if (this.getHoliday()) {
            float[] fs = this.holidayToColor();
            nr = fs[0];
            ng = fs[1];
            nb = fs[2];
        }
        if (tick > 0) {
            if (tick < startup) {
                colorRatio = (float)tick / (float)startup;
            }
            if (tick > gardenTime - startup) {
                colorRatio = (float)(gardenTime - tick) / (float)startup;
            }
            red = (gr - nr) * colorRatio + nr;
            green = (gg - ng) * colorRatio + ng;
            blue = (gb - nb) * colorRatio + nb;
            if (tick % 100 == 0) {
                this.gardenEffectA();
            }
            this.setGardenTicks(tick - 1);
        } else {
            red = nr;
            green = ng;
            blue = nb;
        }
        if (tick < 0) {
            this.setGardenTicks(0);
        }
        this.setColor(red / 255.0f, green / 255.0f, blue / 255.0f);
    }

    public void gardenEffectA() {
        int range = MTConfig.FAMILIARS_GARDEN_RANGE;
        List nearby = this.f_19853_.m_45976_(LivingEntity.class, new AABB(this.m_20185_() - (double)range, this.m_20186_() - (double)range, this.m_20189_() - (double)range, this.m_20185_() + (double)range, this.m_20186_() + (double)range, this.m_20189_() + (double)range));
        for (Player Player2 : this.f_19853_.m_6907_()) {
            if (!(Player2.m_20238_(this.m_20182_()) < 16384.0)) continue;
            PacketHandler.sendTo((ServerPlayer)Player2, new GardenPacket(this.m_20185_(), this.m_20186_(), this.m_20189_()));
        }
        for (LivingEntity entity : nearby) {
            EffectUtil.buff(entity, ModEffects.PEACEFUL_GARDEN, false, 120);
        }
    }

    public static void gardenEffectB(BlockPos pos, Level world) {
        int range = MTConfig.FAMILIARS_GARDEN_RANGE;
        Stream lst = BlockPos.m_121990_((BlockPos)pos.m_142082_(range, range / 2, range), (BlockPos)pos.m_142082_(-range, -range / 2, -range));
        lst.forEach(p -> {
            if (Utils.isBlockAir(world, pos)) {
                float x = p.m_123341_();
                float y = p.m_123342_();
                float z = p.m_123343_();
                Random random = world.f_46441_;
                double d = pos.m_123331_((Vec3i)p);
                double rat = d / ((double)range * (double)range);
                if (rat > 1.0) {
                    rat = 1.0;
                }
                float lessenPetals = 0.4f;
                if (random != null) {
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.m_7106_((ParticleOptions)ModParticles.PETAL, (double)x + 0.2, (double)y + 0.2, (double)z + 0.2, 0.0, 0.0, 0.0);
                    }
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.m_7106_((ParticleOptions)ModParticles.PETAL, (double)x + 0.8, (double)y + 0.2, (double)z + 0.8, 0.0, 0.0, 0.0);
                    }
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.m_7106_((ParticleOptions)ModParticles.PETAL, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0);
                    }
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.m_7106_((ParticleOptions)ModParticles.PETAL, (double)x + 0.2, (double)y + 0.8, (double)z + 0.8, 0.0, 0.0, 0.0);
                    }
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.m_7106_((ParticleOptions)ModParticles.PETAL, (double)x + 0.8, (double)y + 0.8, (double)z + 0.2, 0.0, 0.0, 0.0);
                    }
                }
            }
        });
    }

    public int getGardenTicks() {
        return (Integer)this.f_19804_.m_135370_(GARDEN_TICKS);
    }

    public void setGardenTicks(int t) {
        this.f_19804_.m_135381_(GARDEN_TICKS, (Object)t);
    }

    public void toggleHoliday() {
        this.setHoliday(!this.getHoliday());
    }

    public void setHoliday(boolean h) {
        this.f_19804_.m_135381_(HOLIDAY, (Object)h);
    }

    public boolean getHoliday() {
        return (Boolean)this.f_19804_.m_135370_(HOLIDAY);
    }

    public void setSearchBlock(String s) {
        this.searchBlock = s;
    }

    public String getSearchBlock() {
        return this.searchBlock;
    }

    public float[] holidayToColor() {
        float[] ret = new float[3];
        if (this.whichHoliday() == 1) {
            ret[0] = 51.0f;
            ret[1] = 204.0f;
            ret[2] = 51.0f;
        } else if (this.whichHoliday() == 2) {
            ret[0] = 140.0f;
            ret[1] = 0.0f;
            ret[2] = 255.0f;
        } else if (this.whichHoliday() == 3) {
            ret[0] = 23.0f;
            ret[1] = 209.0f;
            ret[2] = 54.0f;
        } else if (this.whichHoliday() == 4) {
            ret[0] = 255.0f;
            ret[1] = 91.0f;
            ret[2] = 25.0f;
        } else {
            ret[0] = 91.0f;
            ret[1] = 209.0f;
            ret[2] = 252.0f;
        }
        return ret;
    }

    public int whichHoliday() {
        if (Calendar.getInstance().get(2) == 11) {
            return 1;
        }
        if (Calendar.getInstance().get(2) == 1) {
            return 2;
        }
        if (Calendar.getInstance().get(2) == 2) {
            return 3;
        }
        if (Calendar.getInstance().get(2) == 9) {
            return 4;
        }
        return 0;
    }

    public void updateMap() {
        if (this.m_142480_() != null) {
            if (SummonFamiliarSpellEffect.familiarMap.containsKey(this.m_142504_())) {
                FamiliarEntity e = SummonFamiliarSpellEffect.familiarMap.get(this.m_142504_());
                if (e != null && e.getFamiliarId() != null && e.getFamiliarId().equals(this.getFamiliarId())) {
                    if (!e.m_6084_()) {
                        SummonFamiliarSpellEffect.familiarMap.put(this.m_142504_(), this);
                    } else if (e != this) {
                        this.m_146870_();
                    }
                } else {
                    this.m_146870_();
                }
            } else {
                this.m_146870_();
            }
        }
    }

    public void reportSurroundings() {
        Player owner;
        if (ServerHandler.tickCounter % (long)MTConfig.FAMILIAR_REPORT_SURROUNDINGS_TIME == 0L && !this.f_19853_.f_46443_ && (owner = (Player)this.m_142480_()) != null) {
            List players;
            AABB aabb = new AABB(this.m_142538_().m_142082_(-5, -5, -5), this.m_142538_().m_142082_(5, 5, 5));
            TranslatableComponent toSend = null;
            Random rand = owner.m_21187_();
            if (rand.nextBoolean() && !(players = this.f_19853_.m_45976_(Player.class, aabb)).isEmpty()) {
                toSend = this.reportPlayer((Player)players.get(rand.nextInt(players.size())), owner);
            }
            if (toSend == null) {
                List things;
                if (rand.nextBoolean() && !(things = this.f_19853_.m_45976_(LivingEntity.class, aabb)).isEmpty()) {
                    toSend = this.reportEntity((LivingEntity)things.get(rand.nextInt(things.size())), owner);
                }
                if (toSend == null) {
                    ArrayList blocks = new ArrayList();
                    Stream lst = BlockPos.m_121886_((int)((int)this.m_20185_() - 5), (int)((int)this.m_20186_() - 5), (int)((int)this.m_20189_() - 5), (int)((int)this.m_20185_() + 5), (int)((int)this.m_20186_() + 5), (int)((int)this.m_20189_() + 5));
                    lst.forEach(tmp -> {
                        BlockState bt = this.f_19853_.m_8055_(tmp);
                        if (this.getSearchBlock() == null) {
                            if (this.isInterestingBlock(bt.m_60734_())) {
                                blocks.add(new BlockPos(tmp.m_123341_(), tmp.m_123342_(), tmp.m_123343_()));
                            }
                        } else if (bt.m_60734_().getRegistryName().toString().equals(this.getSearchBlock())) {
                            blocks.add(new BlockPos(tmp.m_123341_(), tmp.m_123342_(), tmp.m_123343_()));
                        }
                    });
                    if (!blocks.isEmpty()) {
                        IMahou mahou;
                        this.lastInteresting = (BlockPos)blocks.get(rand.nextInt(blocks.size()));
                        if (this.m_142480_() instanceof Player && (mahou = Utils.getPlayerMahou((Player)this.m_142480_())) != null) {
                            mahou.setFamiliarInterestingBlock(this.lastInteresting);
                            EffectUtil.buff(this.m_142480_(), ModEffects.INTERESTING_BLOCK, false, MTConfig.FAMILIAR_REPORT_SURROUNDINGS_TIME, false);
                            PlayerManaManager.updateClientMahou((ServerPlayer)this.m_142480_(), mahou);
                        }
                        toSend = this.reportBlock(this.f_19853_.m_8055_(this.lastInteresting).m_60734_(), owner);
                    }
                }
            }
            if (toSend != null && !toSend.getString().equals("")) {
                owner.m_5661_((Component)new TextComponent(ChatFormatting.AQUA + this.getMyName() + ": " + toSend.getString()), MTConfig.FAMILIAR_ACTION_BAR_MESSAGES);
            }
        }
    }

    public String getMyName() {
        if (this.m_8077_()) {
            return this.m_7770_().getString();
        }
        return "Familiar";
    }

    public boolean isInterestingBlock(Block b) {
        return b == Blocks.f_50089_ || b == Blocks.f_50264_ || b == Blocks.f_50059_ || b == Blocks.f_50078_ || b == Blocks.f_50080_ || b == Blocks.f_50377_ || b == Blocks.f_49995_ || b == Blocks.f_50258_;
    }

    public TranslatableComponent ouch(Player owner) {
        Random rand = owner.m_21187_();
        int textNum = 1 + rand.nextInt(7);
        TranslatableComponent tct = new TranslatableComponent("mahoutsukai.hurt" + textNum);
        return tct;
    }

    public TranslatableComponent getGreeting(Player owner) {
        TranslatableComponent tct = new TranslatableComponent("");
        Random rand = owner.m_21187_();
        int textNum = rand.nextInt(7);
        if (textNum > 0) {
            if (this.getHoliday() && this.whichHoliday() != 0) {
                tct.m_7220_((Component)new TranslatableComponent("mahoutsukai.holiday" + this.whichHoliday() + "greeting" + textNum));
            } else {
                tct.m_7220_((Component)new TranslatableComponent("mahoutsukai.greeting" + textNum));
            }
            tct.m_7220_((Component)new TextComponent(" "));
        }
        tct.m_7220_((Component)new TranslatableComponent("mahoutsukai.masta"));
        tct.m_7220_((Component)new TextComponent(", "));
        return tct;
    }

    public TranslatableComponent reportBlock(Block thing, Player owner) {
        TranslatableComponent tct = null;
        Random rand = owner.m_21187_();
        if (thing != null) {
            tct = this.getGreeting(owner);
            int textNum = 1 + rand.nextInt(3);
            tct.m_7220_((Component)new TranslatableComponent("mahoutsukai.found" + textNum));
            tct.m_7220_((Component)new TextComponent(" "));
            tct.m_7220_((Component)new TranslatableComponent(new TranslatableComponent(thing.m_7705_()).getString()));
            tct.m_7220_((Component)new TextComponent(" "));
            tct.m_7220_((Component)new TranslatableComponent("mahoutsukai.foundF" + textNum));
            tct.m_7220_((Component)new TextComponent(" "));
            textNum = 1 + rand.nextInt(4);
            tct.m_7220_((Component)new TranslatableComponent("mahoutsukai.followup" + textNum));
        }
        return tct;
    }

    public TranslatableComponent reportEntity(LivingEntity thing, Player owner) {
        TranslatableComponent tct = null;
        Random rand = owner.m_21187_();
        if (thing != null && !(thing instanceof Player) && thing != this) {
            tct = this.getGreeting(owner);
            int textNum = 1 + rand.nextInt(3);
            tct.m_7220_((Component)new TranslatableComponent("mahoutsukai.entityFound" + textNum));
            tct.m_7220_((Component)new TextComponent(" "));
            tct.m_7220_((Component)new TranslatableComponent(thing.m_7755_().getString()));
            tct.m_7220_((Component)new TextComponent(" "));
            tct.m_7220_((Component)new TranslatableComponent("mahoutsukai.entityFoundF" + textNum));
            tct.m_7220_((Component)new TextComponent(" "));
            textNum = 1 + rand.nextInt(7);
            tct.m_7220_((Component)new TranslatableComponent("mahoutsukai.entityFoundFollowUp" + textNum));
        }
        return tct;
    }

    public TranslatableComponent reportPlayer(Player player, Player owner) {
        TranslatableComponent tct = null;
        Random rand = owner.m_21187_();
        if (player != null && !ContractMahoujinTileEntity.isImmuneToSpell(this.f_19853_, this.m_142504_(), (Entity)player)) {
            tct = this.getGreeting(owner);
            BlockPos position = player.m_142538_();
            int textNum = 1 + rand.nextInt(3);
            tct.m_7220_((Component)new TranslatableComponent("mahoutsukai.playerFound" + textNum));
            tct.m_7220_((Component)new TextComponent(" "));
            tct.m_7220_((Component)new TranslatableComponent(player.m_7755_().getString()));
            tct.m_7220_((Component)new TranslatableComponent("mahoutsukai.playerFoundF" + textNum));
            tct.m_7220_((Component)new TextComponent(" "));
            tct.m_7220_((Component)new TextComponent("[" + position.m_123341_() + "," + position.m_123342_() + "," + position.m_123343_() + "]. "));
            textNum = 1 + rand.nextInt(7);
            tct.m_7220_((Component)new TranslatableComponent("mahoutsukai.entityFoundFollowUp" + textNum));
        }
        return tct;
    }

    public void loadChunks() {
        if (this.ticket == null && !this.f_19853_.f_46443_ && this.m_142480_() != null && MTConfig.FAMILIAR_CHUNKLOADS) {
            this.ticket = TicketType.m_9462_((String)(this.m_142480_().m_7755_() + "familiar"), Comparator.comparingLong(ChunkPos::m_45588_));
        } else if (this.ticket != null && !this.f_19853_.f_46443_ && this.m_142480_() != null && MTConfig.FAMILIAR_CHUNKLOADS) {
            ChunkPos pos = new ChunkPos(this.m_142538_());
            ((ServerLevel)this.f_19853_).m_7726_().m_8387_(this.ticket, pos, 1, (Object)pos);
        }
    }

    public ChunkPos add(int x, int z, ChunkPos pos) {
        return new ChunkPos(pos.f_45578_ + x, pos.f_45579_ + z);
    }

    public void m_146870_() {
        super.m_146870_();
        if (this.ticket != null) {
            ((ServerLevel)this.f_19853_).m_7726_().m_8438_(this.ticket, new ChunkPos(this.m_142538_()), 1, (Object)new ChunkPos(this.m_142538_()));
            this.ticket = null;
        }
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.m_20096_() ? -1 : 4) * 0.3);
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, motion.f_82480_ * 0.6, motion.f_82481_);
        }
        this.flap += this.flapping * 2.0f;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return false;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean groundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_7848_(Animal otherAnimal) {
        return false;
    }

    public boolean m_7327_(Entity entityIn) {
        return entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), 3.0f);
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_7324_(Entity entityIn) {
        if (!(entityIn instanceof Player)) {
            super.m_7324_(entityIn);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_20147_()) {
            return false;
        }
        if (this.m_142480_() != null && !this.f_19853_.f_46443_ && this.m_21187_().nextDouble() > MTConfig.FAMILIAR_OUCH_CHANCE && this.m_142480_() instanceof Player) {
            ((Player)this.m_142480_()).m_5661_((Component)new TextComponent(ChatFormatting.AQUA + this.getMyName() + ": " + this.ouch((Player)this.m_142480_()).getString()), true);
        }
        return super.m_6469_(source, amount);
    }

    public UUID getFamiliarId() {
        return this.familiarId;
    }

    public void setFamiliarId(UUID f) {
        this.familiarId = f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(GARDEN_TICKS, (Object)0);
        this.f_19804_.m_135372_(HOLIDAY, (Object)true);
    }

    public void setColor(float r, float g, float b) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
    }

    public float[] getColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue()};
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.familiarId != null) {
            compound.m_128362_("mahoutsukai_familiar_id", this.familiarId);
        }
        if (this.m_142504_() != null) {
            compound.m_128362_("mahoutsukai_familiar_owner_id", this.m_142504_());
        }
        float[] colors = this.getColor();
        compound.m_128350_(TAG_COLOR_R, colors[0]);
        compound.m_128350_(TAG_COLOR_G, colors[1]);
        compound.m_128350_(TAG_COLOR_B, colors[2]);
        compound.m_128405_(TAG_GARDEN_TICKS, this.getGardenTicks());
        compound.m_128379_(TAG_HOLIDAY, this.getHoliday());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("mahoutsukai_familiar_id")) {
            this.familiarId = compound.m_128342_("mahoutsukai_familiar_id");
        }
        if (compound.m_128403_("mahoutsukai_familiar_owner_id")) {
            this.m_21816_(compound.m_128342_("mahoutsukai_familiar_owner_id"));
        }
        this.setColor(compound.m_128457_(TAG_COLOR_R), compound.m_128457_(TAG_COLOR_G), compound.m_128457_(TAG_COLOR_B));
        this.setGardenTicks(compound.m_128451_(TAG_GARDEN_TICKS));
        this.setHoliday(compound.m_128471_(TAG_HOLIDAY));
    }

    public boolean m_142592_() {
        return !this.m_20096_();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageableEntity) {
        return null;
    }
}

