/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.worldsave.MahouSavedData;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.Utils;

public class RealityMarbleSpellEffect {
    public static final int distance = 3000;
    public static Random random = new Random(53L);
    public static int counter = 0;
    public static ResourceLocation marble = new ResourceLocation("mahoutsukai", "reality_marble");

    public static boolean inMarble(Level world) {
        return EffectUtil.getDimension(world).toString().equals(marble.toString());
    }

    public static LivingEntity getEnemy(Player player) {
        Entity e = Utils.selectEntityNearCursor(player, MTConfig.GLOBAL_LOOK_RANGE, player.f_19853_, a -> Utils.getPredicate(Utils.MAHOU_SELECTION.SCROLL_REALITY_MARBLE, a, player), Utils.nearAllowed(Utils.MAHOU_SELECTION.SCROLL_REALITY_MARBLE));
        if (e instanceof LivingEntity && !EffectUtil.inEntityBlacklist(e, MTConfig.MARBLE_MOB_BLACKLIST)) {
            return (LivingEntity)e;
        }
        return null;
    }

    public static BlockPos getRealityMarbleSpawn(Level world, UUID uuid) {
        MahouSavedData save = new MahouSavedData(world);
        BlockPos pos = save.getPlayerSpawn(uuid);
        if (pos == null) {
            pos = RealityMarbleSpellEffect.generateRealityMarbleSpawn(world, save, uuid);
        }
        return pos;
    }

    public static BlockPos generateRealityMarbleSpawn(Level world, MahouSavedData save, UUID uuid) {
        HashMap<UUID, BlockPos> spawns = save.getAllSpawns();
        int maxX = 0;
        int maxZ = 0;
        if (spawns != null) {
            BlockPos pos;
            for (UUID tmp : spawns.keySet()) {
                pos = spawns.get(tmp);
                if (pos.m_123341_() > maxX) {
                    maxX = pos.m_123341_();
                }
                if (pos.m_123343_() <= maxZ) continue;
                maxZ = pos.m_123343_();
            }
            if (Math.random() < 0.5) {
                maxX += 3000;
            } else {
                maxZ += 3000;
            }
            pos = new BlockPos(maxX, 120, maxZ);
            save.changePlayerSpawn(uuid, pos);
            return pos;
        }
        return null;
    }

    public static boolean goToMarble(Player user) {
        IMahou casterMahou = Utils.getPlayerMahou(user);
        if (casterMahou != null) {
            BlockPos pos;
            ResourceLocation userdimension = EffectUtil.getDimension(user.f_19853_);
            boolean inmarble = RealityMarbleSpellEffect.inMarble(user.f_19853_);
            if (userdimension == null || inmarble) {
                casterMahou.setPlayerOldDimension(EffectUtil.getOverworld().toString());
            } else {
                casterMahou.setPlayerOldDimension(userdimension.toString());
            }
            if (userdimension != null && !inmarble) {
                casterMahou.setPlayerSavedSpawn(user.m_142538_());
            }
            if (casterMahou.getPlayerMarbleSpawn() == null) {
                casterMahou.setPlayerMarbleSpawn(RealityMarbleSpellEffect.getRealityMarbleSpawn(user.f_19853_, user.m_142081_()));
            }
            if ((pos = casterMahou.getPlayerMarbleSpawn()) == null) {
                return false;
            }
            LivingEntity e = RealityMarbleSpellEffect.getEnemy(user);
            PlayerManaManager.updateClientMahou((ServerPlayer)user, casterMahou);
            MahouTsukaiTeleporter.teleport((Entity)user, marble, new Vec3((double)pos.m_123341_(), 120.0, (double)pos.m_123343_()));
            if (e != null) {
                IMahou enemyMahou;
                if (e instanceof ServerPlayer && !inmarble && (enemyMahou = Utils.getPlayerMahou((Player)e)) != null) {
                    enemyMahou.setPlayerOldDimension(EffectUtil.getDimension(e.f_19853_).toString());
                    enemyMahou.setPlayerSavedSpawn(user.m_142538_());
                    PlayerManaManager.updateClientMahou((ServerPlayer)e, enemyMahou);
                    enemyMahou.setEnemy(user.m_142081_());
                }
                casterMahou.setEnemy(e.m_142081_());
                MahouTsukaiTeleporter.teleport((Entity)e, marble, new Vec3((double)(pos.m_123341_() + 20), 120.0, (double)pos.m_123343_()));
            }
        }
        return true;
    }

    public static void spawnSwords(BlockPos userSpawn, Level world, ChunkAccess chunk, int size_count, int distance) {
        int startZ;
        int endZ;
        int startX;
        int endX;
        if (random == null) {
            random = new Random(42L);
        }
        int ux = endX = (startX = userSpawn.m_123341_());
        int uz = endZ = (startZ = userSpawn.m_123343_());
        int y = 83;
        startZ -= size_count * distance - random.nextInt(distance);
        endX += size_count * distance + random.nextInt(distance);
        endZ += size_count * distance + random.nextInt(distance);
        ArrayList<WeaponProjectileEntity> spawns = new ArrayList<WeaponProjectileEntity>();
        for (int i = startX -= size_count * distance - random.nextInt(distance); i <= endX; i += distance) {
            for (int j = startZ; j <= endZ; j += distance) {
                boolean inrange;
                boolean bl = inrange = i <= chunk.m_7697_().m_45608_() && i >= chunk.m_7697_().m_45604_() && j <= chunk.m_7697_().m_45609_() && j >= chunk.m_7697_().m_45605_();
                if (MTConfig.MARBLE_SWORD_SPAWN_LIST.size() <= 0 || !inrange) continue;
                double rand = random.nextDouble();
                String name = MTConfig.MARBLE_SWORD_SPAWN_LIST.get(random.nextInt(MTConfig.MARBLE_SWORD_SPAWN_LIST.size()));
                Item item = RealityMarbleSpellEffect.getItemFromName(name);
                if (item == null) {
                    System.out.println("No item with name " + name + " found.");
                    continue;
                }
                ItemStack stack = new ItemStack((ItemLike)item);
                if (0.6 < rand && rand < 0.8) {
                    stack.m_41663_(Enchantments.f_44977_, 2);
                } else if (rand >= 0.8) {
                    stack.m_41663_(Enchantments.f_44980_, 2);
                }
                stack.m_41721_(stack.m_41776_() - MTConfig.MARBLE_DIMENSION_DURABILITY);
                WeaponProjectileEntity wpe = new WeaponProjectileEntity(world, i, y, j, stack);
                double velx = i < ux ? -0.6 : 0.6;
                double velz = j < uz ? -0.6 : 0.6;
                wpe.m_20334_(random.nextDouble() * velx, -2.0, random.nextDouble() * velz);
                if (!(random.nextDouble() < MTConfig.MARBLE_DIMENSION_SPAWN_CHANCE)) continue;
                spawns.add(wpe);
            }
        }
        spawns.forEach(weapon -> {
            if (chunk.m_6415_().m_62427_(ChunkStatus.f_62326_) && world instanceof ServerLevel) {
                chunk.m_6286_((Entity)weapon);
                ((ServerLevel)world).m_7967_((Entity)weapon);
            }
        });
    }

    public static Item getItemFromName(String s) {
        Item ret = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
        return ret;
    }

    public static void realityMarbleChunkUnload(ChunkEvent.Unload event) {
    }

    public static void realityMarbleChunkLoad(ChunkEvent.Load event) {
        LevelAccessor world = event.getChunk().getWorldForge();
        if (world != null && !world.m_5776_() && world instanceof Level && RealityMarbleSpellEffect.inMarble((Level)world)) {
            ChunkAccess c = event.getChunk();
            int x = c.m_7697_().f_45578_ * 16 + 8;
            int z = c.m_7697_().f_45579_ * 16 + 8;
            int y = 100;
            if (c.getWorldForge() instanceof Level) {
                RealityMarbleSpellEffect.spawnSwords(new BlockPos(x, y, z), (Level)c.getWorldForge(), c, 1, MTConfig.MARBLE_DIMENSION_SPAWN_RATE);
            }
        }
    }

    public static boolean realityMarbleLivingFall(LivingFallEvent event) {
        boolean ret = false;
        if (!event.getEntityLiving().f_19853_.f_46443_ && RealityMarbleSpellEffect.inMarble(event.getEntityLiving().f_19853_)) {
            ret = true;
        }
        return ret;
    }

    public static void realityMarbleLivingHurt(Entity e) {
        if (e instanceof Player && !e.f_19853_.f_46443_ && RealityMarbleSpellEffect.inMarble(e.f_19853_)) {
            if (Utils.getPlayerMahou((Player)e) != null) {
                final IMahou mahou = Utils.getPlayerMahou((Player)e);
                if (mahou != null) {
                    if (mahou.getEnemy() != null && e.f_19853_.m_46003_(mahou.getEnemy()) == null) {
                        boolean flag = true;
                        double range = 500.0;
                        List lst = e.f_19853_.m_6443_(LivingEntity.class, new AABB(e.m_142538_().m_142022_(-range, -range, -range), e.m_142538_().m_142022_(range, range, range)), (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

                            public boolean apply(@Nullable LivingEntity e) {
                                return e != null && e.m_142081_().equals(mahou.getEnemy());
                            }
                        });
                        flag = lst.isEmpty();
                        if (flag) {
                            mahou.setEnemy(null);
                        }
                    }
                    if (mahou.getEnemy() == null) {
                        String dimension;
                        BlockPos pos = mahou.getPlayerSavedSpawn();
                        String string = dimension = mahou.getPlayerOldDimension() == null || mahou.getPlayerOldDimension().equals(marble.toString()) ? EffectUtil.getOverworld().toString() : mahou.getPlayerOldDimension();
                        if (pos == null) {
                            pos = ((Player)e).m_21257_().orElse(new BlockPos(0, 0, 0));
                        }
                        MahouTsukaiTeleporter.teleport(e, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), new ResourceLocation(dimension));
                    }
                }
            } else {
                BlockPos bed = ((ServerPlayer)e).m_8961_();
                if (bed == null) {
                    LevelData info = ((ServerPlayer)e).f_19853_.m_6106_();
                    bed = new BlockPos(info.m_6789_(), info.m_6527_(), info.m_6526_());
                }
                MahouTsukaiTeleporter.teleport(e, bed.m_123341_(), bed.m_123342_(), bed.m_123343_(), ((ServerPlayer)e).m_8963_().m_135782_());
            }
        }
    }
}

