/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.familiar;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import stepsword.mahoutsukai.effects.familiar.SummonFamiliarSpellEffect;
import stepsword.mahoutsukai.entity.FamiliarEntity;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class FamiliarsGardenEffect {
    public static boolean familiarGarden(Player caster) {
        if (!caster.f_19853_.f_46443_) {
            FamiliarsGardenEffect.garden(caster);
        }
        return true;
    }

    public static boolean garden(Player caster) {
        FamiliarEntity familiar;
        HashMap<UUID, FamiliarEntity> map;
        if (!caster.f_19853_.f_46443_ && (map = SummonFamiliarSpellEffect.familiarMap).containsKey(caster.m_142081_()) && (familiar = map.get(caster.m_142081_())) != null && familiar.m_6084_()) {
            ChunkPos chunk = new ChunkPos(familiar.m_142538_());
            ServerLevel ws = (ServerLevel)caster.f_19853_;
            if (ws.m_7726_().m_62227_(chunk.f_45578_, chunk.f_45579_, true) != null) {
                familiar.activateGarden();
                return true;
            }
            return false;
        }
        return false;
    }

    public static void familiarsGardenLivingUpdate(LivingEntity target) {
        if (EffectUtil.hasBuff(target, ModEffects.PEACEFUL_GARDEN)) {
            FamiliarsGardenEffect.garden(target);
        }
    }

    public static void garden(LivingEntity target) {
        if (target instanceof Mob) {
            ((Mob)target).m_6710_(null);
            ((Mob)target).m_6703_(null);
            ((Mob)target).f_21345_.m_25386_().forEach(goal -> {
                if (goal.m_26015_() instanceof NearestAttackableTargetGoal) {
                    goal.m_26015_().m_8041_();
                }
                if (goal.m_26015_() instanceof SwellGoal) {
                    goal.m_26015_().m_8041_();
                }
                if (goal.m_26015_().getClass().toString().toLowerCase().contains("attack")) {
                    goal.m_26015_().m_8041_();
                }
            });
        }
    }

    public static boolean familiarsGardenAttackEntity(Entity target, Player player) {
        boolean ret = false;
        if (target instanceof LivingEntity && (EffectUtil.hasBuff((LivingEntity)target, ModEffects.PEACEFUL_GARDEN) || EffectUtil.hasBuff((LivingEntity)player, ModEffects.PEACEFUL_GARDEN))) {
            ret = true;
        }
        return ret;
    }

    public static boolean familiarsGardenExplosion(LivingEntity e) {
        boolean ret = false;
        if (e != null && EffectUtil.hasBuff(e, ModEffects.PEACEFUL_GARDEN)) {
            ret = true;
        }
        return ret;
    }

    public static boolean familiarsGardenLivingDamage(LivingDamageEvent event) {
        boolean ret = false;
        DamageSource src = event.getSource();
        if (src != null) {
            Entity attacker = src.m_7639_();
            LivingEntity target = event.getEntityLiving();
            if (attacker instanceof LivingEntity && EffectUtil.hasBuff((LivingEntity)attacker, ModEffects.PEACEFUL_GARDEN)) {
                ret = true;
            }
            if (target != null && EffectUtil.hasBuff(target, ModEffects.PEACEFUL_GARDEN)) {
                ret = true;
            }
        }
        return ret;
    }
}

