/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import stepsword.mahoutsukai.config.MTConfig;

public class Leylines {
    public static LeyLineShape leyOrientation(BlockPos p) {
        boolean x = Leylines.correctXZval(p, true);
        boolean z = Leylines.correctXZval(p, false);
        int diag = Leylines.diagXZval(p);
        if (x && z) {
            return LeyLineShape.STAR;
        }
        if (x) {
            return LeyLineShape.VERT;
        }
        if (z) {
            return LeyLineShape.HORIZ;
        }
        if (diag == 3) {
            return LeyLineShape.CROSS;
        }
        if (diag == 2) {
            return LeyLineShape.NWD;
        }
        if (diag == 1) {
            return LeyLineShape.NED;
        }
        return LeyLineShape.NONE;
    }

    public static boolean correctXZval(BlockPos p, boolean x) {
        int xval;
        int xmod = MTConfig.LEY_DISTANCE;
        int xoffset = MTConfig.LEY_OFFSET;
        int n = xval = x ? p.m_123341_() % xmod : p.m_123343_() % xmod;
        if ((xoffset %= xmod) < 0) {
            xoffset += xmod;
        }
        if (xval < 0) {
            xval += xmod;
        }
        return xval == xoffset;
    }

    public static int diagXZval(BlockPos p) {
        int xmod = MTConfig.LEY_DISTANCE;
        int xoffset = MTConfig.LEY_OFFSET;
        int xval = p.m_123341_() - (xoffset %= xmod);
        int zval = p.m_123343_() - xoffset;
        zval %= xmod;
        if ((xval %= xmod) == 0) {
            return 0;
        }
        if (xval < 0) {
            xval += xmod;
        }
        if (zval < 0) {
            zval += xmod;
        }
        if (xval == zval && xmod - xval == zval) {
            return 3;
        }
        if (xval == zval) {
            return 2;
        }
        if (xmod - xval == zval) {
            return 1;
        }
        return 0;
    }

    public static int nearbyLeyValue(BlockPos p) {
        int range = 3;
        int ret = 0;
        Stream lst2 = BlockPos.m_121990_((BlockPos)p.m_142082_(-range, 0, -range), (BlockPos)p.m_142082_(range, 0, range));
        Iterator lst = lst2.iterator();
        while (lst.hasNext()) {
            BlockPos z = (BlockPos)lst.next();
            LeyLineShape shape = Leylines.leyOrientation(z);
            if (shape == LeyLineShape.NONE) continue;
            if (shape == LeyLineShape.STAR) {
                ret += 3;
                continue;
            }
            if (shape == LeyLineShape.CROSS) {
                ret += 2;
                continue;
            }
            ++ret;
        }
        return ret;
    }

    public static boolean leyDimensionValid(String dimensionName) {
        boolean blacklist = MTConfig.LEY_BLACKLIST;
        List<? extends String> dims = MTConfig.LEY_DIMENSION_LIST;
        boolean found = false;
        for (int i = 0; i < dims.size(); ++i) {
            if (!dims.get(i).equals(dimensionName)) continue;
            found = true;
        }
        if (found && blacklist) {
            return false;
        }
        if (found) {
            return true;
        }
        return blacklist;
    }

    public static enum LeyLineShape {
        STAR,
        CROSS,
        NWD,
        NED,
        HORIZ,
        VERT,
        NONE;

    }
}

