/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory.wrapper;

import cofh.core.util.helpers.FluidHelper;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class InvWrapperFluids
implements Container {
    private final NonNullList<FluidStack> stackList;
    private final AbstractContainerMenu eventHandler;

    public InvWrapperFluids(AbstractContainerMenu eventHandler, List<FluidStack> contents, int size) {
        this.stackList = NonNullList.m_122780_((int)size, (Object)FluidStack.EMPTY);
        this.eventHandler = eventHandler;
        this.readFromSource(contents);
    }

    public List<FluidStack> getStacks() {
        return this.stackList;
    }

    public void readFromSource(List<FluidStack> contents) {
        this.stackList.clear();
        for (int i = 0; i < Math.min(contents.size(), this.m_6643_()); ++i) {
            this.stackList.set(i, (Object)contents.get(i));
        }
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return stack.m_41619_() || FluidHelper.getFluidContainedInItem(stack).isPresent();
    }

    public int m_6643_() {
        return this.stackList.size();
    }

    public boolean m_7983_() {
        for (FluidStack stack : this.stackList) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < this.m_6643_()) {
            FluidHelper.getFluidContainedInItem(stack).ifPresentOrElse(e -> this.stackList.set(index, e), () -> this.stackList.set(index, (Object)FluidStack.EMPTY));
            this.eventHandler.m_6199_((Container)this);
        }
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.stackList.clear();
    }
}

