/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.util.filter.EmptyFilter;
import cofh.core.util.filter.IFilter;
import cofh.core.util.filter.IFilterableTile;
import cofh.core.util.helpers.AugmentableHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkHooks;

public class FilterHelper {
    private FilterHelper() {
    }

    public static boolean hasFilter(ItemStack stack) {
        return !FilterHelper.getFilterType(stack).isEmpty();
    }

    public static String getFilterType(ItemStack stack) {
        return AugmentableHelper.getPropertyWithDefault(stack, "FilterType", "");
    }

    public static boolean hasFilter(IFilterableTile filterable, int id) {
        IFilter filter = filterable.getFilter(id);
        return filter != null && filter != EmptyFilter.INSTANCE;
    }

    public static void openHeldGui(ServerPlayer player, MenuProvider containerSupplier) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerSupplier, buf -> {
            buf.writeBoolean(true);
            buf.m_130064_(BlockPos.f_121853_);
            buf.writeByte(0);
        });
    }

    public static void openTileGui(ServerPlayer player, MenuProvider containerSupplier, BlockPos pos, int filterId) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerSupplier, buf -> {
            buf.writeBoolean(false);
            buf.m_130064_(pos);
            buf.writeByte(filterId);
        });
    }
}

