/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.filter;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;

public interface IFilter
extends INBTSerializable<CompoundTag>,
MenuProvider {
    public static final Predicate<ItemStack> ALWAYS_ALLOW_ITEM = stack -> true;
    public static final Predicate<FluidStack> ALWAYS_ALLOW_FLUID = stack -> true;

    default public Predicate<ItemStack> getItemRules() {
        return ALWAYS_ALLOW_ITEM;
    }

    default public Predicate<FluidStack> getFluidRules() {
        return ALWAYS_ALLOW_FLUID;
    }

    default public boolean valid(ItemStack item) {
        return this.getItemRules().test(item);
    }

    default public boolean valid(FluidStack fluid) {
        return this.getFluidRules().test(fluid);
    }

    public IFilter read(CompoundTag var1);

    public CompoundTag write(CompoundTag var1);

    default public CompoundTag serializeNBT() {
        return this.write(new CompoundTag());
    }

    default public void deserializeNBT(CompoundTag nbt) {
        this.read(nbt);
    }
}

