/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.control;

import cofh.core.network.packet.server.SideConfigPacket;
import cofh.core.util.control.IReconfigurableTile;
import cofh.core.util.control.ReconfigControlModule;
import cofh.lib.api.control.IReconfigurable;
import cofh.lib.util.Utils;
import java.util.function.Supplier;
import net.minecraft.core.Direction;

public class ReconfigControlModuleLimited
extends ReconfigControlModule {
    public ReconfigControlModuleLimited(IReconfigurableTile tile) {
        super(tile);
    }

    public ReconfigControlModuleLimited(IReconfigurableTile tile, Supplier<Boolean> enabled) {
        super(tile, enabled);
    }

    @Override
    public void disable() {
        this.sides = new IReconfigurable.SideConfig[]{IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE};
        this.tile.onControlUpdate();
    }

    @Override
    public IReconfigurable.SideConfig getSideConfig(int side) {
        if (side > 5) {
            return IReconfigurable.SideConfig.SIDE_NONE;
        }
        return this.sides[side];
    }

    @Override
    public IReconfigurable.SideConfig getSideConfig(Direction side) {
        if (side == null || !this.isReconfigurable()) {
            return IReconfigurable.SideConfig.SIDE_NONE;
        }
        return this.sides[side.ordinal()];
    }

    @Override
    public boolean prevSideConfig(Direction side) {
        if (!this.isReconfigurable() || side == null) {
            return false;
        }
        int ord = side.ordinal();
        this.sides[ord] = this.sides[ord].prev();
        if (this.sides[ord] == IReconfigurable.SideConfig.SIDE_ACCESSIBLE) {
            this.sides[ord] = IReconfigurable.SideConfig.SIDE_BOTH;
        }
        if (Utils.isClientWorld(this.tile.world())) {
            SideConfigPacket.sendToServer(this.tile);
        } else {
            this.tile.onControlUpdate();
        }
        return true;
    }

    @Override
    public boolean nextSideConfig(Direction side) {
        if (!this.isReconfigurable() || side == null) {
            return false;
        }
        int ord = side.ordinal();
        this.sides[ord] = this.sides[ord].next();
        if (this.sides[ord] == IReconfigurable.SideConfig.SIDE_ACCESSIBLE) {
            this.sides[ord] = IReconfigurable.SideConfig.SIDE_NONE;
        }
        if (Utils.isClientWorld(this.tile.world())) {
            SideConfigPacket.sendToServer(this.tile);
        } else {
            this.tile.onControlUpdate();
        }
        return true;
    }
}

