/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.entity;

import cofh.core.init.CoreEntities;
import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import cofh.lib.entity.AbstractAoESpell;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ElectricArc
extends AbstractAoESpell {
    public static final int defaultDuration = 10;
    protected boolean cosmetic = false;
    public float damage = 5.0f;
    public long seed = this.f_19796_.nextLong();

    public ElectricArc(EntityType<? extends ElectricArc> type, Level level) {
        super((EntityType<? extends AbstractAoESpell>)type, level);
        this.radius = 1.5f;
        this.duration = 10;
        this.f_19811_ = true;
    }

    public ElectricArc(Level level, Vec3 pos) {
        this((EntityType<? extends ElectricArc>)((EntityType)CoreEntities.ELECTRIC_ARC.get()), level);
        this.m_20219_(pos);
    }

    public ElectricArc(Level level, Entity target) {
        this(level, target.m_20182_());
    }

    @Override
    public void activeTick() {
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)((SimpleParticleType)CoreParticles.SPARK.get()), this.m_20185_() + this.f_19796_.nextGaussian() * (double)this.radius, this.m_20186_() + (double)(this.f_19796_.nextFloat() * 0.25f), this.m_20189_() + this.f_19796_.nextGaussian() * (double)this.radius, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onCast() {
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)((SimpleParticleType)CoreParticles.PLASMA.get()), this.m_20185_(), this.m_20186_() + 6.0, this.m_20189_(), 0.0, 0.0, 0.0);
        } else {
            this.strike();
        }
    }

    public boolean strike() {
        if (this.cosmetic) {
            return false;
        }
        boolean hitSomething = false;
        for (Entity entity : this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82400_((double)this.radius), Entity::m_6084_)) {
            hitSomething |= this.attack(entity);
        }
        return hitSomething;
    }

    public boolean attack(Entity entity) {
        if (entity.m_6469_(DamageSource.f_19306_, this.damage)) {
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SHOCKED.get(), 100, 0));
            }
            return true;
        }
        return false;
    }

    public ElectricArc setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public ElectricArc setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public ElectricArc setCosmetic(boolean cosmetic) {
        this.cosmetic = cosmetic;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distSqr) {
        double d0 = 64.0 * ElectricArc.m_20150_();
        return distSqr < d0 * d0;
    }
}

