/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.entity;

import cofh.core.entity.AbstractMinecartCoFH;
import cofh.lib.api.IDetonatable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractTNTMinecart
extends AbstractMinecartCoFH
implements IDetonatable {
    protected static final int CLOUD_DURATION = 20;
    protected int radius = 8;
    protected int fuse = -1;
    public int effectAmplifier = 1;
    public int effectDuration = 300;
    protected boolean detonated = false;

    public AbstractTNTMinecart(EntityType<?> type, Level worldIn) {
        super(type, worldIn);
    }

    public AbstractTNTMinecart(EntityType<?> type, Level worldIn, double posX, double posY, double posZ) {
        super(type, worldIn, posX, posY, posZ);
    }

    public BlockState m_6390_() {
        return this.getBlock().m_49966_();
    }

    public void m_8119_() {
        double d0;
        super.m_8119_();
        if (this.fuse > 0) {
            --this.fuse;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        } else if (this.fuse == 0) {
            this.explodeCart(this.m_20184_().m_165925_());
        }
        if (this.f_19862_ && (d0 = this.m_20184_().m_165925_()) >= (double)0.01f) {
            this.explodeCart(d0);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        AbstractArrow arrowEntity;
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractArrow && (arrowEntity = (AbstractArrow)entity).m_6060_()) {
            this.explodeCart(arrowEntity.m_20184_().m_82556_());
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void m_7617_(DamageSource source) {
        double d0 = this.m_20184_().m_165925_();
        if (!(source.m_19384_() || source.m_19372_() || d0 >= (double)0.01f)) {
            this.detonated = true;
            super.m_7617_(source);
            if (!source.m_19372_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                this.m_19998_((ItemLike)this.getBlock());
            }
        } else if (this.fuse < 0) {
            this.ignite();
            this.fuse = this.f_19796_.nextInt(20) + this.f_19796_.nextInt(20);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (distance >= 3.0f) {
            float f = distance / 10.0f;
            this.explodeCart(f * f);
        }
        return super.m_142535_(distance, damageMultiplier, source);
    }

    public void m_6025_(int x, int y, int z, boolean receivingPower) {
        if (receivingPower && this.fuse < 0) {
            this.ignite();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 10) {
            this.ignite();
        } else {
            super.m_7822_(id);
        }
    }

    public float m_7077_(Explosion explosionIn, BlockGetter worldIn, BlockPos pos, BlockState blockStateIn, FluidState p_180428_5_, float p_180428_6_) {
        return !this.isIgnited() || !blockStateIn.m_204336_(BlockTags.f_13034_) && !worldIn.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_13034_) ? super.m_7077_(explosionIn, worldIn, pos, blockStateIn, p_180428_5_, p_180428_6_) : 0.0f;
    }

    public boolean m_7349_(Explosion explosionIn, BlockGetter worldIn, BlockPos pos, BlockState blockStateIn, float p_174816_5_) {
        return (!this.isIgnited() || !blockStateIn.m_204336_(BlockTags.f_13034_) && !worldIn.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_13034_)) && super.m_7349_(explosionIn, worldIn, pos, blockStateIn, p_174816_5_);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Fuse", 99)) {
            this.fuse = compound.m_128451_("Fuse");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Fuse", this.fuse);
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.TNT;
    }

    public void ignite() {
        this.fuse = 80;
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)10);
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public int getFuseTicks() {
        return this.fuse;
    }

    public boolean isIgnited() {
        return this.fuse > -1;
    }

    public abstract Block getBlock();

    protected void explodeCart(double speed) {
        double d0 = Math.sqrt(speed);
        if (d0 > 5.0) {
            d0 = 5.0;
        }
        this.radius = (int)((double)this.radius + (double)((int)this.f_19853_.f_46441_.nextDouble()) * 1.5 * d0);
        this.detonated = true;
        this.explode();
    }

    protected void explode() {
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0, 0.0, 0.0);
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 2.0f, (1.0f + (this.f_19853_.f_46441_.nextFloat() - this.f_19853_.f_46441_.nextFloat()) * 0.2f) * 0.7f, false);
        } else {
            this.detonate(this.m_20182_());
            this.m_146870_();
            this.m_19983_(this.m_142340_());
        }
    }
}

