/*
 * Decompiled with CFR 0.152.
 */
package cofh.core;

import cofh.core.capability.CapabilityArchery;
import cofh.core.capability.CapabilityAreaEffect;
import cofh.core.capability.CapabilityEnchantableItem;
import cofh.core.capability.CapabilityShieldItem;
import cofh.core.client.CoreKeys;
import cofh.core.client.gui.FluidFilterScreen;
import cofh.core.client.gui.ItemFilterScreen;
import cofh.core.command.CoFHCommand;
import cofh.core.compat.curios.CuriosProxy;
import cofh.core.compat.quark.QuarkFlags;
import cofh.core.config.ConfigManager;
import cofh.core.config.CoreClientConfig;
import cofh.core.config.CoreCommandConfig;
import cofh.core.config.CoreEnchantConfig;
import cofh.core.config.CoreServerConfig;
import cofh.core.event.ArmorEvents;
import cofh.core.init.CoreBlocks;
import cofh.core.init.CoreContainers;
import cofh.core.init.CoreEnchantments;
import cofh.core.init.CoreEntities;
import cofh.core.init.CoreFlags;
import cofh.core.init.CoreFluids;
import cofh.core.init.CoreItems;
import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import cofh.core.init.CoreRecipeSerializers;
import cofh.core.init.CoreSounds;
import cofh.core.init.CoreTileEntities;
import cofh.core.network.packet.client.ContainerGuiPacket;
import cofh.core.network.packet.client.EffectAddedPacket;
import cofh.core.network.packet.client.EffectRemovedPacket;
import cofh.core.network.packet.client.IndexedChatPacket;
import cofh.core.network.packet.client.ModelUpdatePacket;
import cofh.core.network.packet.client.PlayerMotionPacket;
import cofh.core.network.packet.client.TileControlPacket;
import cofh.core.network.packet.client.TileGuiPacket;
import cofh.core.network.packet.client.TileRedstonePacket;
import cofh.core.network.packet.client.TileRenderPacket;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.network.packet.server.ClaimXPPacket;
import cofh.core.network.packet.server.ContainerConfigPacket;
import cofh.core.network.packet.server.ItemLeftClickPacket;
import cofh.core.network.packet.server.ItemModeChangePacket;
import cofh.core.network.packet.server.RedstoneControlPacket;
import cofh.core.network.packet.server.SecurityControlPacket;
import cofh.core.network.packet.server.SecurityPacket;
import cofh.core.network.packet.server.SideConfigPacket;
import cofh.core.network.packet.server.StorageClearPacket;
import cofh.core.network.packet.server.TileConfigPacket;
import cofh.core.network.packet.server.TileFilterGuiOpenPacket;
import cofh.core.network.packet.server.TransferControlPacket;
import cofh.core.util.Proxy;
import cofh.core.util.ProxyClient;
import cofh.lib.client.renderer.entity.ElectricArcRenderer;
import cofh.lib.client.renderer.entity.KnifeRenderer;
import cofh.lib.client.renderer.entity.NothingRenderer;
import cofh.lib.client.renderer.entity.model.ArmorFullSuitModel;
import cofh.lib.loot.TileNBTSync;
import cofh.lib.network.PacketHandler;
import cofh.lib.util.DeferredRegisterCoFH;
import cofh.lib.util.Utils;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cofh_core")
public class CoFHCore {
    public static final PacketHandler PACKET_HANDLER = new PacketHandler(new ResourceLocation("cofh_core", "general"));
    public static final Logger LOG = LogManager.getLogger((String)"cofh_core");
    public static final Proxy PROXY = (Proxy)DistExecutor.unsafeRunForDist(() -> ProxyClient::new, () -> Proxy::new);
    public static final ConfigManager CONFIG_MANAGER = new ConfigManager();
    public static final DeferredRegisterCoFH<Block> BLOCKS = DeferredRegisterCoFH.create(ForgeRegistries.BLOCKS, "cofh_core");
    public static final DeferredRegisterCoFH<Fluid> FLUIDS = DeferredRegisterCoFH.create(ForgeRegistries.FLUIDS, "cofh_core");
    public static final DeferredRegisterCoFH<Item> ITEMS = DeferredRegisterCoFH.create(ForgeRegistries.ITEMS, "cofh_core");
    public static final DeferredRegisterCoFH<EntityType<?>> ENTITIES = DeferredRegisterCoFH.create(ForgeRegistries.ENTITIES, "cofh_core");
    public static final DeferredRegisterCoFH<MenuType<?>> CONTAINERS = DeferredRegisterCoFH.create(ForgeRegistries.CONTAINERS, "cofh_core");
    public static final DeferredRegisterCoFH<Enchantment> ENCHANTMENTS = DeferredRegisterCoFH.create(ForgeRegistries.ENCHANTMENTS, "cofh_core");
    public static final DeferredRegisterCoFH<MobEffect> MOB_EFFECTS = DeferredRegisterCoFH.create(ForgeRegistries.MOB_EFFECTS, "cofh_core");
    public static final DeferredRegisterCoFH<ParticleType<?>> PARTICLES = DeferredRegisterCoFH.create(ForgeRegistries.PARTICLE_TYPES, "cofh_core");
    public static final DeferredRegisterCoFH<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegisterCoFH.create(ForgeRegistries.RECIPE_SERIALIZERS, "cofh_core");
    public static final DeferredRegisterCoFH<SoundEvent> SOUND_EVENTS = DeferredRegisterCoFH.create(ForgeRegistries.SOUND_EVENTS, "cofh_core");
    public static final DeferredRegisterCoFH<BlockEntityType<?>> TILE_ENTITIES = DeferredRegisterCoFH.create(ForgeRegistries.BLOCK_ENTITIES, "cofh_core");
    public static boolean curiosLoaded = false;

    public CoFHCore() {
        curiosLoaded = Utils.isModLoaded("curios");
        this.registerPackets();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::entityLayerSetup);
        modEventBus.addListener(this::entityRendererSetup);
        modEventBus.addListener(this::capSetup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addGenericListener(GlobalLootModifierSerializer.class, this::registerLootData);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        BLOCKS.register(modEventBus);
        FLUIDS.register(modEventBus);
        ITEMS.register(modEventBus);
        ENTITIES.register(modEventBus);
        CONTAINERS.register(modEventBus);
        MOB_EFFECTS.register(modEventBus);
        ENCHANTMENTS.register(modEventBus);
        PARTICLES.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        CONFIG_MANAGER.register(modEventBus).addClientConfig(new CoreClientConfig()).addServerConfig(new CoreServerConfig()).addServerConfig(new CoreCommandConfig()).addServerConfig(new CoreEnchantConfig());
        CONFIG_MANAGER.setupClient();
        CONFIG_MANAGER.setupServer();
        CoreBlocks.register();
        CoreFluids.register();
        CoreItems.register();
        CoreEntities.register();
        CoreParticles.register();
        CoreContainers.register();
        CoreMobEffects.register();
        CoreEnchantments.register();
        CoreRecipeSerializers.register();
        CoreSounds.register();
        CoreTileEntities.register();
        CuriosProxy.register();
    }

    private void registerPackets() {
        PACKET_HANDLER.registerPacket(1, TileControlPacket::new);
        PACKET_HANDLER.registerPacket(2, TileGuiPacket::new);
        PACKET_HANDLER.registerPacket(3, TileRedstonePacket::new);
        PACKET_HANDLER.registerPacket(4, TileStatePacket::new);
        PACKET_HANDLER.registerPacket(5, TileRenderPacket::new);
        PACKET_HANDLER.registerPacket(8, ModelUpdatePacket::new);
        PACKET_HANDLER.registerPacket(16, IndexedChatPacket::new);
        PACKET_HANDLER.registerPacket(17, PlayerMotionPacket::new);
        PACKET_HANDLER.registerPacket(20, TileFilterGuiOpenPacket::new);
        PACKET_HANDLER.registerPacket(24, ContainerConfigPacket::new);
        PACKET_HANDLER.registerPacket(25, ContainerGuiPacket::new);
        PACKET_HANDLER.registerPacket(28, SecurityPacket::new);
        PACKET_HANDLER.registerPacket(32, TileConfigPacket::new);
        PACKET_HANDLER.registerPacket(33, SecurityControlPacket::new);
        PACKET_HANDLER.registerPacket(34, RedstoneControlPacket::new);
        PACKET_HANDLER.registerPacket(35, TransferControlPacket::new);
        PACKET_HANDLER.registerPacket(36, SideConfigPacket::new);
        PACKET_HANDLER.registerPacket(37, StorageClearPacket::new);
        PACKET_HANDLER.registerPacket(38, ClaimXPPacket::new);
        PACKET_HANDLER.registerPacket(64, ItemModeChangePacket::new);
        PACKET_HANDLER.registerPacket(65, ItemLeftClickPacket::new);
        PACKET_HANDLER.registerPacket(96, EffectAddedPacket::new);
        PACKET_HANDLER.registerPacket(97, EffectRemovedPacket::new);
    }

    private void registerLootData(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        CoreFlags.manager().setup();
        QuarkFlags.setup();
    }

    private void entityLayerSetup(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ArmorFullSuitModel.ARMOR_FULL_SUIT_LAYER, ArmorFullSuitModel::createBodyLayer);
    }

    private void entityRendererSetup(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)CoreEntities.KNIFE.get(), KnifeRenderer::new);
        event.registerEntityRenderer((EntityType)CoreEntities.ELECTRIC_ARC.get(), ElectricArcRenderer::new);
        event.registerEntityRenderer((EntityType)CoreEntities.ELECTRIC_FIELD.get(), NothingRenderer::new);
    }

    private void capSetup(RegisterCapabilitiesEvent event) {
        CapabilityArchery.register(event);
        CapabilityAreaEffect.register(event);
        CapabilityEnchantableItem.register(event);
        CapabilityShieldItem.register(event);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(TileNBTSync::setup);
        event.enqueueWork(ArmorEvents::setup);
        event.enqueueWork(CoreFluids::setup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)CoreContainers.FLUID_FILTER_CONTAINER.get()), FluidFilterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)CoreContainers.ITEM_FILTER_CONTAINER.get()), ItemFilterScreen::new);
        });
        event.enqueueWork(CoreKeys::register);
        event.enqueueWork(ProxyClient::registerItemModelProperties);
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CoFHCommand.initialize((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

