/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.network.message;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.data.DataManagerWrapper;
import sirttas.dpanvil.data.serializer.IJsonDataSerializer;

public class DataManagerMessage<T> {
    private final ResourceKey<IDataManager<T>> key;
    private final IDataManager<T> manager;
    private final IJsonDataSerializer<T> serializer;
    private Map<ResourceLocation, T> data;

    public DataManagerMessage(ResourceLocation id) {
        this(IDataManager.createManagerKey(id));
    }

    public DataManagerMessage(ResourceKey<? super IDataManager<T>> key) {
        this.key = key;
        this.manager = DataPackAnvil.WRAPPER.getManager(key);
        this.serializer = DataPackAnvil.WRAPPER.getSerializer(key);
        this.data = this.manager.getData();
    }

    public void decode(FriendlyByteBuf buf) {
        try {
            int mapSize = buf.readInt();
            this.data = new HashMap<ResourceLocation, T>(mapSize);
            for (int i = 0; i < mapSize; ++i) {
                this.data.put(buf.m_130281_(), this.serializer.read(buf));
            }
        }
        catch (Exception e) {
            DataPackAnvilApi.LOGGER.error(() -> "Error while decoding network packet for DataManger " + this.key, (Throwable)e);
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.data.size());
        this.data.forEach((loc, prop) -> {
            buf.m_130085_(loc);
            this.serializer.write(prop, buf);
        });
    }

    public void process() {
        try {
            this.manager.setData(this.data);
        }
        catch (Exception e) {
            DataManagerWrapper.logManagerException(this.key, e);
        }
    }

    public ResourceLocation getId() {
        return this.key.m_135782_();
    }
}

