/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.data.DataManagerWrapper;
import sirttas.dpanvil.data.manager.AbstractDataManager;

public class SimpleDataManager<T>
extends AbstractDataManager<T, JsonElement> {
    public SimpleDataManager(Class<T> contentType, String folder, Function<ResourceLocation, T> defaultValueFactory, BiConsumer<T, ResourceLocation> idSetter) {
        super(contentType, folder, defaultValueFactory, idSetter);
    }

    @NotNull
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, @NotNull ProfilerFiller profilerIn) {
        HashMap map = Maps.newHashMap();
        int i = this.folder.length() + 1;
        for (ResourceLocation resourcelocation : resourceManager.m_6540_(this.folder, file -> file.endsWith(".json"))) {
            String path = resourcelocation.m_135815_();
            ResourceLocation resourceId = new ResourceLocation(resourcelocation.m_135827_(), path.substring(i, path.length() - 5));
            try {
                Resource resource = resourceManager.m_142591_(resourcelocation);
                try {
                    InputStream inputstream = resource.m_6679_();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                        JsonElement jsonelement = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                        if (jsonelement != null) {
                            map.put(resourceId, jsonelement);
                            continue;
                        }
                        DataPackAnvilApi.LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourceId, (Object)resourcelocation);
                    }
                    finally {
                        if (inputstream == null) continue;
                        inputstream.close();
                    }
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                DataPackAnvilApi.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourceId, (Object)resourcelocation, (Object)e);
            }
        }
        return map;
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> objects, @NotNull ResourceManager resourceManagerIn, @NotNull ProfilerFiller profilerIn) {
        try {
            HashMap map = Maps.newHashMap();
            Object serializer = DataPackAnvil.WRAPPER.getSerializer(this.key);
            objects.forEach((loc, jsonObject) -> {
                Object value = serializer.read((JsonElement)jsonObject);
                this.idSetter.accept(value, loc);
                map.put(loc, value);
            });
            this.setData(map);
        }
        catch (Exception e) {
            DataManagerWrapper.logManagerException(this.key, e);
        }
    }
}

