/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.data.IDataWrapper;
import sirttas.dpanvil.api.event.DataManagerReloadEvent;
import sirttas.dpanvil.data.manager.DataReference;
import sirttas.dpanvil.data.manager.DefaultDataWrapper;

public abstract class AbstractDataManager<T, U>
extends SimplePreparableReloadListener<Map<ResourceLocation, U>>
implements IDataManager<T> {
    protected static final Gson GSON = new GsonBuilder().create();
    private final Class<T> contentType;
    private final Function<ResourceLocation, T> defaultValueFactory;
    private final Map<ResourceLocation, DefaultDataWrapper<T>> wrappers;
    private final Map<ResourceLocation, DataReference<T>> references;
    private BiMap<ResourceLocation, T> data;
    protected final String folder;
    protected final BiConsumer<T, ResourceLocation> idSetter;
    protected ResourceKey<IDataManager<T>> key;

    protected AbstractDataManager(Class<T> contentType, String folder, Function<ResourceLocation, T> defaultValueFactory, BiConsumer<T, ResourceLocation> idSetter) {
        this.contentType = contentType;
        this.defaultValueFactory = defaultValueFactory;
        this.idSetter = idSetter;
        this.folder = folder;
        this.data = ImmutableBiMap.of();
        this.wrappers = new HashMap<ResourceLocation, DefaultDataWrapper<T>>();
        this.references = new HashMap<ResourceLocation, DataReference<T>>();
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, T> getData() {
        return this.data;
    }

    @Override
    public void setData(@Nonnull Map<ResourceLocation, T> map) {
        map.forEach((loc, value) -> this.idSetter.accept(value, (ResourceLocation)loc));
        this.data = ImmutableBiMap.copyOf(map);
        this.wrappers.values().forEach(w -> w.set(this.get(w.getId())));
        this.rebindReferences();
        DataPackAnvilApi.LOGGER.info("Loaded {} {}", (Object)this.data.size(), this.key);
        MinecraftForge.EVENT_BUS.post(new DataManagerReloadEvent(this));
    }

    @Override
    @Nonnull
    public Class<T> getContentType() {
        return this.contentType;
    }

    @Override
    @Nonnull
    public ResourceLocation getId(T value) {
        return (ResourceLocation)this.data.inverse().getOrDefault(value, (Object)DataPackAnvilApi.ID_NONE);
    }

    @Override
    public T get(@Nonnull ResourceLocation id) {
        Object value = this.data.get((Object)id);
        if (value != null) {
            return (T)value;
        }
        return this.defaultValueFactory.apply(id);
    }

    @Override
    @Nonnull
    public IDataWrapper<T> getWrapper(@Nonnull ResourceLocation id) {
        return this.wrappers.computeIfAbsent(id, i -> {
            DefaultDataWrapper<T> wrapper = new DefaultDataWrapper<T>(id);
            wrapper.set(this.get(id));
            return wrapper;
        });
    }

    @Override
    @Nonnull
    public Holder<T> getOrCreateHolder(@Nonnull ResourceKey<T> key) {
        return this.references.computeIfAbsent(key.m_135782_(), i -> new DataReference<T>(this, key, this.get((ResourceLocation)i)));
    }

    @Override
    @Nonnull
    public String getFolder() {
        return this.folder;
    }

    public void setKey(ResourceKey<IDataManager<T>> key) {
        this.key = key;
    }

    private void rebindReferences() {
        this.references.values().forEach(r -> {
            ResourceLocation l = r.key().m_135782_();
            r.bind(this.createKey(l), this.get(l));
        });
    }

    @Nonnull
    private ResourceKey<T> createKey(ResourceLocation l) {
        return IDataManager.createKey(this.key, l);
    }

    public String toString() {
        return this.key != null ? this.key.toString() : this.folder;
    }
}

