/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.match;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.codec.Codecs;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.dpanvil.api.predicate.block.IBlockStatePredicate;
import sirttas.dpanvil.api.predicate.block.match.MatchBlockPredicate;

public final class MatchBlocksPredicate
implements IBlockStatePredicate {
    public static final String NAME = "blocks";
    @ObjectHolder(value="dpanvil:blocks")
    public static final BlockPosPredicateType<MatchBlocksPredicate> TYPE = null;
    public static final Codec<MatchBlocksPredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codecs.BLOCK.listOf().fieldOf(NAME).forGetter(MatchBlocksPredicate::getBlocks)).apply((Applicative)builder, MatchBlocksPredicate::new));
    private final List<Block> blocks;

    public MatchBlocksPredicate(Block ... blocks) {
        this.blocks = ImmutableList.copyOf((Object[])blocks);
    }

    public MatchBlocksPredicate(Iterable<Block> blocks) {
        this.blocks = ImmutableList.copyOf(blocks);
    }

    @Override
    public boolean test(BlockState state) {
        return this.blocks.contains(state.m_60734_());
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public BlockPosPredicateType<MatchBlocksPredicate> getType() {
        return TYPE;
    }

    @Override
    public IBlockPosPredicate simplify() {
        if (this.blocks.isEmpty()) {
            return IBlockPosPredicate.none();
        }
        if (this.blocks.size() == 1) {
            return new MatchBlockPredicate(this.blocks.get(0));
        }
        return new MatchBlocksPredicate(this.blocks.stream().distinct().toList());
    }
}

