/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.logical;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.dpanvil.api.predicate.block.logical.AbstractListBlockPredicate;
import sirttas.dpanvil.api.predicate.block.logical.AnyBlockPredicate;
import sirttas.dpanvil.api.predicate.block.logical.NoneBlockPredicate;
import sirttas.dpanvil.api.predicate.block.match.MatchBlockPredicate;
import sirttas.dpanvil.api.predicate.block.match.MatchBlocksPredicate;

public final class OrBlockPredicate
extends AbstractListBlockPredicate {
    public static final String NAME = "or";
    @ObjectHolder(value="dpanvil:or")
    public static final BlockPosPredicateType<OrBlockPredicate> TYPE = null;
    public static final Codec<OrBlockPredicate> CODEC = OrBlockPredicate.codec(OrBlockPredicate::new);

    public OrBlockPredicate(IBlockPosPredicate ... predicates) {
        this(Arrays.asList(predicates));
    }

    public OrBlockPredicate(Iterable<IBlockPosPredicate> predicates) {
        super(predicates);
    }

    @Override
    public boolean test(LevelReader world, BlockPos pos) {
        return this.predicates.stream().anyMatch(predicate -> predicate.test(world, pos));
    }

    public BlockPosPredicateType<OrBlockPredicate> getType() {
        return TYPE;
    }

    @Override
    public IBlockPosPredicate or(IBlockPosPredicate ... predicates) {
        return new OrBlockPredicate(this.merge(Lists.newArrayList((Object[])predicates), OrBlockPredicate.class));
    }

    @Override
    public IBlockPosPredicate simplify() {
        List<IBlockPosPredicate> simplified = this.predicates.stream().map(IBlockPosPredicate::simplify).flatMap(p -> {
            Stream<IBlockPosPredicate> stream;
            if (p instanceof OrBlockPredicate) {
                OrBlockPredicate orBlockPredicate = (OrBlockPredicate)p;
                stream = orBlockPredicate.predicates.stream();
            } else {
                stream = Stream.of(p);
            }
            return stream;
        }).filter(p -> !(p instanceof NoneBlockPredicate)).toList();
        if (simplified.isEmpty()) {
            return IBlockPosPredicate.none();
        }
        if (simplified.stream().anyMatch(AnyBlockPredicate.class::isInstance)) {
            return IBlockPosPredicate.any();
        }
        if (simplified.size() == 1) {
            return simplified.get(0);
        }
        if (simplified.stream().allMatch(p -> p instanceof MatchBlockPredicate || p instanceof MatchBlocksPredicate)) {
            return new MatchBlocksPredicate(simplified.stream().flatMap(p -> {
                Stream<Object> stream;
                if (p instanceof MatchBlockPredicate) {
                    MatchBlockPredicate matchBlockPredicate = (MatchBlockPredicate)p;
                    stream = Stream.of(matchBlockPredicate.block());
                } else {
                    stream = ((MatchBlocksPredicate)p).getBlocks().stream();
                }
                return stream;
            }).toList()).simplify();
        }
        return new OrBlockPredicate(simplified);
    }
}

