/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.data;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.dpanvil.api.data.IDataWrapper;

public interface IDataManager<T>
extends PreparableReloadListener,
Codec<T>,
Keyable {
    @Nonnull
    public Class<T> getContentType();

    @Nonnull
    public String getFolder();

    @Nonnull
    public static <T> ResourceKey<T> createKey(@Nonnull ResourceKey<? super IDataManager<T>> managerKey, @Nonnull ResourceLocation id) {
        return DataPackAnvilApi.createResourceKey(managerKey.m_135782_(), id);
    }

    @Nonnull
    public static <T> ResourceKey<IDataManager<T>> createManagerKey(@Nonnull ResourceLocation pLocation) {
        return DataPackAnvilApi.createResourceKey(DataPackAnvilApi.DATA_MANAGER_ROOT, pLocation);
    }

    @Nonnull
    public static <T> Codec<ResourceKey<T>> keyCodec(@Nonnull ResourceKey<? super IDataManager<T>> managerKey) {
        return ResourceLocation.f_135803_.xmap(l -> IDataManager.createKey(managerKey, l), ResourceKey::m_135782_);
    }

    @Nonnull
    public Map<ResourceLocation, T> getData();

    public void setData(@Nonnull Map<ResourceLocation, T> var1);

    @Nonnull
    @Deprecated(since="1.18.2-3.3.3", forRemoval=true)
    public IDataWrapper<T> getWrapper(@Nonnull ResourceLocation var1);

    @Nonnull
    default public Holder<T> getOrCreateHolder(@Nonnull ResourceKey<T> key) {
        return Holder.m_205709_(this.get(key.m_135782_()));
    }

    @Nullable
    default public T get(@Nonnull ResourceLocation id) {
        return this.getData().get(id);
    }

    @Nullable
    default public T getOrDefault(@Nonnull ResourceLocation id, @Nullable T defaultValue) {
        return this.getData().getOrDefault(id, defaultValue);
    }

    @Nonnull
    default public Optional<T> getOptional(@Nonnull ResourceLocation id) {
        return Optional.ofNullable(this.get(id));
    }

    @Nonnull
    default public ResourceLocation getId(@Nullable T value) {
        return this.getData().entrySet().stream().filter(e -> e.getValue().equals(value)).map(Map.Entry::getKey).findAny().orElse(DataPackAnvilApi.ID_NONE);
    }

    @Nonnull
    default public List<T> getAll(@Nonnull Collection<ResourceLocation> ids) {
        return ids.stream().map(this::get).filter(Objects::nonNull).toList();
    }

    default public boolean hasId(@Nonnull ResourceLocation id) {
        return this.getData().containsKey(id);
    }

    default public boolean has(@Nonnull T value) {
        return this.getData().containsValue(value);
    }

    default public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
        return ResourceLocation.f_135803_.decode(ops, input).map(pair -> pair.mapFirst(this::get));
    }

    default public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
        return ResourceLocation.f_135803_.encode((Object)this.getId(input), ops, prefix);
    }

    default public <U> Stream<U> keys(DynamicOps<U> dynOps) {
        return this.getData().keySet().stream().map(id -> dynOps.createString(id.toString()));
    }

    @Nonnull
    public static <T> Builder<T> builder(@Nonnull Class<T> type, @Nonnull String folder) {
        return DataPackAnvilApi.service().createDataManagerBuilder(type, folder);
    }

    public static interface Builder<T> {
        public Builder<T> withIdSetter(BiConsumer<T, ResourceLocation> var1);

        default public Builder<T> withDefault(T defaultValue) {
            return this.withDefault(id -> defaultValue);
        }

        public Builder<T> withDefault(Function<ResourceLocation, T> var1);

        public <R> Builder<T> merged(Function<Stream<R>, T> var1, Function<JsonElement, R> var2);

        default public <R> Builder<T> merged(Function<Stream<R>, T> merger, Decoder<R> rawDecoder) {
            return this.merged(merger, (JsonElement json) -> CodecHelper.decode(rawDecoder, json));
        }

        default public Builder<T> merged(Function<Stream<T>, T> merger) {
            return this.merged(merger, (Function)null);
        }

        public IDataManager<T> build();
    }
}

