/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.Encoder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.dpanvil.api.data.AbstractManagedDataProvider;
import sirttas.dpanvil.api.data.IDataManager;

public abstract class AbstractManagedDataBuilderProvider<T, B>
extends AbstractManagedDataProvider<T> {
    private final Function<B, JsonElement> builder;
    private final Map<ResourceLocation, B> data;

    protected AbstractManagedDataBuilderProvider(DataGenerator generator, IDataManager<T> manager, Encoder<B> encoder) {
        this(generator, manager, (B b) -> CodecHelper.encode(encoder, b));
    }

    protected AbstractManagedDataBuilderProvider(DataGenerator generator, IDataManager<T> manager, Function<B, JsonElement> builder) {
        super(generator, manager);
        this.builder = builder;
        this.data = new HashMap<ResourceLocation, B>();
    }

    public void m_6865_(@Nonnull HashCache cache) throws IOException {
        this.collectBuilders();
        for (Map.Entry<ResourceLocation, B> entry : this.data.entrySet()) {
            this.save(cache, entry.getValue(), entry.getKey());
        }
        this.data.clear();
    }

    protected abstract void collectBuilders();

    protected void add(ResourceKey<T> key, B element) {
        this.add(key.m_135782_(), element);
    }

    protected void add(ResourceLocation id, B element) {
        this.data.compute(id, (k, v) -> {
            if (v != null) {
                throw new IllegalStateException("Duplicate id: " + id + ", manager: " + this.manager);
            }
            return element;
        });
    }

    protected void save(HashCache cache, B element, ResourceKey<T> key) throws IOException {
        this.save(cache, element, key.m_135782_());
    }

    protected void save(HashCache cache, B element, ResourceLocation id) throws IOException {
        this.save(cache, (B)this.builder.apply(element), id);
    }
}

