/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.codec;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import sirttas.dpanvil.api.DataPackAnvilApi;

public class CodecHelper {
    private CodecHelper() {
    }

    public static <T extends IForgeRegistryEntry<T>> Codec<T> getRegistryCodec(Supplier<IForgeRegistry<T>> supplier) {
        return ResourceLocation.f_135803_.comapFlatMap(id -> {
            IForgeRegistry registry = (IForgeRegistry)supplier.get();
            IForgeRegistryEntry value = registry.getValue(id);
            return value != null ? DataResult.success((Object)value) : DataResult.error((String)(id.toString() + " is not present in registry: " + registry.getRegistryName().toString()));
        }, IForgeRegistryEntry::getRegistryName);
    }

    public static <K, V> Codec<Multimap<K, V>> multiMapCodec(Codec<K> keyCodec, Codec<V> valueCodec) {
        return Codec.unboundedMap(keyCodec, (Codec)valueCodec.listOf()).xmap(map -> {
            if (map != null) {
                HashMultimap multiMap = HashMultimap.create();
                map.forEach((arg_0, arg_1) -> ((Multimap)multiMap).putAll(arg_0, arg_1));
                return multiMap;
            }
            return null;
        }, multiMap -> multiMap != null ? multiMap.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Lists.newArrayList((Iterable)((Iterable)e.getValue())))) : null);
    }

    public static <T, F> Codec<T> remapField(Codec<T> codec, MapEncoder<F> fieldEncoder, Function<T, F> fieldGetter) {
        return Codec.of(CodecHelper.remapEncoderField(codec, fieldEncoder, fieldGetter), codec);
    }

    public static <T, F> Codec<T> remapField(Codec<T> codec, MapDecoder<F> fieldDecoder, BiConsumer<T, F> fieldSetter) {
        return Codec.of(codec, CodecHelper.remapDecoderField(codec, fieldDecoder, fieldSetter));
    }

    public static <T, F> Codec<T> remapField(Codec<T> codec, MapCodec<F> fieldCodec, Function<T, F> fieldGetter, BiConsumer<T, F> fieldSetter) {
        return Codec.of(CodecHelper.remapEncoderField(codec, fieldCodec, fieldGetter), CodecHelper.remapDecoderField(codec, fieldCodec, fieldSetter));
    }

    public static <T, F> Encoder<T> remapEncoderField(final Encoder<T> encoder, final MapEncoder<F> fieldEncoder, final Function<T, F> fieldGetter) {
        return new Encoder<T>(){

            public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
                return encoder.encode(input, ops, prefix).flatMap(d -> fieldEncoder.encoder().encode(fieldGetter.apply(input), ops, d));
            }

            public String toString() {
                return encoder.toString() + "FieldEncoderMapped [" + fieldEncoder.toString() + "]";
            }
        };
    }

    public static <T, F> Decoder<T> remapDecoderField(final Decoder<T> decoder, final MapDecoder<F> fieldDecoder, final BiConsumer<T, F> fieldSetter) {
        return new Decoder<T>(){

            public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
                return decoder.decode(ops, input).flatMap(pair -> fieldDecoder.decoder().decode(ops, input).map(fieldPair -> {
                    fieldSetter.accept(pair.getFirst(), fieldPair.getFirst());
                    return pair;
                }));
            }

            public String toString() {
                return decoder.toString() + "FieldDecoderMapped [" + fieldDecoder.toString() + "]";
            }
        };
    }

    public static <T> T decode(Decoder<T> decoder, JsonElement json) {
        return CodecHelper.decode(decoder, JsonOps.INSTANCE, json);
    }

    public static <T> T decode(Decoder<T> decoder, FriendlyByteBuf buf) {
        return CodecHelper.decode(decoder, (Tag)buf.m_130260_());
    }

    public static <T> T decode(Decoder<T> decoder, Tag nbt) {
        return CodecHelper.decode(decoder, NbtOps.f_128958_, nbt);
    }

    public static <T, U> T decode(Decoder<T> decoder, DynamicOps<U> ops, U input) {
        return (T)((Pair)CodecHelper.handleResult(decoder.decode(ops, input))).getFirst();
    }

    public static <T> void encode(Encoder<T> encoder, T data, FriendlyByteBuf buf) {
        Tag nbt = (Tag)CodecHelper.handleResult(encoder.encode(data, (DynamicOps)NbtOps.f_128958_, (Object)NbtOps.f_128958_.empty()));
        if (!(nbt instanceof CompoundTag)) {
            throw new IllegalStateException("Couldn't get a CompoundNBT from the encoder: " + encoder);
        }
        CompoundTag compoundTag = (CompoundTag)nbt;
        buf.m_130079_(compoundTag);
    }

    public static <T> JsonElement encode(Encoder<T> encoder, T data) {
        return (JsonElement)CodecHelper.encode(encoder, JsonOps.INSTANCE, data);
    }

    public static <T, U> U encode(Encoder<T> encoder, DynamicOps<U> ops, T data) {
        return (U)CodecHelper.handleResult(encoder.encode(data, ops, ops.empty()));
    }

    public static <T> T handleResult(DataResult<T> result) {
        return result.resultOrPartial(arg_0 -> ((Logger)DataPackAnvilApi.LOGGER).warn(arg_0)).orElseThrow(() -> new IllegalStateException(result.error().map(DataResult.PartialResult::message).orElse("Error while decoding data, no error message found...")));
    }
}

