/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.GuiTools;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.PacketGridToServer;
import mcjty.rftoolsstorage.craftinggrid.RFCraftingRecipe;
import mcjty.rftoolsstorage.setup.CommandHandler;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;

public class GuiCraftingGrid {
    private static final ResourceLocation GUI = new ResourceLocation("rftoolsstorage", "textures/gui/craftinggrid.png");
    private Window craftWindow;
    private Button craft1Button;
    private Button craft4Button;
    private Button craft8Button;
    private Button craftSButton;
    private Button storeButton;
    private WidgetList recipeList;
    private Minecraft mc;
    private GenericGuiContainer<?, ?> gui;
    private CraftingGridProvider provider;
    private BlockPos pos;
    private ResourceKey<Level> type;
    public static List<Pair<ItemStack, Integer>> testResultFromServer = null;
    private int lastTestAmount = -2;
    private int lastTestTimer = 0;

    public void initGui(SimpleChannel network, Minecraft mc, GenericGuiContainer<?, ?> gui, BlockPos pos, ResourceKey<Level> type, CraftingGridProvider provider, int guiLeft, int guiTop, int xSize, int ySize) {
        this.mc = mc;
        this.gui = gui;
        this.provider = provider;
        this.pos = pos;
        this.type = type;
        this.recipeList = Widgets.list((int)5, (int)5, (int)56, (int)102);
        this.recipeList.event((SelectionEvent)new DefaultSelectionEvent(){

            public void doubleClick(int index) {
                GuiCraftingGrid.this.selectRecipe();
            }
        });
        this.craft1Button = (Button)((Button)Widgets.button((int)29, (int)183, (int)14, (int)10, (String)"1").channel("craft1")).tooltips(new String[]{"Craft one"});
        this.craft4Button = (Button)((Button)Widgets.button((int)45, (int)183, (int)14, (int)10, (String)"4").channel("craft4")).tooltips(new String[]{"Craft four"});
        this.craft8Button = (Button)((Button)Widgets.button((int)29, (int)195, (int)14, (int)10, (String)"8").channel("craft8")).tooltips(new String[]{"Craft eight"});
        this.craftSButton = (Button)((Button)Widgets.button((int)45, (int)195, (int)14, (int)10, (String)"*").channel("craftstack")).tooltips(new String[]{"Craft a stack"});
        this.storeButton = (Button)((Button)Widgets.button((int)5, (int)109, (int)56, (int)14, (String)"Store").channel("store")).tooltips(new String[]{"Store the current recipe"});
        Panel sidePanel = (Panel)Widgets.positional().children(new Widget[]{this.craft1Button, this.craft4Button, this.craft8Button, this.craftSButton, this.storeButton, this.recipeList});
        int sideLeft = guiLeft - 66 - 2;
        int sideTop = guiTop;
        sidePanel.bounds(sideLeft, sideTop, 66, 208);
        sidePanel.background(GUI);
        this.craftWindow = new Window(gui, (AbstractContainerWidget)sidePanel);
        this.craftWindow.event("craft1", (source, params) -> this.craft(1));
        this.craftWindow.event("craft4", (source, params) -> this.craft(4));
        this.craftWindow.event("craft8", (source, params) -> this.craft(8));
        this.craftWindow.event("craftstack", (source, params) -> this.craft(-1));
        this.craftWindow.event("store", (source, params) -> this.store());
    }

    public Window getWindow() {
        return this.craftWindow;
    }

    private void craft(int n) {
        RFToolsStorageMessages.sendToServer("craftFromGrid", TypedMap.builder().put(CommandHandler.PARAM_COUNT, (Object)n).put(CommandHandler.PARAM_TEST, (Object)false).put(CommandHandler.PARAM_POS, (Object)this.pos).put(CommandHandler.PARAM_DIMENSION, this.type));
    }

    private void testCraft(int n) {
        if (this.lastTestAmount != n || this.lastTestTimer <= 0) {
            RFToolsStorageMessages.sendToServer("craftFromGrid", TypedMap.builder().put(CommandHandler.PARAM_COUNT, (Object)n).put(CommandHandler.PARAM_TEST, (Object)true).put(CommandHandler.PARAM_POS, (Object)this.pos).put(CommandHandler.PARAM_DIMENSION, this.type));
            this.lastTestAmount = n;
            this.lastTestTimer = 20;
        }
        --this.lastTestTimer;
    }

    private void store() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        this.provider.storeRecipe(selected);
        RFToolsStorageMessages.INSTANCE.sendToServer((Object)new PacketGridToServer(this.pos, this.type, this.provider.getCraftingGrid()));
    }

    private void selectRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        this.provider.getCraftingGrid().selectRecipe(selected);
        RFToolsStorageMessages.INSTANCE.sendToServer((Object)new PacketGridToServer(this.pos, this.type, this.provider.getCraftingGrid()));
    }

    private void populateList() {
        this.recipeList.removeChildren();
        for (int i = 0; i < 6; ++i) {
            RFCraftingRecipe recipe = this.provider.getCraftingGrid().getRecipe(i);
            this.addRecipeLine(recipe.getResult());
        }
    }

    public void draw(PoseStack matrixStack) {
        int selected = this.recipeList.getSelected();
        this.storeButton.enabled(selected != -1);
        this.populateList();
        this.testRecipe();
        int x = GuiTools.getRelativeX(this.gui);
        int y = GuiTools.getRelativeY(this.gui);
        Widget widget = this.craftWindow.getToplevel().getWidgetAtPosition((double)x, (double)y);
        if (widget == this.craft1Button) {
            this.testCraft(1);
        } else if (widget == this.craft4Button) {
            this.testCraft(4);
        } else if (widget == this.craft8Button) {
            this.testCraft(8);
        } else if (widget == this.craftSButton) {
            this.testCraft(-1);
        } else {
            testResultFromServer = null;
            this.lastTestAmount = -2;
            this.lastTestTimer = 0;
        }
        this.craftWindow.draw(matrixStack);
        if (testResultFromServer != null && !testResultFromServer.isEmpty()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)this.gui.getGuiLeft(), (double)this.gui.getGuiTop(), 0.0);
            for (Pair<ItemStack, Integer> pair : testResultFromServer) {
                AbstractContainerMenu container = this.gui.m_6262_();
                if (!(container instanceof GenericContainer) || (Integer)pair.getRight() <= 0) continue;
                for (int i = 0; i < 9; ++i) {
                    Slot slot = ((GenericContainer)container).getSlotByInventoryAndIndex("grid", 1 + i);
                    if (slot == null || !ItemStack.m_150942_((ItemStack)slot.m_7993_(), (ItemStack)((ItemStack)pair.getLeft()))) continue;
                    GlStateManager.m_84300_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                    int xPos = slot.f_40220_;
                    int yPos = slot.f_40221_;
                    GuiComponent.m_93172_((PoseStack)matrixStack, (int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-65536);
                }
            }
            matrixStack.m_85849_();
        }
    }

    private void testRecipe() {
        CraftingContainer inv = new CraftingContainer(new AbstractContainerMenu(null, -1){

            public boolean m_6875_(@Nonnull Player var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.m_6836_(i, this.provider.getCraftingGrid().getCraftingGridInventory().getStackInSlot(i + 1));
        }
        Optional<CraftingRecipe> recipe = RFCraftingRecipe.findRecipe((Level)this.mc.f_91073_, inv);
        ItemStack newResult = recipe.map(r -> r.m_5874_((Container)inv)).orElse(ItemStack.f_41583_);
        this.provider.getCraftingGrid().getCraftingGridInventory().setStackInSlot(0, newResult);
    }

    private void addRecipeLine(ItemStack craftingResult) {
        String readableName = Tools.getReadableName((ItemStack)craftingResult);
        int color = StyleConfig.colorTextInListNormal;
        if (craftingResult.m_41619_()) {
            readableName = "<recipe>";
            color = -11513776;
        }
        Panel panel = (Panel)Widgets.positional().children(new Widget[]{new BlockRender().renderItem((Object)craftingResult).hint(0, 0, 18, 18), ((Label)((Label)Widgets.label((String)readableName).color(color)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).hint(20, 0, 30, 18)});
        this.recipeList.children(new Widget[]{panel});
    }
}

