/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.part.aspect;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integratedcrafting.IntegratedCrafting;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.core.CraftingHelpers;
import org.cyclops.integratedcrafting.part.PartTypeCraftingWriter;
import org.cyclops.integratedcrafting.part.aspect.CraftingJobData;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.aspect.build.AspectBuilder;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectValuePropagator;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.part.aspect.write.AspectWriteBuilders;

public class CraftingAspectWriteBuilders {
    public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_CHANNEL = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integrateddynamics.integer.channel");
    public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_IGNORE_STORAGE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedcrafting.boolean.ignorestorage");
    public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_IGNORE_CRAFTING = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedcrafting.boolean.ignorecrafting");
    public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CRAFT_MISSING = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedcrafting.boolean.craftmissing");
    public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_CRAFT_AMOUNT = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedcrafting.integer.craftamount");
    public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_CRAFT_DELAY = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedcrafting.integer.craftdelay");
    public static final IAspectProperties PROPERTIES_CRAFTING_RECIPE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_IGNORE_CRAFTING, PROP_CRAFT_MISSING, PROP_CRAFT_AMOUNT));
    public static final IAspectProperties PROPERTIES_CRAFTING = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_IGNORE_STORAGE, PROP_IGNORE_CRAFTING, PROP_CRAFT_MISSING, PROP_CRAFT_DELAY));
    public static final AspectBuilder<ValueObjectTypeRecipe.ValueRecipe, ValueObjectTypeRecipe, Triple<PartTarget, IAspectProperties, IRecipeDefinition>> BUILDER_RECIPE;
    public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, Triple<PartTarget, IAspectProperties, ItemStack>> BUILDER_ITEMSTACK;
    public static final AspectBuilder<ValueObjectTypeFluidStack.ValueFluidStack, ValueObjectTypeFluidStack, Triple<PartTarget, IAspectProperties, FluidStack>> BUILDER_FLUIDSTACK;
    public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER;
    public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ItemStack>, CraftingJobData<ItemStack, Integer>> PROP_ITEMSTACK_CRAFTINGDATA;
    public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, FluidStack>, CraftingJobData<FluidStack, Integer>> PROP_FLUIDSTACK_CRAFTINGDATA;
    public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, CraftingJobData<Long, Boolean>> PROP_ENERGY_CRAFTINGDATA;
    public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, IRecipeDefinition>, Void> PROP_CRAFT_RECIPE;

    public static <T, M> IAspectValuePropagator<CraftingJobData<T, M>, Void> PROP_CRAFT() {
        return input -> {
            IngredientComponent ingredientComponent = input.getIngredientComponent();
            IAspectProperties properties = input.getProperties();
            Object instance = input.getInstance();
            Object matchCondition = ingredientComponent.getMatcher().getExactMatchNoQuantityCondition();
            if (!ingredientComponent.getMatcher().isEmpty(instance)) {
                INetwork network = input.getNetwork();
                ICraftingNetwork craftingNetwork = input.getCraftingNetwork();
                if (craftingNetwork != null) {
                    int channel = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CHANNEL)).getRawValue();
                    boolean ignoreStorage = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_IGNORE_STORAGE)).getRawValue();
                    boolean ignoreCrafting = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_IGNORE_CRAFTING)).getRawValue();
                    boolean craftMissing = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CRAFT_MISSING)).getRawValue();
                    int craftDelay = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CRAFT_DELAY)).getRawValue();
                    if (!(!ignoreStorage && CraftingHelpers.hasStorageInstance(network, channel, ingredientComponent, instance, ingredientComponent.getMatcher().getExactMatchCondition()) || !ignoreCrafting && CraftingHelpers.isCrafting(craftingNetwork, channel, ingredientComponent, instance, matchCondition))) {
                        boolean allowCraft;
                        if (craftDelay > 0 && !ignoreStorage) {
                            PartTypeCraftingWriter.State partState = (PartTypeCraftingWriter.State)PartHelpers.getPart((PartPos)input.getCenter()).getState();
                            long initialTick = partState.getInitialTickCraftingTrigger();
                            long currentTick = input.getCenter().getPos().getLevel(true).m_46467_();
                            if (initialTick >= 0L) {
                                if (currentTick - initialTick >= (long)craftDelay) {
                                    partState.setInitialTickCraftingTrigger(-1L);
                                    allowCraft = true;
                                } else {
                                    allowCraft = false;
                                }
                            } else {
                                partState.setInitialTickCraftingTrigger(currentTick);
                                allowCraft = false;
                            }
                        } else {
                            allowCraft = true;
                        }
                        if (allowCraft) {
                            CraftingHelpers.calculateAndScheduleCraftingJob(network, channel, ingredientComponent, instance, matchCondition, craftMissing, true, CraftingHelpers.getGlobalCraftingJobIdentifier(), null);
                        }
                    } else if (craftDelay > 0) {
                        ((PartTypeCraftingWriter.State)PartHelpers.getPart((PartPos)input.getCenter()).getState()).setInitialTickCraftingTrigger(-1L);
                    }
                }
            }
            return null;
        };
    }

    static {
        PROPERTIES_CRAFTING_RECIPE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
        PROPERTIES_CRAFTING_RECIPE.setValue(PROP_IGNORE_CRAFTING, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
        PROPERTIES_CRAFTING_RECIPE.setValue(PROP_CRAFT_MISSING, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
        PROPERTIES_CRAFTING_RECIPE.setValue(PROP_CRAFT_AMOUNT, (IValue)ValueTypeInteger.ValueInteger.of((int)1));
        PROPERTIES_CRAFTING.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
        PROPERTIES_CRAFTING.setValue(PROP_IGNORE_STORAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
        PROPERTIES_CRAFTING.setValue(PROP_IGNORE_CRAFTING, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
        PROPERTIES_CRAFTING.setValue(PROP_CRAFT_MISSING, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
        PROPERTIES_CRAFTING.setValue(PROP_CRAFT_DELAY, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
        BUILDER_RECIPE = AspectWriteBuilders.BUILDER_RECIPE.byMod((ModBase)IntegratedCrafting._instance).appendKind("craft").handle(AspectWriteBuilders.PROP_GET_RECIPE);
        BUILDER_ITEMSTACK = AspectWriteBuilders.BUILDER_ITEMSTACK.byMod((ModBase)IntegratedCrafting._instance).appendKind("craft").handle(AspectWriteBuilders.PROP_GET_ITEMSTACK);
        BUILDER_FLUIDSTACK = AspectWriteBuilders.BUILDER_FLUIDSTACK.byMod((ModBase)IntegratedCrafting._instance).appendKind("craft").handle(AspectWriteBuilders.PROP_GET_FLUIDSTACK);
        BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedCrafting._instance).appendKind("craft").handle(AspectWriteBuilders.PROP_GET_INTEGER);
        PROP_ITEMSTACK_CRAFTINGDATA = input -> {
            PartTarget partTarget = (PartTarget)input.getLeft();
            IAspectProperties properties = (IAspectProperties)input.getMiddle();
            ItemStack instance = (ItemStack)input.getRight();
            IngredientComponent ingredientComponent = IngredientComponent.ITEMSTACK;
            return new CraftingJobData(properties, ingredientComponent, instance, partTarget.getCenter());
        };
        PROP_FLUIDSTACK_CRAFTINGDATA = input -> {
            PartTarget partTarget = (PartTarget)input.getLeft();
            IAspectProperties properties = (IAspectProperties)input.getMiddle();
            FluidStack instance = (FluidStack)input.getRight();
            IngredientComponent ingredientComponent = IngredientComponent.FLUIDSTACK;
            return new CraftingJobData(properties, ingredientComponent, instance, partTarget.getCenter());
        };
        PROP_ENERGY_CRAFTINGDATA = input -> {
            PartTarget partTarget = (PartTarget)input.getLeft();
            IAspectProperties properties = (IAspectProperties)input.getMiddle();
            Integer instance = (Integer)input.getRight();
            IngredientComponent ingredientComponent = IngredientComponent.ENERGY;
            return new CraftingJobData(properties, ingredientComponent, Long.valueOf(instance.intValue()), partTarget.getCenter());
        };
        PROP_CRAFT_RECIPE = input -> {
            INetwork network;
            ICraftingNetwork craftingNetwork;
            PartPos center = ((PartTarget)input.getLeft()).getCenter();
            IAspectProperties properties = (IAspectProperties)input.getMiddle();
            IRecipeDefinition recipe = (IRecipeDefinition)input.getRight();
            if (recipe != null && (craftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network = CraftingHelpers.getNetworkChecked(center))) != null) {
                int channel = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CHANNEL)).getRawValue();
                int amount = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CRAFT_AMOUNT)).getRawValue();
                boolean ignoreCrafting = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_IGNORE_CRAFTING)).getRawValue();
                boolean craftMissing = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CRAFT_MISSING)).getRawValue();
                if (ignoreCrafting || !CraftingHelpers.isCrafting(craftingNetwork, channel, recipe)) {
                    CraftingHelpers.calculateAndScheduleCraftingJob(network, channel, recipe, amount, craftMissing, true, CraftingHelpers.getGlobalCraftingJobIdentifier(), null);
                }
            }
            return null;
        };
    }
}

